/*
 * Date  : Jun 28, 2011
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */
 
package ips.audio.alsa;

import java.nio.ByteBuffer;
import java.util.Vector;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Control.Type;

/**
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */

public class ALSADataLine implements DataLine {

    public static final boolean DEBUG=false;
    protected ALSAMixerInfo mixerInfo;
    protected DataLine.Info dlInfo;
    
    protected AudioFormat audioFormat;
    
    private ByteBuffer nativePointer;
    private native ByteBuffer nnew();
    protected Vector<LineListener> listeners;
    /**
     * controls of this line (none implemented) 
     */
    private Control[] controls = new Control[0];
    protected boolean open;
    protected boolean active;
    public ALSADataLine(ALSAMixerInfo minfo, Info dlInfo){
        this.mixerInfo=minfo;
        this.dlInfo=dlInfo;
        listeners = new Vector<LineListener>();
        nativePointer=nnew();
    }
    
    public int getCardNumber(){
        return mixerInfo.getCardInfo().getNumber();
    }
    public int getDeviceNumber(){
        return mixerInfo.getDeviceNumber();
    }

    public native boolean nClose(); 

    @Override
    public void close(){
        if(open){
            if(nClose())
            open = false;
            update(new LineEvent(this, LineEvent.Type.CLOSE, getLongFramePosition()));
        }
    }
    
    @Override
    public Control getControl(Type arg0) {
        return null;
    }

    @Override
    public Control[] getControls() {
        return controls;
    }

    @Override
    public javax.sound.sampled.Line.Info getLineInfo() {
       return dlInfo;
    }

    @Override
    public boolean isControlSupported(Type arg0) {
        return false;
    }

    @Override
    public boolean isOpen() {
        
        return open;
    }

    @Override
    public void open() throws LineUnavailableException {
        if (open)
            return;
        open = true;
        update(new LineEvent(this, LineEvent.Type.OPEN, 0));
    }
    @Override
    public native int available();

    @Override
    public void drain() {
        // TODO Auto-generated method stub

    }

    @Override
    public void flush() {
        // TODO Auto-generated method stub

    }

   public native int getBufferSize();

    @Override
    public AudioFormat getFormat() {
       return audioFormat;
    }

    @Override
    public int getFramePosition() {
       
        return (int)getLongFramePosition();
    }

    @Override
    public float getLevel() {
        return AudioSystem.NOT_SPECIFIED;
    }

    @Override
    public native long getLongFramePosition(); 
    
    
    @Override
    public long getMicrosecondPosition() {
        long framePos=getLongFramePosition();
        double sPos = ((double) framePos * 1000000);
        double msPos = sPos / audioFormat.getFrameRate();
        if (DEBUG)
            System.out.println(
                framePos + " " + audioFormat.getFrameRate() + " " + sPos + " " + msPos);

        return (long) msPos;
    }

    @Override
    public boolean isActive() {
        return active;
    }

    @Override
    public boolean isRunning() {
        // TODO not the same
        return active;
    }

    @Override
    public void start(){
        if(!active){
            if(nStart()){
                active=true;
                update(new LineEvent(this, LineEvent.Type.START, getLongFramePosition()));
            }
        }
    }
    public native boolean nStart();

    @Override
    public void stop(){
        if(active){
            if(nStop()){
                active=false;
                update(new LineEvent(this, LineEvent.Type.STOP, getLongFramePosition()));
            }
        }
    }
    public native boolean nStop();

    public boolean isPlugin() {
        return mixerInfo.isPlugin();
    }

    public String getPluginName() {
        return mixerInfo.getPluginName();
    }

    public ByteBuffer getNativePointer() {
        return nativePointer;
    }
    @Override
    public void addLineListener(LineListener listener) {
        synchronized(listeners){
            if (listener != null && !listeners.contains(listener)) {
                listeners.addElement(listener);
            }
        }
    }
    
    
    protected void update(LineEvent le) {
        synchronized(listeners){
            for(LineListener ll:listeners){
                ll.update(le);
            }
        }
    }
    @Override
    public void removeLineListener(LineListener listener) {
        synchronized(listeners){
            if (listener != null) {
                listeners.removeElement(listener);
            }
        }
    }
    public void finalize() throws Throwable{
       if(DEBUG) System.out.println("finalize");
        release();
        super.finalize();
    }

    private native void release();

}
