
package ips.audio.alsa;

import java.util.Vector;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioFormat.Encoding;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

/**
 * Implements the mixer interface for ALSA Java Sound implementation
 * 
 * @author Klaus Jaensch, Institute of Phonetics, klausj@phonetik.uni-muenchen.de
 * 
 */

public class ALSAMixer implements Mixer, Runnable {

	final static boolean DEBUG = false;
	final static int MAX_CHANNELS=64;
	final static int KNOWN_SAMPLE_RATES[] = {
	    5512,
	    8000,
	    11025,
	    16000,
	    22050,
	    32000,
	    44100,
	    48000,
	    64000,
	    88200,
	    96000,
	    176400,
	    192000,
	};
	
	//private String name;
	private ALSAMixerInfo minfo;
	
	boolean open = false;

	private Line.Info linfo;
	private DataLine.Info tlDataLineInfo = null;
	private DataLine.Info slDataLineInfo = null;

	private Control[] controls = new Control[0];
	private ALSATargetDataLine tdl = null;
//	private DSSourceDataLine sdl = null;
//	
	//private AudioFormat[] suppSourceFormats;
	private Vector<AudioFormat> tmpSupportedTargetFormats;
	private Integer hardwareChannels=null;
	private AudioFormat[] suppTargetFormats;

	private static Mixer.Info openedMixerInfo = null;

//	public DSMixer(MixerProvider provider, String driverName) {
//		this.provider = provider;
//		this.name = driverName;
//		//minfo = new DSMixerInfo(driverName + " (DSJavaSound)",false);
//		linfo = new Line.Info(Mixer.class);
//	}


	
//	private DSException nativeException=null;
	
	public ALSAMixer(ALSAMixerInfo minfo){
	    this.minfo=minfo;
	    linfo=new Line.Info(getClass());
	    if(minfo.isPlugin()){
	        enumeratePCMLines(minfo.getPluginName());
	    }else{
	        int cardNumber=minfo.getCardInfo().getNumber();
	        String cardId="hw:"+cardNumber;
	        int devNumber=minfo.getDeviceNumber();
	        hardwareChannels=null;
	        enumeratePCMDevices(cardId, minfo.getDeviceType()+":"+cardNumber+","+devNumber,devNumber);
	        if(minfo.isHardwareDevice()){
	            minfo.setHardwareChannels(hardwareChannels);
	        }
	    }
//	    if(hardwareChannels!=null){
//	        System.out.println("Hardware chs: "+minfo+ " :"+hardwareChannels);
//	        minfo.setHardwareChannels(hardwareChannels);
//	    }
	    if(tmpSupportedTargetFormats!=null && tmpSupportedTargetFormats.size()>0){
	        AudioFormat[] suppFormats=tmpSupportedTargetFormats.toArray(new AudioFormat[0]);
	        try{
	            tlDataLineInfo=new DataLine.Info(TargetDataLine.class,suppFormats,-1,-1);
	        }catch(IllegalArgumentException iae){
	            if(DEBUG)System.out.println("Illegal data line ");

	        }
	    }
	    if(DEBUG)System.out.println("Constructed: "+this);

	}

	public String toString(){
		return "ALSAMixer source: "+minfo;
	}

	public void open() throws LineUnavailableException {

		if (! open)
			return;
		
	
		openedMixerInfo = minfo;
		open = true;
	}


	/**
	 * Initializes the native ALSA driver 
	 * @return true on success
	 */

	public native boolean initialize();
	public native boolean nOpen();
	
	public native double getSampleRate();

	
	public native void enumeratePCMDevices(String cardId,String devName, int devNumber);
	public native void enumeratePCMLines(String devName);
	
	/* Line interface */

	public void addLineListener(LineListener listener) {
	}
	public synchronized void close() {
//		if (tdl != null && tdl.isOpen()) {
//			tdl.close();
//		}
//		tdl = null;
//		if (sdl != null && sdl.isOpen()) {
//			sdl.close();
//		}
//		sdl = null;
	
		open = false;
		openedMixerInfo = null;
		if (DEBUG)
			System.out.println("DSMixer closed (released).");
	}
	public Control getControl(Control.Type control) {

		return null;
	}
	public Control[] getControls() {

		return controls;
	}
	public Line.Info getLineInfo() {
		return linfo;
	}
	public boolean isControlSupported(Control.Type control) {
		return false;
	}
	public boolean isOpen() {
		return open;
	}

	public void removeLineListener(LineListener listener) {
	}

	/* Mixer interface */
	public Line getLine(Line.Info info) throws LineUnavailableException {
//		if (info.matches(linfo))
//			return this;
////
//		if(minfo.isSource()){
//			if(slDataLineInfo==null){
//				getSourceLineInfo();
//			}
//			if (slDataLineInfo != null && info.matches(slDataLineInfo))
//				return sdl;
//		}else{
//		if(tlDataLineInfo==null){
//			getTargetLineInfo();
//		}
//		if (tlDataLineInfo != null && info.matches(tlDataLineInfo))
//			return tdl;
//		}
//	
	    if(info.matches(tlDataLineInfo)){
	        tdl=new ALSATargetDataLine(minfo,tlDataLineInfo);
	        return tdl;
	    }else{
		// TODO check ports
		throw new IllegalArgumentException("No line matching info: "+info+" found");
	    }
		//return null;
	}

	public int getMaxLines(Line.Info info) {
		// TODO for now we only allow one line
		return 1;
	}

	public Mixer.Info getMixerInfo() {
		return minfo;
	}

	public Line.Info[] getSourceLineInfo() {
		
			
		return getSourceLineInfo(null);

	}

	public Line.Info[] getSourceLineInfo(Line.Info info) {
		//n only capture for now
		return new Line.Info[0];
	}

	public Line[] getSourceLines() {
//		if(sdl==null){
//			getSourceLineInfo();
//		}
//		return new Line[]{sdl};
		return new Line[0];
	}
	
	private native void getCaps(byte[] np,boolean source);
	
	
	public Line.Info[] getTargetLineInfo() {
	   
		return getTargetLineInfo(null);
	}
	
//	/**
//	 * Supported channels. This may be more than two.
//	 * See DSCCAPS structure DWORD dwChannels
//	 * @param supportedChannels
//	 */
//	private void setSupportedChannels(int supportedChannels){
//		
//	}
	public synchronized void targetDatalineAvailable(boolean isHardware,int minChannels,int maxChannels,int minRate,int maxrate,int bytes,int bits,boolean signed,boolean bigEndian){
	   
	    for(int knownSampleRate:KNOWN_SAMPLE_RATES){
	        if(knownSampleRate>=minRate && (knownSampleRate<=maxrate || maxrate <0)){
//	        for(int ch=minChannels;ch<=maxChannels && ch <= MAX_CHANNELS;ch++){
	            if(isHardware && maxChannels>0 && minChannels==maxChannels){
	                hardwareChannels=maxChannels;
	            }
	            if(maxChannels==-1){
	                
	                
	            }
	        for(int ch=1;ch<=maxChannels && ch<=MAX_CHANNELS;ch++){
//	            if(ch==MAX_CHANNELS){
//	                System.out.println("Max Channels: "+maxChannels);
//	            }
	            Encoding enc=Encoding.PCM_SIGNED;
	            if(!signed){
	                enc=Encoding.PCM_UNSIGNED;
	            }
	            try{
	            AudioFormat af=new AudioFormat(enc,knownSampleRate,bits,ch,ch*bytes,knownSampleRate,bigEndian);
	            if(af!=null){
	                if(tmpSupportedTargetFormats==null){
	                    tmpSupportedTargetFormats=new Vector<AudioFormat>();
	                }
	            tmpSupportedTargetFormats.add(af);
	            }
	            if(DEBUG)System.out.println("Supported format: "+af);
	            }catch(IllegalArgumentException iae){
	                System.err.println("Illegal format!");
	            }
	            
	           
	        }
	        }
	    }
		
	    }
	

	
	public Line.Info[] getTargetLineInfo(Line.Info info) {

		if(info==null || info.matches(tlDataLineInfo)){
		return new Line.Info[]{tlDataLineInfo};
		}else{
		return new Line.Info[0];
		}
	}

	public Line[] getTargetLines() {

//		if(tdl==null){
//			getTargetLineInfo();
//		}
//		return new Line[]{tdl};
	  return new Line[0];
	}

	public boolean isLineSupported(Line.Info info) {
		
		if (info.matches(linfo))
			return true;
		
		if(TargetDataLine.class.isAssignableFrom(info.getLineClass())){
		getTargetLineInfo();
		if (info.matches(tlDataLineInfo))
			return true;
		}else if(SourceDataLine.class.isAssignableFrom(info.getLineClass())){
			getSourceLineInfo();
			if (info.matches(slDataLineInfo))
				return true;
		}
		return false;
	}

	public boolean isSynchronizationSupported(
		Line[] lines,
		boolean maintainSync) {
		return false;
	}

	public void synchronize(Line[] lines, boolean maintainSync) {
	}

	public void unsynchronize(Line[] lines) {
	}
	/* (non-Javadoc)
	 * @see java.lang.Runnable#run()
	 */
	public void run() {
		if (DEBUG)
			System.out.println("Running shutdown hook...");
		//rt.removeShutdownHook(cleanupThread);	
		close();
		//release();

	}


//	public String getName() {
//		return Charset.forName("ASCII").decode(ByteBuffer.wrap(minfo.getDriverName())).toString();
//	}

//	public DSSourceDataLine getSdl() {
//		return sdl;
//	}

//	public void setSdl(DSSourceDataLine sdl) {
//		this.sdl = sdl;
//	}
	

	
	protected void finalize() throws Throwable{
		System.out.println("Releasing "+this);
		
		super.finalize();
		if(DEBUG)System.out.println("Mixer finalized");
	}

//	public static void main(String args[]) {
//		
//		//Mixer.Info m1=new Mixer.Info("abc","def","ghi","jkl");
//		//Mixer.Info m2=new Mixer.Info("abc","def","ghi","jkl");
//		AudioFormat format =new AudioFormat(44100,16,2,true,true);
//		DataLine.Info tdlInfo = new DataLine.Info(TargetDataLine.class, format);
//		Mixer.Info[] mi = AudioSystem.getMixerInfo();
//		System.out.println("Got mixer infos");
//		for (int i = 0; i < mi.length; i++) {
////			System.out.println("Mixer: " + mi[i]);
////			System.out.println("Description: " + mi[i].getDescription());
////			System.out.println("Class: " + mi[i].getClass().getName());
//			if (mi[i] instanceof DSMixerInfo) {
//				System.out.println("Using/creating IPS DS Mixer: " + mi[i].getName());
//				Mixer mix = AudioSystem.getMixer(mi[i]);
//				TargetDataLine tdl = null;
//				try {
//					tdl = (TargetDataLine) mix.getLine(tdlInfo);
//					tdl.open(format);
//					tdl.start();
////					int av=0;
////					do{
////						av=tdl.available();
////					System.out.println("Available: "+av);
//					Thread.sleep(50);
////					}while(av==0);
//					tdl.stop();
//					tdl.close();
//				} catch (LineUnavailableException e) {
//					System.err.println("Cannot get input line for " + format);
//				} catch (InterruptedException e) {
//					// TODO Auto-generated catch block
//					e.printStackTrace();
//				}
//				mix=null;
//				
////				
////				tdl.start();
//				
//			}
//			
//			
//		}
//		for (int i = 0; i < mi.length; i++) {
//
//			if (mi[i] instanceof DSMixerInfo) {
//				System.out.println("Using IPS DS Mixer: " + mi[i].getName());
//				Mixer mix = AudioSystem.getMixer(mi[i]);
//				Line.Info[] lInfos=mix.getTargetLineInfo();
//				mix=null;
//			}
//			
//			
//		}
//		
//			System.gc();
//			try {
//				Thread.sleep(500);
//			} catch (InterruptedException e) {
//				// TODO Auto-generated catch block
//				e.printStackTrace();
//			}
//			System.gc();
//		System.exit(0);
//	}

//	public DSMixerInfo getMinfo() {
//		return minfo;
//	}
//	

	
}
