/*
 * Date  : Jan 12, 2011
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */
 
package ips.audio.alsa;

import javax.sound.sampled.Mixer.Info;

/**
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */

public class ALSAMixerInfo extends Info {
    public final static String MIXER_NAME_SUFFIX="(AJS)";
    
 
    private ALSACardInfo cardInfo;
    private int deviceNumber;
    private String deviceType;
    private String pluginName;
    private boolean plugin;
    private boolean hardwareDevice;
    private Integer hardwareChannels;
    private boolean defaultDevice=false;
    public boolean isDefaultDevice() {
		return defaultDevice;
	}
	public void setDefaultDevice(boolean defaultDevice) {
		this.defaultDevice = defaultDevice;
	}
	private ALSAMixerInfo hwDeviceInfo=null;
    
    public ALSAMixerInfo(boolean useAJSSuffix) {
       this("default",true,useAJSSuffix);
       defaultDevice=true;
    }
    public ALSAMixerInfo(String deviceName,boolean plugin,boolean useAJSSuffix) {
        super(
            useAJSSuffix?deviceName+" "+MIXER_NAME_SUFFIX:deviceName,
            "",
            "",
            "");
       this.plugin=plugin;
       pluginName=deviceName;
    }
    public ALSAMixerInfo(ALSACardInfo cardInfo,String deviceType,int deviceNumber,boolean hardwareDevice,ALSAMixerInfo hwDevInfo,boolean useAJSSuffix) {
        super(
                useAJSSuffix?cardInfo.getName()+" ["+deviceType+":"+cardInfo.getNumber()+","+deviceNumber+"] "+MIXER_NAME_SUFFIX:
                cardInfo.getName()+" ["+deviceType+":"+cardInfo.getNumber()+","+deviceNumber+"]",
            "",
            "",
            "");
       this.cardInfo=cardInfo;
       this.deviceType=deviceType;
       this.deviceNumber=deviceNumber;
       this.plugin=false;
       this.hardwareDevice=hardwareDevice;
       this.hwDeviceInfo=hwDevInfo;
    }
    public ALSACardInfo getCardInfo() {
        return cardInfo;
    }
    public int getDeviceNumber() {
        return deviceNumber;
    }
    public String getDeviceType() {
        return deviceType;
    }
    public boolean isPlugin() {
        return plugin;
    }
    public String getPluginName() {
        return pluginName;
    }
    
   
    public Integer getHardwareChannels() {
        if(hardwareChannels==null){
            if(hwDeviceInfo!=null){
                return hwDeviceInfo.getHardwareChannels();
            }
        }
        return hardwareChannels;
        
    }
    
    public void setHardwareChannels(Integer hardwareChannels) {
        this.hardwareChannels = hardwareChannels;
//        System.out.println(this+": hardware channels "+hardwareChannels);
    }
    public boolean isHardwareDevice() {
        return hardwareDevice;
    }
    public ALSAMixerInfo getHwDeviceInfo() {
        return hwDeviceInfo;
    }
   

}
