/*
 * Date  : Jan 12, 2011
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */
 
package ips.audio.alsa;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;

import javax.sound.sampled.Mixer;
import javax.sound.sampled.Mixer.Info;
import javax.sound.sampled.spi.MixerProvider;

/**
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */

public class ALSAMixerProvider extends MixerProvider {
    
    final static boolean DEBUG = false;
    public final static String SERVICE_DESCRIPTION_FILE_PATH="ipsk.audio.ajs.MixerProviderServiceDescriptor.xml";
    public final static String NATIVE_LIBRARY_NAME="ips.ajs.alsa.native";
    final static String NATIVE_LIB_LOCATION_KEY="ips.ajs.alsa.native.so";
    final static boolean LIST_DEFAULT_DEVICE=false;
    final static boolean LIST_PLUGINS=false;
    private final static String META_PATH="META-INF";
    private final static String META_SERVICES_PATH=META_PATH+"/services/";
    private boolean useAJSSuffix=false;
  
    
    private static Hashtable<ALSAMixerInfo, ALSAMixer> mixers=new Hashtable<ALSAMixerInfo, ALSAMixer>();
    private static ArrayList<ALSAMixerInfo> infoList=null;
    
    private ALSACardInfo cardInfo;
    
    static {
        String dllLocation=null;
        try{
            dllLocation=System.getProperty(NATIVE_LIB_LOCATION_KEY);    
        }catch(SecurityException se){
            //OK no debug mode, continue
        }
        
        if (dllLocation!=null){
            if(DEBUG)System.out.println("ALSA-Java library loading ... ");
            File dsLib=new File(dllLocation);
            if(!dsLib.exists()){
                System.err.println("ALSAJavaSound library not found!");
            }
            System.load(dllLocation);
            
        }else{
            try{
                // Try 64-bit
                System.loadLibrary(NATIVE_LIBRARY_NAME);
            }catch(Error e1){
            	System.err.println("Error loading ALSA AJS library \""+NATIVE_LIBRARY_NAME+ "\" file: lib"+NATIVE_LIBRARY_NAME+".so");
            }
        }
        if (DEBUG)
            System.out.println("ALSA driver loaded");
        
    }
    
    private native void enumerateCards();
    private native void enumerateDevices(String cardId);
    private native void enumeratePCMHints();
    private native void enumeratePCMConfig();
    
    
    public ALSAMixerProvider(){
        super();
        // path for the declarative XML service descriptor 
        String ajsXmlServiceDescriptorPath=META_SERVICES_PATH+SERVICE_DESCRIPTION_FILE_PATH;
//        URL sdURL=ClassLoader.getSystemResource(ajsXmlServiceDescriptorPath);
        ClassLoader classLoader=getClass().getClassLoader();
        if(classLoader!=null){
        	URL sdURL=classLoader.getResource(ajsXmlServiceDescriptorPath);
            if(sdURL==null){
                // if no XML descriptor found we are in standard JavaSound mode
                // and need the suffix " (AJS)"
                useAJSSuffix=true;
                if(DEBUG)System.out.println(ajsXmlServiceDescriptorPath+" not found. Switching suffix on");
            }
            }
           
        }
        
        public void nextCard(int count,String name){
            if(DEBUG)System.out.println("Found card: "+count+" "+name);
            cardInfo=new ALSACardInfo(count,name);
            enumerateDevices("hw:"+count);
            
        }
    public void nextDevice(int count){
        if(DEBUG)System.out.println("Found device: "+count);
       
//        if(cardInfo==null){
//            ALSAMixerInfo info=new ALSAMixerInfo("default");
//            infoList.add(info);
//        }else{
//            ALSAAJSMixerInfo info=new ALSAAJSMixerInfo(cardInfo, "hw",count,true,null);
            ALSAMixerInfo info=new ALSAMixerInfo(cardInfo, "hw", count, true, null,useAJSSuffix);
            infoList.add(info);
            ALSAMixerInfo pluginfo=new ALSAMixerInfo(cardInfo, "plughw",count,false,info,useAJSSuffix);
          
            infoList.add(pluginfo);
//        }
        
    }
    
    public void nextPluginDevice(String type,String name){
        ALSAMixerInfo info=new ALSAMixerInfo(name,true,useAJSSuffix);
        infoList.add(info);
    }
    @Override
    public synchronized Mixer getMixer(Info info) {
       ALSAMixer mixer=null;
        /*
         * The equals method of Mixer.Info does not work !
         * 
         * if (((Mixer.Info)info).equals(minfos[0])) { System.out.println("Mixer
         * Info matches"); return mixer; }
         */
        
    
        for (int i = 0; i < infoList.size(); i++) {
            ALSAMixerInfo mInfo = infoList.get(i);

            if(mInfo.equals(info)){
                // lookup 
                mixer=mixers.get(mInfo);
                if(mixer==null){
                    // not cached, create new
                
                    mixer=new ALSAMixer(mInfo);
                    mixers.put(mInfo,mixer);
               
                }
                
               
                return mixer;
            }
            
        }
        
        throw new IllegalArgumentException();
        
        
    }

    @Override
    public synchronized Info[] getMixerInfo() {
        Info[] mixerInfos=null;
        
        if(infoList==null){
            infoList=new ArrayList<ALSAMixerInfo>();
            if(LIST_DEFAULT_DEVICE){
            	// add default device
            	ALSAMixerInfo info=new ALSAMixerInfo(useAJSSuffix);
            	infoList.add(info);
            }
            enumerateCards();
            if(LIST_PLUGINS){
                enumeratePCMConfig();
            }
        }
            
               
       mixerInfos=infoList.toArray(new Info[0]);
            
        
      return mixerInfos;
    }

    /**
     * Test 
     * @param args
     */
    public static void main(String[] args) {
        ALSAMixerProvider amp=new ALSAMixerProvider();
        amp.enumerateCards();

    }
 

}
