/*
 * Date  : Jun 28, 2011
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */
 
package ips.audio.alsa;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import javax.sound.sampled.Control.Type;


/**
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */

public class ALSATargetDataLine extends ALSADataLine implements TargetDataLine {
    
	private boolean blockingRead;
	
    public ALSATargetDataLine(ALSAMixerInfo minfo, Info tlDataLineInfo){
        super(minfo,tlDataLineInfo);
        audioFormat=new AudioFormat(44100,16,2,true,false);
    }
    
//    public native void open(int cardNumber,int devNumber,String type, int channels, int samplerate, int j, int k, boolean signed, boolean b);
    public native void open(String pcmName, int channels, int samplerate, int j, int k, int i, boolean signed, boolean b, boolean blockingRead2,int bufferSize);
    
//    @Override
//    public int available() {
//        // TODO Auto-generated method stub
//        return 0;
//    }

    @Override
    public void drain() {
        // TODO Auto-generated method stub

    }

    @Override
    public void flush() {
        // TODO Auto-generated method stub

    }

//    public native int getBufferSize();
//    @Override
//    public int getBufferSize() {
//        return 4 * 60 * 44100 * 4;
//    }

    @Override
    public AudioFormat getFormat() {
        return audioFormat;
    }
    
    @Override
    public void open(AudioFormat af,int bufferSize) throws LineUnavailableException {
        if (open)
            return;
        blockingRead = true;
        AudioFormat.Encoding enc=af.getEncoding();
        boolean signed=true;
        if(AudioFormat.Encoding.PCM_UNSIGNED.equals(enc)){
            signed=false;
        }
        String pcmDevName=null;
        if(mixerInfo.isPlugin()){
            pcmDevName=mixerInfo.getPluginName();
            
//            open(mixerInfo.getPluginName(),af.getChannels(),(int)af.getSampleRate(),af.getFrameSize(),af.getSampleSizeInBits(),signed,af.isBigEndian());
        }else{
            pcmDevName=mixerInfo.getDeviceType()+":"+mixerInfo.getCardInfo().getNumber()+","+mixerInfo.getDeviceNumber();
           
//        open(mixerInfo.getCardInfo().getNumber(),mixerInfo.getDeviceNumber(),mixerInfo.getDeviceType(),
//             af.getChannels(),(int)af.getSampleRate(),af.getFrameSize(),af.getSampleSizeInBits(),signed,af.isBigEndian());
        }
        
        // the default device (with pPulseAudio enabled) hangs on readi 
        // so we use non blocking mode for the default device
        blockingRead=!mixerInfo.isDefaultDevice();
//        blockingRead=false;
        int hardwareChannels=-1; // unknown
        Integer hardwareChannelsFromInfo=mixerInfo.getHardwareChannels();
        if(hardwareChannelsFromInfo!=null){
            hardwareChannels=hardwareChannelsFromInfo;
        }
        if(DEBUG){
        	System.out.println("Open: hardwareChs: "+hardwareChannels+" chs: "+af.getChannels());
        	
        }
        open(pcmDevName,hardwareChannels,af.getChannels(),(int)af.getSampleRate(),af.getFrameSize(),af.getSampleSizeInBits(),signed,af.isBigEndian(),blockingRead,bufferSize);
       super.open();
       audioFormat=af;
    }

    @Override
    public void open(AudioFormat arg0)
            throws LineUnavailableException {
        open(arg0,-1);
    }

    private int byteLenToMs(int len){
    	int ms=(int)(1000*(len/(audioFormat.getFrameRate()*(float)audioFormat.getFrameSize())));
    	return ms;
    }
    public native int nRead(byte[] arg0, int arg1, int arg2);
//    @Override
    public int read(byte[] arg0, int arg1, int arg2) {
    	if(!blockingRead){
    	// non blocking mode
    	int c=0;
    	do{
    		int avail=available();
    		int waitForBytes=arg2-avail;
    		if(waitForBytes>0){
    			int waitMs=byteLenToMs(waitForBytes);
    			try {
    				if(DEBUG)System.out.println("Wait "+(waitMs+10)+" ms.");
					Thread.sleep(waitMs+10);
					c++;
				} catch (InterruptedException e) {
					return 0;
				}
    		}else{
    			if(DEBUG)System.out.println(c+" wait loops.");
    			return nRead(arg0,arg1,arg2);
    		}
    	}while(active);
    	}
    	return nRead(arg0,arg1,arg2);
    }
    
    public void finalize() throws Throwable{
        if(DEBUG)System.out.println("finalize");
        super.finalize();
        
    }
}
