package ips.audio.ds;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

import javax.sound.sampled.Mixer;
import javax.sound.sampled.Mixer.Info;

public class DSMixerInfo extends Info {
	public final static String MIXER_NAME_SUFFIX=" (AJS)";
		boolean source;
		byte[] nativeGUID;
		byte[] driverName;
		public DSMixerInfo(byte[] driverName,boolean source,byte[] nativeGUID,boolean useAJSSuffix) {
			super(
				useAJSSuffix?Charset.defaultCharset().decode(ByteBuffer.wrap(driverName)).toString()+MIXER_NAME_SUFFIX:Charset.defaultCharset().decode(ByteBuffer.wrap(driverName)).toString(),
				"",
				"",
				"");
			this.source=source;
			this.nativeGUID=nativeGUID;
			this.driverName=driverName;
		}
		
		private boolean bothNullOrEqual(String s1,String s2){
			if(s1==null){
				if(s2==null)return true;
			}else{
				return s1.equals(s2);
			}
			return false;
		}
		
		public boolean equals(Mixer.Info mixerInfo){
			//if(!super.equals(mixerInfo))return false;
			if(!(bothNullOrEqual(getName(), mixerInfo.getName()) && 
					bothNullOrEqual(getDescription(), mixerInfo.getDescription()) &&
					bothNullOrEqual(getVendor(), mixerInfo.getVendor()) &&
					bothNullOrEqual(getVersion(), mixerInfo.getVersion())))return false;
			if(! (mixerInfo instanceof DSMixerInfo))return false;
			DSMixerInfo dsMixerInfo=(DSMixerInfo)mixerInfo;
			if(dsMixerInfo.isSource()!=isSource())return false;
			return( Arrays.equals(nativeGUID, dsMixerInfo.getNativeGUID()));
		}
		
		public boolean isSource() {
			return source;
		}

		public byte[] getNativeGUID() {
			return nativeGUID;
		}

		public byte[] getDriverName() {
			return driverName;
		}
		
}
