/*
 * Date  : Jan 12, 2011
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */
 
package ips.audio.pulse;

import javax.sound.sampled.Mixer.Info;

/**
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */

public class PulseMixerInfo extends Info {
    public final static String MIXER_NAME_SUFFIX="(AJS)";
    
    private int cardIdx;
    private String keyName;
    /**
	 * @return the keyName
	 */
	public String getKeyName() {
		return keyName;
	}


	/**
	 * @return the cardIdx
	 */
	public int getCardIdx() {
		return cardIdx;
	}

    
    public PulseMixerInfo(int cardIdx,String keyName,String name,boolean useAJSSuffix) {
        super(
            useAJSSuffix?name+" "+MIXER_NAME_SUFFIX:name,
            "",
            "",
            "");
        this.keyName=keyName;
    }
   
}
