/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.audioeditor.ui;

import ipsk.audio.AudioOptions;
import ipsk.audio.capture.PrimaryRecordTarget;
import ipsk.swing.EnumSelectionItem;
import ipsk.swing.EnumVector;
import ipsk.swing.JDialogPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class AudioOptionsPanel
extends JDialogPanel {
    private AudioOptions audioOptions;
    private EnumVector<PrimaryRecordTarget> primaryRecordTargetVector;
    private JComboBox primaryRecordTargetBox;
    private Insets DEF_INSETS = new Insets(5, 5, 5, 5);

    public AudioOptionsPanel(AudioOptions audioOptions, String defPrimaryRecordTargetDescription) {
        this.audioOptions = audioOptions;
        this.primaryRecordTargetVector = new EnumVector(PrimaryRecordTarget.class, defPrimaryRecordTargetDescription);
        Container content = this.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        content.setLayout(gbl);
        GridBagConstraints cl = new GridBagConstraints();
        GridBagConstraints cv = new GridBagConstraints();
        cl.insets = this.DEF_INSETS;
        cl.anchor = 17;
        cv.insets = this.DEF_INSETS;
        cl.gridx = 0;
        cl.gridy = 0;
        JLabel primaryRecordTargetLabel = new JLabel("Primary record target:");
        content.add((Component)primaryRecordTargetLabel, cl);
        cv.gridx = 1;
        cv.gridy = 0;
        this.primaryRecordTargetBox = new JComboBox<PrimaryRecordTarget>((Vector<PrimaryRecordTarget>)this.primaryRecordTargetVector);
        PrimaryRecordTarget prt = audioOptions.getPrimaryRecordTarget();
        EnumSelectionItem eprt = this.primaryRecordTargetVector.getItem((Enum)prt);
        this.primaryRecordTargetBox.setSelectedItem(eprt);
        content.add((Component)this.primaryRecordTargetBox, cv);
        ++cl.gridy;
        content.add((Component)new JLabel("Line buffer size:"), cl);
        ++cv.gridy;
        String lineBufferSizeString = "n/a";
        Integer lbs = audioOptions.getLineBufferSize();
        if (lbs != null) {
            lineBufferSizeString = lbs.toString();
        }
        JLabel lineBufferSizeLabel = new JLabel(lineBufferSizeString);
        content.add((Component)lineBufferSizeLabel, cv);
    }

    public void applyValues() {
        PrimaryRecordTarget prt = (PrimaryRecordTarget)((EnumSelectionItem)this.primaryRecordTargetBox.getSelectedItem()).getEnumVal();
        this.audioOptions.setPrimaryRecordTarget(prt);
    }
}

