/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.applet;

import ipsk.audio.URLAudioSource;
import ipsk.audio.actions.StartPlayAudioSourceAction;
import ipsk.audio.actions.StopAction;
import ipsk.audio.ui.TransportUI;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;

public class PlayerTransportUIApplet
extends JApplet
implements PropertyChangeListener {
    public static final boolean DEBUG = true;
    public static final String VERSION = PlayerTransportUIApplet.class.getPackage().getImplementationVersion();
    private volatile URL audioURL;
    private TransportUI transportUI = null;
    private StartPlayAudioSourceAction startAction;
    private StopAction stopAction;
    private Status status = Status.EXISTING;
    private boolean bound = false;
    private static final String[][] pInfo = new String[][]{{"url", "url", "Audio URL"}};

    public PlayerTransportUIApplet() throws HeadlessException {
        this.startAction = new StartPlayAudioSourceAction();
        this.startAction.setEnabled(false);
        this.stopAction = new StopAction();
        System.out.println("PlayerTransportUI " + this.hashCode());
    }

    @Override
    public String[][] getParameterInfo() {
        return pInfo;
    }

    @Override
    public String getAppletInfo() {
        return "Audio control applet, Klaus Jaensch, Copyright 2010";
    }

    @Override
    public void init() {
        String audioURLStr = this.getParameter("url");
        if (audioURLStr != null) {
            try {
                this.audioURL = new URL(audioURLStr);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                this.showStatus("Malformed URL: '" + this.audioURL + "'");
                return;
            }
            if (EventQueue.isDispatchThread()) {
                this._init();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            PlayerTransportUIApplet.this._init();
                        }
                    });
                }
                catch (InterruptedException e) {
                    this.showStatus(e.getMessage());
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    this.showStatus(e.getMessage());
                    e.printStackTrace();
                }
            }
        } else {
            this.status = Status.INITIALIZED;
        }
    }

    @Override
    public void start() {
        if (EventQueue.isDispatchThread()) {
            this._start();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        PlayerTransportUIApplet.this._start();
                    }
                });
            }
            catch (InterruptedException e) {
                this.showStatus(e.getMessage());
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                this.showStatus(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void stop() {
        if (EventQueue.isDispatchThread()) {
            this._stop();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        PlayerTransportUIApplet.this._stop();
                    }
                });
            }
            catch (InterruptedException e) {
                this.showStatus(e.getMessage());
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                this.showStatus(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void destroy() {
        if (EventQueue.isDispatchThread()) {
            this._destroy();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        PlayerTransportUIApplet.this._destroy();
                    }
                });
            }
            catch (InterruptedException e) {
                this.showStatus(e.getMessage());
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                this.showStatus(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void _init() {
        URLAudioSource urlAudioSource = new URLAudioSource(this.audioURL);
        this.startAction.setAudioSource(urlAudioSource);
        this.stopAction.setHighlighted(true);
        this.stopAction.setEnabled(false);
        if (this.transportUI == null) {
            this.transportUI = new TransportUI(this.startAction, this.stopAction);
            this.getContentPane().add(this.transportUI);
        }
        this.status = Status.READY;
    }

    public void _start() {
        this.getContentPane().validate();
    }

    public void _stop() {
    }

    public void _destroy() {
        this.getContentPane().removeAll();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String pName;
        if (evt != null && "message".equals(pName = evt.getPropertyName())) {
            String msg = (String)evt.getNewValue();
            if (msg != null) {
                this.showStatus(msg);
            } else {
                this.showStatus("");
            }
        }
    }

    public StartPlayAudioSourceAction getStartAction() {
        return this.startAction;
    }

    public StopAction getStopAction() {
        return this.stopAction;
    }

    public boolean isReady() {
        return this.status != null && this.status.equals((Object)Status.READY);
    }

    public URL getAudioURL() {
        if (this.audioURL == null && !Status.READY.equals((Object)this.status)) {
            this.init();
        }
        return this.audioURL;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void setBound(boolean bound) {
        this.bound = bound;
    }

    public static enum Status {
        EXISTING,
        INITIALIZED,
        READY,
        APPLET_STOPPED,
        APPLET_DESTROYED;

    }
}

