/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.bean;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.PluginChain;
import ipsk.audio.URLAudioSource;
import ipsk.audio.VectorBufferAudioSource;
import ipsk.audio.actions.LoopAction;
import ipsk.audio.actions.PauseAction;
import ipsk.audio.actions.StartPlaybackAction;
import ipsk.audio.actions.StopAction;
import ipsk.audio.arr.Selection;
import ipsk.audio.arr.clip.AudioClip;
import ipsk.audio.arr.clip.AudioClipListener;
import ipsk.audio.arr.clip.events.AudioClipChangedEvent;
import ipsk.audio.arr.clip.events.SelectionChangedEvent;
import ipsk.audio.arr.clip.ui.AudioClipScrollPane;
import ipsk.audio.arr.clip.ui.AudioClipUI;
import ipsk.audio.arr.clip.ui.AudioClipUIContainer;
import ipsk.audio.arr.clip.ui.AudioSignalUI;
import ipsk.audio.arr.clip.ui.AudioTimeScaleUI;
import ipsk.audio.arr.clip.ui.FourierUI;
import ipsk.audio.arr.clip.ui.FragmentActionBarUI;
import ipsk.audio.dsp.AudioClipDSPInfo;
import ipsk.audio.dsp.AudioClipProcessor;
import ipsk.audio.dsp.ui.AudioClipDSPInfoViewer;
import ipsk.audio.events.StartPlaybackActionEvent;
import ipsk.audio.mixer.MixerManager;
import ipsk.audio.player.Player;
import ipsk.audio.player.PlayerException;
import ipsk.audio.player.PlayerListener;
import ipsk.audio.player.event.PlayerCloseEvent;
import ipsk.audio.player.event.PlayerEvent;
import ipsk.audio.player.event.PlayerPauseEvent;
import ipsk.audio.player.event.PlayerStartEvent;
import ipsk.audio.player.event.PlayerStopEvent;
import ipsk.audio.plugins.ChannelSelectorPlugin;
import ipsk.audio.ui.TransportUI;
import ipsk.awt.ProgressListener;
import ipsk.awt.PropertyChangeAWTEventTransferAgent;
import ipsk.awt.Worker;
import ipsk.awt.WorkerException;
import ipsk.awt.event.ProgressErrorEvent;
import ipsk.awt.event.ProgressEvent;
import ipsk.io.VectorBuffer;
import ipsk.io.VectorBufferedOutputStream;
import ipsk.net.URLContentLoader;
import ipsk.swing.JPopupMenuListener;
import ipsk.swing.JProgressDialogPanel;
import ipsk.swing.action.tree.ActionFolder;
import ipsk.swing.action.tree.ActionGroup;
import ipsk.swing.action.tree.ActionList;
import ipsk.swing.action.tree.ActionNode;
import ipsk.swing.action.tree.ActionTreeRoot;
import ipsk.swing.action.tree.JMenuBuilder;
import ipsk.util.LocalizableMessage;
import ipsk.util.ProgressStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class AudioPlayerBean
extends JPanel
implements ActionListener,
PlayerListener,
AudioClipListener,
ProgressListener {
    public static final boolean DEBUG = false;
    public static final int DEF_UPDATE_INTERVALL_MS = 200;
    public static final String VERSION = AudioPlayerBean.class.getPackage().getImplementationVersion();
    private static final Float PREFERRED_LINE_BUFFER_SIZE_MILLIS = Float.valueOf(1000.0f);
    protected URL source;
    protected PropertyChangeAWTEventTransferAgent pChTa = new PropertyChangeAWTEventTransferAgent();
    private VectorBufferedOutputStream vbOut;
    private URLContentLoader urlContentLoader;
    private JProgressDialogPanel progressPanel;
    protected AudioSource audioSource;
    protected AudioClipUIContainer uiContainer;
    protected AudioClip audioClip;
    private JPanel playerPanel;
    private Player player;
    protected AudioSource playbackSource;
    private Timer updateTimer;
    private Mixer device;
    protected AudioSignalUI signalUI = null;
    private AudioClipScrollPane scrollPane;
    private boolean autoPlayOnLoad = false;
    protected boolean visualizing;
    private boolean showDSPInfo = false;
    private boolean showSonagram = true;
    private boolean showFragmentActionBar = true;
    private boolean showTimeScale = true;
    private Selection selection;
    private boolean startPlayOnSelect;
    private JComboBox channelSelectBox;
    private int channels;
    private FourierUI sonagram;
    private Vector<AudioClipUI> additionalAudioClipUIPluginList = new Vector();
    private FragmentActionBarUI fragmentActionBar;
    private AudioTimeScaleUI timeScale;
    private volatile Status status = null;
    private String message;
    private StartPlaybackAction startAction;
    private StopAction stopAction;
    private PauseAction pauseAction;
    private LoopAction loopAction;
    private AudioClipProcessor processor;
    private AudioClipDSPInfoViewer infoView;

    public AudioPlayerBean() {
        this((AudioClip)null);
    }

    public AudioPlayerBean(AudioClip audioClip) {
        super(new BorderLayout());
        this.audioClip = audioClip;
        if (this.audioClip == null) {
            this.audioClip = new AudioClip();
        }
        this.audioClip.addAudioSampleListener(this);
        this.processor = new AudioClipProcessor(this.audioClip);
        this.processor.setCalculateSBNR(true);
        try {
            MixerManager mm = new MixerManager();
            Mixer[] devices = mm.getDirectPlaybackMixers();
            if (devices != null && devices.length > 0) {
                this.device = devices[0];
                this.player = new Player(this.device);
            } else {
                this.player = new Player();
            }
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
        if (this.player == null) {
            this.player = new Player();
        }
        if (this.player != null) {
            this.player.setPreferredLineBufferSizeMillis(PREFERRED_LINE_BUFFER_SIZE_MILLIS);
            this.player.setMeasureLevel(false);
            this.player.addPlayerListener(this);
        }
        this.playerPanel = new JPanel();
        this.startAction = new StartPlaybackAction();
        this.stopAction = new StopAction();
        this.pauseAction = new PauseAction();
        this.loopAction = new LoopAction();
        this.startAction.setEnabled(false);
        this.stopAction.setEnabled(false);
        this.pauseAction.setEnabled(false);
        this.startAction.addActionListener(this);
        this.stopAction.addActionListener(this);
        this.pauseAction.addActionListener(this);
        this.loopAction.addActionListener(this);
        TransportUI tp = new TransportUI(this.startAction, this.stopAction, this.pauseAction, this.loopAction);
        this.playerPanel.add(tp);
        this.add((Component)this.playerPanel, "South");
        this.updateTimer = new Timer(200, this);
        this.setMessage("Audio player initialized.");
        this.changeStatus(Status.INITIALIZED);
    }

    public void addAudioClipUI(AudioClipUI audioClipUI) {
        this.additionalAudioClipUIPluginList.add(audioClipUI);
        this.uiContainer.add((Component)((Object)audioClipUI));
    }

    private void createPopupMenu() {
        ActionTreeRoot ascActionTree = this.scrollPane.getActionTreeRoot();
        ActionFolder signalViewFolder = new ActionFolder("signalview", new LocalizableMessage("Signal view"));
        ActionTreeRoot shiftedAscActionTree = ascActionTree.shiftFromTopLevel(signalViewFolder);
        ActionTreeRoot afft = new ActionTreeRoot();
        ActionFolder avf = ActionFolder.buildTopLevelFolder((String)"view");
        ActionGroup subjectViewGroup = new ActionGroup("view.subjectGroup");
        avf.add((ActionNode)subjectViewGroup);
        afft.add((ActionNode)avf);
        afft.merge((ActionList)shiftedAscActionTree);
        JMenuBuilder pmb = new JMenuBuilder((ActionFolder)ascActionTree);
        JPopupMenu pm = pmb.buildJPopupMenu();
        JPopupMenuListener pml = new JPopupMenuListener(pm);
        this.scrollPane.addMouseListener((MouseListener)pml);
        this.uiContainer.addPopupMouseListener((MouseListener)pml);
    }

    public void setSource(String sourceUrlString) throws MalformedURLException {
        URL sourceURL = new URL(sourceUrlString);
        this.setURL(sourceURL);
    }

    public URL getSource() {
        return this.source;
    }

    public void setURL(URL url) {
        this.setSource(url);
    }

    public void setSource(URL source) {
        URL oldUrl = this.source;
        if (this.source != null && this.source.equals(source)) {
            return;
        }
        if (this.audioClip != null) {
            this.audioClip.setAudioSource(null);
        }
        this.source = source;
        this.closeAudio();
        this.selection = null;
        this.startAction.setEnabled(false);
        this.stopAction.setEnabled(false);
        this.closeDownload();
        this.vbOut = null;
        this.clearScreen();
        this.load();
        this.pChTa.fireEvent((EventObject)new PropertyChangeEvent(this, "source", oldUrl, this.source));
    }

    private void load() {
        this.clearScreen();
        String urlProtocol = this.source.getProtocol();
        if (urlProtocol.equalsIgnoreCase("file")) {
            this.audioSource = new URLAudioSource(this.source);
            if (this.visualizing && this.scrollPane != null) {
                this.scrollPane.setPreferredSize(new Dimension(200, 100));
            }
            try {
                this.process();
            }
            catch (AudioSourceException e) {
                JOptionPane.showMessageDialog(this, "Could not process audio file: " + e.getMessage(), "Audio processing error", 0);
                return;
            }
            this.enableAudio();
            this.makeReady();
            if (this.autoPlayOnLoad) {
                this.playSelection();
            }
        } else {
            this.changeStatus(Status.LOADING);
            this.vbOut = new VectorBufferedOutputStream();
            this.urlContentLoader = new URLContentLoader(this.source, (OutputStream)this.vbOut, "URL content loader");
            if (this.visualizing) {
                this.progressPanel = new JProgressDialogPanel((Worker)this.urlContentLoader, "title", "Loading audio ...");
                this.add((Component)this.progressPanel, "Center");
            }
            this.revalidate();
            this.repaint();
            this.urlContentLoader.addProgressListener((ProgressListener)this);
            try {
                this.urlContentLoader.open();
            }
            catch (WorkerException e) {
                e.printStackTrace();
            }
            this.urlContentLoader.start();
        }
    }

    private void clearScreen() {
        if (this.progressPanel != null) {
            this.remove((Component)this.progressPanel);
        }
        if (this.scrollPane != null) {
            this.remove(this.scrollPane);
        }
    }

    private void process() throws AudioSourceException {
        this.changeStatus(Status.PROCESS);
        this.clearScreen();
        this.playbackSource = this.audioSource;
        this.setMessage("Processing audio data ...");
        if (this.infoView != null) {
            this.remove(this.infoView);
        }
        if (this.visualizing) {
            this.audioClip.setAudioSource(this.audioSource);
            this.audioClip.setSelection(this.selection);
            this.add((Component)this.scrollPane, "Center");
            if (this.showDSPInfo) {
                this.setMessage("Processing audio data ...");
                try {
                    this.processor.process();
                }
                catch (AudioSourceException e) {
                    e.printStackTrace();
                    this.setMessage("Error processing audio data.");
                    return;
                }
                AudioClipDSPInfo dspInfo = this.audioClip.getClipDSPInfo();
                this.infoView = new AudioClipDSPInfoViewer(dspInfo);
                this.add((Component)this.infoView, "North");
            }
            this.validate();
        }
        this.channels = this.audioSource.getFormat().getChannels();
        if (this.channelSelectBox != null) {
            this.channelSelectBox.removeActionListener(this);
            this.playerPanel.remove(this.channelSelectBox);
        }
        if (this.channels > 1) {
            String[] channelStrs = new String[this.channels + 1];
            channelStrs[0] = "All";
            for (int chI = 1; chI <= this.channels; ++chI) {
                channelStrs[chI] = "Ch. " + Integer.toString(chI);
            }
            this.channelSelectBox = new JComboBox<String>(channelStrs);
            this.channelSelectBox.setSelectedIndex(0);
            this.channelSelectBox.addActionListener(this);
            this.playerPanel.add(this.channelSelectBox);
        }
        this.playerPanel.validate();
        if (this.visualizing) {
            this.uiContainer.xZoomFitToPanel();
        }
        if (this.uiContainer != null) {
            this.uiContainer.validate();
        }
        this.validate();
        if (this.scrollPane != null) {
            this.scrollPane.revalidate();
            this.scrollPane.repaint();
        }
    }

    private void enableAudio() {
        if (this.audioClip != null) {
            if (this.player != null) {
                try {
                    this.player.setAudioSource(this.playbackSource);
                    this.startAction.setEnabled(true);
                    this.stopAction.setHighlighted(true);
                    this.updateTimer.start();
                }
                catch (PlayerException e) {
                    e.printStackTrace();
                    this.setMessage("Could not set playback audio source !");
                }
            } else {
                this.setMessage("No audio player available.");
            }
        } else {
            this.setMessage("No audio clip available.");
        }
    }

    public void makeReady() {
        this.revalidate();
        this.repaint();
        this.changeStatus(Status.READY);
        this.setMessage("Audio player ready.");
    }

    private void closeAudio() {
        this.updateTimer.stop();
        this.startAction.setEnabled(false);
        if (this.player != null) {
            try {
                this.player.close();
                this.setMessage("Audio player closed.");
            }
            catch (PlayerException e) {
                e.printStackTrace();
                this.setMessage("Could not close audio player !");
            }
        }
        this.audioSource = null;
        try {
            this.player.setAudioSource(null);
        }
        catch (PlayerException e) {
            e.printStackTrace();
        }
        if (this.visualizing) {
            this.audioClip.setAudioSource(null);
        }
    }

    private void closeDownload() {
        if (this.urlContentLoader != null) {
            this.urlContentLoader.removeProgressListener((ProgressListener)this);
            this.urlContentLoader.cancel();
            try {
                this.urlContentLoader.close();
                this.urlContentLoader.reset();
            }
            catch (WorkerException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object src = arg0.getSource();
        String actionCommand = arg0.getActionCommand();
        if (src == this.updateTimer) {
            if (this.visualizing) {
                this.audioClip.setFramePosition(this.player.getFramePosition());
            }
        } else if (actionCommand == StartPlaybackAction.ACTION_COMMAND) {
            if (arg0 instanceof StartPlaybackActionEvent) {
                StartPlaybackActionEvent spae = (StartPlaybackActionEvent)arg0;
                this.player.setStartFramePosition(spae.getStartFramePosition());
                this.player.setStopFramePosition(spae.getStopFramePosition());
                if (this.player != null && !this.player.isOpen()) {
                    try {
                        this.player.open();
                        this.setMessage("Audio player open.");
                        this.player.play();
                    }
                    catch (PlayerException e) {
                        e.printStackTrace();
                        this.setMessage("Cannot play audio !");
                    }
                }
            } else {
                this.playSelection();
            }
        } else if (actionCommand == StopAction.ACTION_COMMAND) {
            this.player.stop();
        } else if (actionCommand == PauseAction.ACTION_COMMAND) {
            this.player.pause();
        } else if (actionCommand == LoopAction.ACTION_COMMAND) {
            this.player.setLooping((Boolean)this.loopAction.getValue("SwingSelectedKey"));
        } else if (src == this.channelSelectBox) {
            int si = this.channelSelectBox.getSelectedIndex();
            AudioSource newPlaybackSource = null;
            if (si == 0) {
                newPlaybackSource = this.audioSource;
            } else {
                PluginChain pCh = new PluginChain(this.audioSource);
                try {
                    pCh.add(new ChannelSelectorPlugin(si - 1));
                }
                catch (AudioFormatNotSupportedException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Could not select audio channel\n" + e.getMessage(), "Audio format error", 0);
                }
                newPlaybackSource = pCh;
            }
            if (newPlaybackSource != null) {
                this.playbackSource = newPlaybackSource;
                try {
                    this.player.close();
                    this.player.setAudioSource(this.playbackSource);
                }
                catch (PlayerException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Could not close audio player\n" + e.getMessage(), "Player close error", 0);
                }
            }
        }
    }

    @Override
    public void update(PlayerEvent playerEvent) {
        if (playerEvent instanceof PlayerStartEvent) {
            this.setMessage("Audio player playing...");
            this.stopAction.setEnabled(true);
            this.stopAction.setHighlighted(false);
            this.pauseAction.setEnabled(true);
            this.pauseAction.setHighlighted(false);
            this.startAction.setEnabled(false);
            this.startAction.setHighlighted(true);
        } else if (playerEvent instanceof PlayerPauseEvent) {
            this.setMessage("Audio player paused.");
            this.stopAction.setEnabled(true);
            this.stopAction.setHighlighted(false);
            this.pauseAction.setEnabled(true);
            this.pauseAction.setHighlighted(true);
            this.startAction.setEnabled(false);
            this.startAction.setHighlighted(true);
        } else if (playerEvent instanceof PlayerStopEvent) {
            if (Status.READY.equals((Object)this.status)) {
                this.stopAction.setEnabled(false);
                this.stopAction.setHighlighted(true);
                this.pauseAction.setEnabled(false);
                this.pauseAction.setHighlighted(false);
                this.startAction.setEnabled(false);
                this.startAction.setHighlighted(false);
                this.setMessage("Audio player stopped.");
            }
            this.setMessage("Audio player stopped.");
            try {
                this.player.close();
            }
            catch (PlayerException e) {
                e.printStackTrace();
                this.setMessage("Could not close audio player !");
            }
        } else if (playerEvent instanceof PlayerCloseEvent) {
            if (Status.READY.equals((Object)this.status)) {
                this.stopAction.setEnabled(false);
                this.stopAction.setHighlighted(true);
                this.startAction.setEnabled(true);
                this.startAction.setHighlighted(false);
            } else if (!Status.CLOSING.equals((Object)this.status)) {
                this.setMessage("Internal error state ");
            }
            this.setMessage("Audio player closed.");
        }
    }

    @Override
    public void audioClipChanged(AudioClipChangedEvent event) {
        if (event instanceof SelectionChangedEvent) {
            SelectionChangedEvent selEvent = (SelectionChangedEvent)event;
            Selection s = selEvent.getSelection();
            if (this.player == null) {
                return;
            }
            if (this.audioClip != null) {
                if (s != null) {
                    this.player.setStartFramePosition(s.getLeft());
                    this.player.setStopFramePosition(s.getRight());
                    if (this.startPlayOnSelect && !this.player.isOpen()) {
                        try {
                            this.player.open();
                            this.setMessage("Audio player open.");
                            this.player.play();
                        }
                        catch (PlayerException e) {
                            e.printStackTrace();
                            this.setMessage("Cannot play audio !");
                        }
                    }
                } else {
                    this.player.setStartFramePosition(0L);
                    this.player.setStopFramePosition(-1L);
                }
            }
            Selection oldSel = this.selection;
            this.selection = s;
            PropertyChangeEvent selChEv = new PropertyChangeEvent(this, "selection", oldSel, this.selection);
            this.pChTa.fireEvent((EventObject)selChEv);
        }
    }

    private void changeStatus(Status newStatus) {
        Status oldStatus = this.status;
        this.status = newStatus;
        PropertyChangeEvent stChEv = new PropertyChangeEvent(this, "status", (Object)oldStatus, (Object)this.status);
        this.pChTa.fireEvent((EventObject)stChEv);
    }

    public void close() {
        this.changeStatus(Status.CLOSING);
        this.closeAudio();
        this.closeDownload();
        if (this.updateTimer != null) {
            this.updateTimer.stop();
        }
        if (this.uiContainer != null) {
            this.uiContainer.close();
        }
        if (this.audioClip != null) {
            this.audioClip.removeAudioSampleListener(this);
        }
        this.clearScreen();
        this.changeStatus(Status.CLOSED);
    }

    public void setSelection(Selection selection) {
        this.selection = selection;
        this.audioClip.setSelection(selection);
    }

    public Selection getSelection() {
        if (this.audioClip != null) {
            return this.audioClip.getSelection();
        }
        return this.selection;
    }

    private void playSelection() {
        if (this.player == null || this.player.isOpen()) {
            return;
        }
        if (this.audioClip != null) {
            Selection s = this.audioClip.getSelection();
            if (s != null) {
                this.player.setStartFramePosition(s.getLeft());
                this.player.setStopFramePosition(s.getRight());
            } else {
                this.player.setStartFramePosition(0L);
                this.player.setStopFramePosition(-1L);
            }
            try {
                this.player.open();
                this.setMessage("Audio player open.");
                this.player.play();
            }
            catch (PlayerException e) {
                e.printStackTrace();
                this.setMessage("Cannot play audio !");
            }
        }
    }

    public void update(ProgressEvent progressEvent) {
        ProgressStatus status = progressEvent.getProgressStatus();
        if (progressEvent instanceof ProgressErrorEvent) {
            if (this.progressPanel != null) {
                this.remove((Component)this.progressPanel);
            }
            String errMsg = "Unknown error!";
            if (status != null) {
                errMsg = status.getMessage().localize();
            }
            this.setMessage(errMsg);
            JOptionPane.showMessageDialog(this, errMsg, "Audio applet loading error", 0);
        } else if (status != null) {
            if (status.isDone()) {
                if (this.progressPanel != null) {
                    this.remove((Component)this.progressPanel);
                }
                VectorBuffer vb = this.vbOut.getVectorBuffer();
                VectorBufferAudioSource vbAudioSource = new VectorBufferAudioSource(vb);
                this.audioSource = vbAudioSource;
                try {
                    this.process();
                }
                catch (AudioSourceException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Could not process audio file: " + e.getMessage(), "Audio processing error", 0);
                    return;
                }
                this.enableAudio();
                this.makeReady();
                if (this.autoPlayOnLoad) {
                    this.playSelection();
                }
            } else {
                this.setMessage("Download audio source " + status.getPercentProgress() + "%");
            }
        }
    }

    public boolean isStartPlayOnSelect() {
        return this.startPlayOnSelect;
    }

    public void setStartPlayOnSelect(boolean startPlayOnSelect) {
        this.startPlayOnSelect = startPlayOnSelect;
    }

    public boolean isVisualizing() {
        return this.visualizing;
    }

    public void setVisualizing(boolean visualizing) {
        this.visualizing = visualizing;
        if (visualizing) {
            this.signalUI = new AudioSignalUI();
            this.uiContainer = new AudioClipUIContainer();
            this.uiContainer.add(this.signalUI);
            if (this.showSonagram) {
                this.sonagram = new FourierUI();
                this.sonagram.setUseThread(true);
                this.uiContainer.add(this.sonagram);
            }
            for (AudioClipUI audioClipUI : this.additionalAudioClipUIPluginList) {
                this.uiContainer.add((Component)((Object)audioClipUI));
            }
            if (this.showFragmentActionBar) {
                this.fragmentActionBar = new FragmentActionBarUI();
                this.fragmentActionBar.setStartPlaybackAction(this.startAction);
                this.uiContainer.add(this.fragmentActionBar);
            }
            if (this.showTimeScale) {
                this.timeScale = new AudioTimeScaleUI();
                this.uiContainer.add((Component)((Object)this.timeScale));
            }
            this.scrollPane = new AudioClipScrollPane(this.uiContainer);
            this.scrollPane.setVerticalScrollBarPolicy(21);
            this.uiContainer.setAudioClip(this.audioClip);
            this.createPopupMenu();
        } else {
            if (this.uiContainer != null) {
                this.uiContainer.close();
            }
            this.clearScreen();
            if (this.audioClip != null) {
                this.audioClip.removeAudioSampleListener(this);
                this.audioClip = null;
            }
        }
    }

    public boolean isShowSonagram() {
        return this.showSonagram;
    }

    public void setShowSonagram(boolean showSonagram) {
        this.showSonagram = showSonagram;
        if (!showSonagram && this.sonagram != null && this.visualizing) {
            this.uiContainer.remove(this.sonagram);
        }
    }

    public boolean isShowFragmentActionBar() {
        return this.showFragmentActionBar;
    }

    public void setShowFragmentActionBar(boolean showFragmentActionBar) {
        this.showFragmentActionBar = showFragmentActionBar;
        if (!showFragmentActionBar && this.visualizing) {
            this.uiContainer.remove(this.fragmentActionBar);
        }
    }

    public boolean isShowTimeScale() {
        return this.showTimeScale;
    }

    public void setShowTimeScale(boolean showTimeScale) {
        this.showTimeScale = showTimeScale;
        if (!showTimeScale && this.visualizing) {
            this.uiContainer.remove((Component)((Object)this.timeScale));
        }
    }

    public void reactivate() {
        if (Status.DEACTIVATED.equals((Object)this.status)) {
            this.audioClip.setAudioSource(this.audioSource);
            this.enableAudio();
            this.makeReady();
        } else if (Status.INITIALIZED.equals((Object)this.status)) {
            this.load();
        }
    }

    protected void closeContentLoaders() {
    }

    public void deactivate() {
        if (Status.LOADING.equals((Object)this.status)) {
            this.closeDownload();
            this.closeContentLoaders();
            this.changeStatus(Status.INITIALIZED);
        } else {
            if (this.audioClip != null) {
                this.updateTimer.stop();
                this.startAction.setEnabled(false);
                this.audioClip.setAudioSource(null);
            }
            if (this.player != null) {
                try {
                    this.player.close();
                    this.setMessage("Audio player closed.");
                }
                catch (PlayerException e) {
                    e.printStackTrace();
                    this.setMessage("Could not close audio player !");
                }
            }
            this.changeStatus(Status.DEACTIVATED);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        String oldMessage = this.message;
        this.message = message;
        this.pChTa.fireEvent((EventObject)new PropertyChangeEvent(this, "message", oldMessage, this.message));
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pChTa.addListener((EventListener)listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pChTa.removeListener((EventListener)listener);
    }

    public StartPlaybackAction getStartAction() {
        return this.startAction;
    }

    public void setStartAction(StartPlaybackAction startAction) {
        if (this.startAction != startAction) {
            this.startAction.removeActionListener(this);
            this.startAction = startAction;
            startAction.addActionListener(this);
        }
    }

    public StopAction getStopAction() {
        return this.stopAction;
    }

    public void setStopAction(StopAction stopAction) {
        if (this.stopAction != stopAction) {
            this.stopAction.removeActionListener(this);
            this.stopAction = stopAction;
            this.stopAction.addActionListener(this);
        }
    }

    public boolean isAutoPlayOnLoad() {
        return this.autoPlayOnLoad;
    }

    public void setAutoPlayOnLoad(boolean autoPlayOnLoad) {
        this.autoPlayOnLoad = autoPlayOnLoad;
    }

    public boolean isShowDSPInfo() {
        return this.showDSPInfo;
    }

    public void setShowDSPInfo(boolean showDSPInfo) {
        this.showDSPInfo = showDSPInfo;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: AudioPlayerBean audioURL");
            System.exit(-1);
        }
        try {
            final URL audioUrl = new URL(args[0]);
            Runnable show = new Runnable(){

                @Override
                public void run() {
                    JFrame f = new JFrame("Test audio player bean");
                    final AudioPlayerBean aBean = new AudioPlayerBean();
                    aBean.setShowSonagram(false);
                    aBean.setShowFragmentActionBar(true);
                    aBean.setShowTimeScale(true);
                    aBean.setShowDSPInfo(true);
                    aBean.setVisualizing(true);
                    aBean.setStartPlayOnSelect(true);
                    aBean.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            System.out.println("Property changed: " + evt);
                        }
                    });
                    f.getContentPane().add(aBean);
                    f.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            aBean.close();
                        }

                        @Override
                        public void windowClosed(WindowEvent e) {
                            System.exit(0);
                        }
                    });
                    f.pack();
                    f.setVisible(true);
                    f.setDefaultCloseOperation(2);
                    aBean.setURL(audioUrl);
                    f.pack();
                }
            };
            SwingUtilities.invokeAndWait(show);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            System.exit(-2);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            System.exit(-3);
        }
    }

    public static enum Status {
        INITIALIZED,
        LOADING,
        PROCESS,
        READY,
        DEACTIVATED,
        CLOSING,
        CLOSED;

    }
}

