/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio;

import ipsk.audio.AudioControllerException;
import ipsk.audio.AudioControllerListener;
import ipsk.audio.AudioSource;
import ipsk.audio.impl.j2audio.SynchronizedStatus;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Mixer;

public interface AudioController {
    public static final long AUDIO_END = -1L;
    public static final long POS_UNKNOWN = -1L;
    public static final long FULLDUPLEX = 1L;
    public static final long OPEN_ON_DEMAND = 2L;
    public static final long DISABLE_CAPTURE = 4L;
    public static final long HOLD_OPEN = 5L;

    public void setSourceMixerName(String var1);

    public void setSourceMixer(Mixer.Info var1);

    public Mixer.Info getSourceMixerInfo();

    public void setTargetMixerName(String var1);

    public void setTargetMixer(Mixer.Info var1);

    public Mixer.Info getTargetMixerInfo();

    public void setMode(long var1);

    public long getMode();

    public void setNumLines(int var1);

    public int getNumLines();

    public void setAudioFormat(AudioFormat var1);

    public AudioFormat getAudioFormat();

    public AudioFormat getPlaybackAudioFormat();

    public void configure() throws AudioControllerException;

    public void open() throws AudioControllerException;

    public void close() throws AudioControllerException;

    public void setPlaybackFiles(File[] var1);

    public File[] getPlaybackFiles();

    public void setPlaybackURLs(URL[] var1);

    public void setPlaybackInputStreams(InputStream[] var1);

    public void setPlaybackAudioSources(AudioSource[] var1);

    public void setOverwrite(boolean var1);

    public boolean isOverwrite();

    public void setRecordingFiles(File[] var1);

    public File[] getRecordingFiles();

    public void setRecordingOutputStreams(OutputStream[] var1);

    public void preparePlayback() throws AudioControllerException;

    public void prepareRecording() throws AudioControllerException;

    public void startPlayback() throws AudioControllerException;

    public void startCapture() throws AudioControllerException;

    public void startRecording() throws AudioControllerException;

    public void pausePlayback() throws AudioControllerException;

    public void stopPlayback() throws AudioControllerException;

    public void stopCapture() throws AudioControllerException;

    public void stopRecording() throws AudioControllerException;

    public float[] getLevels();

    public boolean isPlaybackRandomPositioningSupported();

    public long getPlaybackFrameLength();

    public long setPlaybackFramePosition(long var1);

    public long getPlaybackFramePosition();

    public long setPlaybackStartFramePosition(long var1);

    public long getPlaybackStartFramePosition();

    public long setPlaybackStopFramePosition(long var1);

    public long getPlaybackStopFramePosition();

    public long getRecordingFramePosition();

    public String[] getPropertyNames();

    public String getPropertyDescription(String var1);

    public void setProperty(String var1, String var2);

    public String getProperty(String var1);

    public void setSettings();

    public CaptureStatus getCaptureStatus();

    public PlaybackStatus getPlaybackStatus();

    public void addAudioControllerListener(AudioControllerListener var1);

    public void removeAudioControllerListener(AudioControllerListener var1);

    public static class PlaybackStatus
    extends SynchronizedStatus {
        public static final String CLOSED = "Closed";
        public static final String CONFIGURED = "Configured";
        public static final String OPEN = "Open";
        public static final String PREPARED = "Prepared";
        public static final String PAUSE = "Pause";
        public static final String PLAYING = "Playing";
        public static final String PLAYED = "Played";
        public static final String FILES_SET = "Files set";

        public PlaybackStatus(String status) {
            super(status);
        }
    }

    public static class CaptureStatus
    extends SynchronizedStatus {
        public static final String CLOSED = "Closed";
        public static final String CONFIGURED = "Configured";
        public static final String OPEN = "Opened";
        public static final String PREPARED = "Prepared";
        public static final String PAUSED = "Paused";
        public static final String CAPTURING = "Capturing";
        public static final String RECORDING = "Recording";
        public static final String BUSY = "Busy";
        public static final String RECORDED = "Recorded";
        public static final String SAVED = "Saved";
        public static final String FILES_SET = "Files set";
        public static final String ERROR = "Error";
        public static final String IDLE = "Idle";
        private Exception exception = null;

        public CaptureStatus(String status) {
            super(status);
        }

        public Exception getException() {
            return this.exception;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }
    }
}

