/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio;

import ipsk.audio.AudioSourceException;
import ipsk.audio.BasicAudioSource;
import ipsk.audio.ThreadSafeAudioSystem;
import java.io.File;
import javax.sound.sampled.AudioInputStream;

public class FileAudioSource
extends BasicAudioSource {
    protected File file;

    public FileAudioSource(File file) {
        this.file = file;
    }

    @Override
    public AudioInputStream getAudioInputStream() throws AudioSourceException {
        AudioInputStream ais = null;
        try {
            ais = ThreadSafeAudioSystem.getAudioInputStream(this.file);
        }
        catch (Exception e) {
            throw new AudioSourceException(e);
        }
        this.setAudioFormat(ais.getFormat());
        this.setFrameLength(ais.getFrameLength());
        return ais;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }
}

