/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.capture;

import ipsk.audio.capture.BufferOverrunException;
import ipsk.audio.capture.TargetDataLineActiveEvent;
import ipsk.audio.capture.TargetDataLineListener;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.TargetDataLine;

public class TargetDataLineInputStream2
extends InputStream {
    private static final boolean DEBUG = false;
    private static final boolean TEST_TRIGGER_RANDOM_FAKE_BUFFER_OVERRUN = false;
    public static final boolean ERROR_ON_BUFFER_OVER_UNDERRUN = true;
    public static double DEFAULT_MAX_BUFFER_FILL = 0.9;
    private TargetDataLine line;
    private boolean markBufferOverrun;
    private float byteRate;
    private long framePosition;
    private volatile boolean flushAndCloseRequest = false;
    private Integer toFlush = null;
    private volatile boolean active = false;
    private boolean closed = false;
    private long lastValidReadOccurence = Long.MAX_VALUE;
    private long leastSaveReadSyncTime = Long.MAX_VALUE;
    private boolean stopped = false;
    private int bufSize;
    private double maxBufferFill = DEFAULT_MAX_BUFFER_FILL;
    private volatile TargetDataLineListener listener = null;

    public boolean isActive() {
        return this.active;
    }

    public TargetDataLineListener getListener() {
        return this.listener;
    }

    public void setListener(TargetDataLineListener listener) {
        this.listener = listener;
    }

    public TargetDataLineInputStream2(TargetDataLine line) {
        this.line = line;
        this.resetStream();
        this.bufSize = line.getBufferSize();
    }

    public void resetStream() {
        this.lastValidReadOccurence = Long.MAX_VALUE;
        this.leastSaveReadSyncTime = Long.MAX_VALUE;
        this.markBufferOverrun = false;
        this.framePosition = 0L;
        this.closed = false;
        this.stopped = false;
        this.active = false;
    }

    public void stop() {
        this.stopped = true;
    }

    @Override
    public int available() throws IOException {
        return this.line.available();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.toFlush = 0;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.line.available() >= this.line.getBufferSize()) {
            throw new IOException("Buffer overrun detected !");
        }
        byte[] b = new byte[1];
        int value = this.read(b, 0, 1);
        if (value == -1) {
            return -1;
        }
        value = b[0];
        if (this.line.getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            value += 128;
        }
        return value;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int avail = this.line.available();
        if (this.stopped) {
            return -1;
        }
        if (this.flushAndCloseRequest) {
            this.flushAndCloseRequest = false;
            return -1;
        }
        if (!this.markBufferOverrun && (double)avail >= (double)this.bufSize * this.maxBufferFill) {
            this.markBufferOverrun = true;
            System.err.println("Buffer overrun (buffer filled up to limit: filled/buffersize: " + avail + "/" + this.bufSize + " " + this.maxBufferFill + " frame position: " + this.framePosition + ")!");
            throw new BufferOverrunException("Buffer overrun detected (buffer filled up to limit)!");
        }
        this.markBufferOverrun = false;
        int read = 0;
        try {
            read = this.line.read(b, off, len);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e.getMessage());
        }
        if (this.stopped && read == 0) {
            return -1;
        }
        long readOccurence = System.currentTimeMillis();
        long saveReadAsyncTime = this.lastValidReadOccurence - readOccurence;
        if (saveReadAsyncTime < this.leastSaveReadSyncTime) {
            this.leastSaveReadSyncTime = saveReadAsyncTime;
        }
        if (saveReadAsyncTime <= 0L) {
            this.markBufferOverrun = true;
            System.err.println("Buffer overrun (buffer read too late)!");
            throw new BufferOverrunException("Buffer overrun detected (buffer read too late (" + -saveReadAsyncTime + "ms))!");
        }
        if (read != -1) {
            if (this.toFlush != null) {
                this.toFlush = this.toFlush - read;
            }
            this.framePosition += (long)(read / this.line.getFormat().getFrameSize());
            int availAfterRead = avail - read;
            int bufFree = (int)((double)this.bufSize * this.maxBufferFill - (double)availAfterRead);
            AudioFormat af = this.line.getFormat();
            this.byteRate = af.getFrameRate() * (float)af.getFrameSize();
            long bufFreeMs = (long)((float)bufFree * 1000.0f / this.byteRate);
            this.lastValidReadOccurence = readOccurence + bufFreeMs;
            if (!this.active && read > 0) {
                this.active = true;
                if (this.listener != null) {
                    this.listener.update(new TargetDataLineActiveEvent(this, this.framePosition));
                }
            }
        }
        return read;
    }

    public long getFramePosition() {
        return this.framePosition;
    }

    public double getMaxBufferFill() {
        return this.maxBufferFill;
    }

    public void setMaxBufferFill(double maxBufferFill) {
        this.maxBufferFill = maxBufferFill;
    }

    public void flushAndCloseStream() {
        this.flushAndCloseRequest = true;
    }
}

