/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.dsp;

public class DSPUtils {
    private static double OCTAVE_FACTOR = 1.0 / Math.log10(2.0);

    public static double toLevelInDB(double linearLevel) {
        if (linearLevel < 0.0) {
            throw new IllegalArgumentException("Linear level argument must be positive.");
        }
        return 10.0 * Math.log10(linearLevel);
    }

    public static double getLevelInDB(double linearLevel) {
        return DSPUtils.toLevelInDB(linearLevel);
    }

    public static double toLinearLevel(double dbLevel) {
        return Math.pow(10.0, dbLevel / 10.0);
    }

    public static double toPowerLevelInDB(double linearLevel) {
        if (linearLevel < 0.0) {
            throw new IllegalArgumentException("Linear level argument must be positive.");
        }
        return 20.0 * Math.log10(linearLevel);
    }

    public static double toPowerLinearLevel(double dbLevel) {
        return Math.pow(10.0, dbLevel / 20.0);
    }

    public static double toOctaves(double f1, double f2) {
        return DSPUtils.toOctaves(f1 / f2);
    }

    public static double toOctaves(double fq) {
        return OCTAVE_FACTOR * Math.log10(fq);
    }

    public static void main(String[] args) {
        System.out.println(DSPUtils.toPowerLevelInDB(0.5));
        System.out.println(DSPUtils.toPowerLevelInDB(1.0));
        System.out.println(DSPUtils.toPowerLinearLevel(50.0));
        System.out.println(DSPUtils.toPowerLinearLevel(6.0));
    }
}

