/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.ui;

import ipsk.audio.ThreadSafeAudioSystem;
import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import javax.swing.filechooser.FileFilter;

public class AudioFileFilter
extends FileFilter {
    AudioFileFormat.Type[] audioFileTypes;

    public AudioFileFilter() {
        this.audioFileTypes = ThreadSafeAudioSystem.getAudioFileReaderTypes();
    }

    public AudioFileFilter(AudioFileFormat.Type[] audioFileTypes) {
        this.audioFileTypes = audioFileTypes;
    }

    public AudioFileFilter(AudioFileFormat.Type audioFileType) {
        this.audioFileTypes = new AudioFileFormat.Type[]{audioFileType};
    }

    @Override
    public boolean accept(File arg0) {
        if (arg0.isDirectory()) {
            return true;
        }
        String name = arg0.getName();
        int extIndex = name.lastIndexOf(46);
        if (extIndex == -1) {
            return false;
        }
        String ext = name.substring(extIndex + 1);
        for (int i = 0; i < this.audioFileTypes.length; ++i) {
            if (!ext.equalsIgnoreCase(this.audioFileTypes[i].getExtension())) continue;
            return true;
        }
        return false;
    }

    public void setAudioFileTypes(AudioFileFormat.Type[] audioFileTypes) {
        this.audioFileTypes = audioFileTypes;
    }

    public AudioFileFormat.Type[] getAudioFileTypes() {
        return this.audioFileTypes;
    }

    @Override
    public String getDescription() {
        if (this.audioFileTypes.length == 1) {
            return new String("Audio filetype " + this.audioFileTypes[0].toString());
        }
        return new String("Audio files");
    }
}

