/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.utils;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.Profile;
import ipsk.util.LocalizableMessage;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;

public class AudioFormatUtils {
    public static AudioFormat.Encoding getEncodingByName(String name) {
        if (AudioFormat.Encoding.ALAW.toString().equalsIgnoreCase(name)) {
            return AudioFormat.Encoding.ALAW;
        }
        if (AudioFormat.Encoding.PCM_SIGNED.toString().equalsIgnoreCase(name)) {
            return AudioFormat.Encoding.PCM_SIGNED;
        }
        if (AudioFormat.Encoding.PCM_UNSIGNED.toString().equalsIgnoreCase(name)) {
            return AudioFormat.Encoding.PCM_UNSIGNED;
        }
        if (AudioFormat.Encoding.ULAW.toString().equalsIgnoreCase(name)) {
            return AudioFormat.Encoding.ULAW;
        }
        return null;
    }

    public static String getMimetype(AudioFileFormat.Type type) {
        if (type.equals(AudioFileFormat.Type.WAVE)) {
            return "audio/wav";
        }
        if (type.equals(AudioFileFormat.Type.AIFC)) {
            return "audio/aiff";
        }
        if (type.equals(AudioFileFormat.Type.AIFF)) {
            return "audio/aiff";
        }
        if (type.equals(AudioFileFormat.Type.AU)) {
            return "audio/basic";
        }
        if (type.equals(AudioFileFormat.Type.SND)) {
            return "audio/basic";
        }
        if (type.equals(new AudioFileFormat.Type("FLAC", "flac"))) {
            return "audio/x-flac";
        }
        return "application/octet-stream";
    }

    public static int pcmSizeInBytesFromLength(AudioFormat audioFormat, float seconds) throws AudioFormatNotSupportedException {
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        if (AudioFormat.Encoding.PCM_SIGNED.equals(encoding) || AudioFormat.Encoding.PCM_UNSIGNED.equals(encoding)) {
            int frameSize = audioFormat.getFrameSize();
            float frameRate = audioFormat.getFrameRate();
            int frames = (int)(frameRate * seconds);
            int size = frames * frameSize;
            return size;
        }
        throw new AudioFormatNotSupportedException(audioFormat);
    }

    public static float pcmLengthFromByteLength(AudioFormat audioFormat, int sizeInBytes) throws AudioFormatNotSupportedException {
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        if (AudioFormat.Encoding.PCM_SIGNED.equals(encoding) || AudioFormat.Encoding.PCM_UNSIGNED.equals(encoding)) {
            int frameSize = audioFormat.getFrameSize();
            float frameRate = audioFormat.getFrameRate();
            int frames = sizeInBytes / frameSize;
            float length = (float)frames / frameRate;
            return length;
        }
        throw new AudioFormatNotSupportedException(audioFormat);
    }

    public static List<LocalizableMessage> getFormatQualityWarningsForProfile(AudioFormat format, Profile profile) {
        ArrayList<LocalizableMessage> msgs = new ArrayList<LocalizableMessage>();
        if (format.getSampleRate() < profile.getMinSampleRate()) {
            msgs.add(new LocalizableMessage("Minimum sample rate of " + profile.getMinSampleRate()));
        }
        if (format.getSampleSizeInBits() < profile.getMinSampleSizeInBits()) {
            msgs.add(new LocalizableMessage("Minimum sample size of " + profile.getMinSampleSizeInBits()));
        }
        if (profile.isPcmSignedRecommended() && !AudioFormat.Encoding.PCM_SIGNED.equals(format.getEncoding())) {
            msgs.add(new LocalizableMessage("Encoding " + AudioFormat.Encoding.PCM_SIGNED));
        }
        return msgs;
    }

    public static Double lengthInSeconds(AudioSource audioSource) throws AudioSourceException {
        AudioFormat af;
        float sr;
        long frameLength = audioSource.getFrameLength();
        if (frameLength != -1L && frameLength >= 0L && (sr = (af = audioSource.getFormat()).getSampleRate()) != -1.0f) {
            return (double)frameLength / (double)af.getSampleRate();
        }
        return null;
    }
}

