/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.audioeditor.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InfoViewer
extends JPanel {
    private static final int LEFT = 5;
    private static final int RIGHT = 5;
    private static final int TOP = 5;
    private static final int BOTTOM = 5;
    private JLabel recFileLabel;
    private JLabel recFileValue;

    public InfoViewer() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.fill = 2;
        c.insets = new Insets(2, 5, 2, 5);
        c.anchor = 19;
        this.recFileLabel = new JLabel("Recording File: ");
        this.recFileValue = new JLabel("");
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)new JLabel("Operating system: "), c);
        ++c.gridx;
        this.add((Component)new JLabel(System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch")), c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Java Runtime Environment: "), c);
        ++c.gridx;
        this.add((Component)new JLabel(System.getProperty("java.vendor") + " " + System.getProperty("java.version")), c);
        c.gridx = 0;
        ++c.gridy;
        try {
            Class.forName("ipsk.util.LocalizableMessage");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        Package javaUtilsPkg = Package.getPackage("ipsk.util");
        String utilLibVers = "n/a";
        if (javaUtilsPkg != null) {
            utilLibVers = javaUtilsPkg.getImplementationVersion();
        }
        this.add((Component)new JLabel(javaUtilsPkg.getImplementationTitle() + ":"), c);
        ++c.gridx;
        this.add((Component)new JLabel(utilLibVers), c);
        c.gridx = 0;
        ++c.gridy;
        Package javaAudioToolsPkg = Package.getPackage("ipsk.audio");
        String audioLibVers = "n/a";
        if (javaAudioToolsPkg != null) {
            audioLibVers = javaAudioToolsPkg.getImplementationVersion();
        }
        this.add((Component)new JLabel(javaAudioToolsPkg.getImplementationTitle() + ":"), c);
        ++c.gridx;
        this.add((Component)new JLabel(audioLibVers), c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)this.recFileLabel, c);
        ++c.gridx;
        this.add((Component)this.recFileValue, c);
        this.setRecordingFile(null);
    }

    public void setRecordingFile(File recFile) {
        String recFileName = "";
        if (recFile != null) {
            recFileName = recFile.getAbsolutePath();
        }
        this.recFileValue.setText(recFileName);
        this.revalidate();
        this.repaint();
    }
}

