/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.applet;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.PluginChain;
import ipsk.audio.ThreadSafeAudioSystem;
import ipsk.audio.URLAudioSource;
import ipsk.audio.VectorBufferAudioSource;
import ipsk.audio.actions.StartPlayAudioSourceAction;
import ipsk.audio.actions.StopAction;
import ipsk.audio.applet.PlayerTransportUIApplet;
import ipsk.audio.arr.Selection;
import ipsk.audio.arr.clip.AudioClip;
import ipsk.audio.arr.clip.AudioClipListener;
import ipsk.audio.arr.clip.events.AudioClipChangedEvent;
import ipsk.audio.arr.clip.events.SelectionChangedEvent;
import ipsk.audio.arr.clip.ui.AudioClipUIContainer;
import ipsk.audio.arr.clip.ui.AudioSignalUI;
import ipsk.audio.arr.clip.ui.AudioTimeScaleUI;
import ipsk.audio.dsp.AudioClipDSPInfo;
import ipsk.audio.dsp.AudioClipProcessor;
import ipsk.audio.events.StartPlaybackActionEvent;
import ipsk.audio.mixer.MixerManager;
import ipsk.audio.player.Player;
import ipsk.audio.player.PlayerException;
import ipsk.audio.player.PlayerListener;
import ipsk.audio.player.event.PlayerCloseEvent;
import ipsk.audio.player.event.PlayerEvent;
import ipsk.audio.player.event.PlayerStartEvent;
import ipsk.audio.player.event.PlayerStopEvent;
import ipsk.audio.plugins.ChannelSelectorPlugin;
import ipsk.audio.ui.TransportUI;
import ipsk.awt.ProgressListener;
import ipsk.awt.Worker;
import ipsk.awt.WorkerException;
import ipsk.awt.event.ProgressErrorEvent;
import ipsk.awt.event.ProgressEvent;
import ipsk.io.VectorBuffer;
import ipsk.io.VectorBufferedOutputStream;
import ipsk.net.URLContentLoader;
import ipsk.swing.JProgressDialogPanel;
import ipsk.util.ProgressStatus;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class MultiSourcePlayerApplet
extends JApplet
implements ActionListener,
PlayerListener,
AudioClipListener,
ProgressListener {
    public static final boolean DEBUG = true;
    public static final String VERSION = MultiSourcePlayerApplet.class.getPackage().getImplementationVersion();
    public static final int DEFAULT_APPLET_SEARCH_INTERVALL_MS = 2000;
    private static final Float PREFERRED_LINE_BUFFER_SIZE_MILLIS = Float.valueOf(5000.0f);
    protected URL audioURL;
    private VectorBufferedOutputStream vbOut;
    protected AudioSource audioSource;
    protected AudioSource playbackSource;
    protected AudioClipUIContainer uiContainer;
    protected AudioClip audioSample;
    private JPanel playerPanel;
    private TransportUI transportUI;
    private JRadioButton[] channelSelectButtons = null;
    private JRadioButton channelSelectAllButton;
    private ButtonGroup channelSelectButtonGroup;
    private Player player;
    private Timer updateTimer;
    private Mixer device;
    private Container contentPane;
    private AudioSignalUI signalUI = null;
    private boolean open = false;
    private URLContentLoader urlContentLoader;
    private JProgressDialogPanel progressPanel;
    private JScrollPane scrollPane;
    private Status status = Status.EXISTING;
    private int channels;
    private Hashtable<URL, PlayerTransportUIApplet> controllerTable = null;
    private PlayerTransportUIApplet currentControl;
    private boolean startWhenLoaded = false;
    private Timer appletsSearchTimer;
    private static final String[][] pInfo = new String[0][];

    public MultiSourcePlayerApplet() throws HeadlessException {
        System.out.println("Constructor: thread: " + Thread.currentThread().getName());
        this.controllerTable = new Hashtable();
    }

    @Override
    public String[][] getParameterInfo() {
        return pInfo;
    }

    @Override
    public String getAppletInfo() {
        return "Multiple source audio player applet, Klaus Jaensch, Copyright 2010";
    }

    @Override
    public void init() {
        System.out.println("init() " + System.currentTimeMillis());
        if (EventQueue.isDispatchThread()) {
            this._init();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        MultiSourcePlayerApplet.this._init();
                    }
                });
            }
            catch (InterruptedException e) {
                this.showStatus(e.getMessage());
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                this.showStatus(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void start() {
        System.out.println("start() " + System.currentTimeMillis());
        if (EventQueue.isDispatchThread()) {
            this._start();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        MultiSourcePlayerApplet.this._start();
                    }
                });
            }
            catch (InterruptedException e) {
                this.showStatus(e.getMessage());
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                this.showStatus(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void stop() {
        System.out.println("stop() " + System.currentTimeMillis());
        if (EventQueue.isDispatchThread()) {
            this._stop();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        MultiSourcePlayerApplet.this._stop();
                    }
                });
            }
            catch (InterruptedException e) {
                this.showStatus(e.getMessage());
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                this.showStatus(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void destroy() {
        System.out.println("destroy() " + System.currentTimeMillis());
        if (EventQueue.isDispatchThread()) {
            this._destroy();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        MultiSourcePlayerApplet.this._destroy();
                    }
                });
            }
            catch (InterruptedException e) {
                this.showStatus(e.getMessage());
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                this.showStatus(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void _init() {
        System.out.println("_init() " + System.currentTimeMillis());
        if (Status.EXISTING.equals((Object)this.status)) {
            this.vbOut = new VectorBufferedOutputStream();
            this.urlContentLoader = new URLContentLoader("URL content loader");
            this.contentPane = this.getContentPane();
            this.contentPane.setLayout(new BorderLayout());
            this.signalUI = new AudioSignalUI();
            AudioTimeScaleUI timeScale = new AudioTimeScaleUI();
            this.uiContainer = new AudioClipUIContainer();
            this.uiContainer.add(this.signalUI);
            this.uiContainer.add((Component)((Object)timeScale));
            this.scrollPane = new JScrollPane(this.uiContainer);
            this.audioSample = new AudioClip();
            this.audioSample.addAudioSampleListener(this);
            this.uiContainer.setAudioClip(this.audioSample);
            this.progressPanel = new JProgressDialogPanel((Worker)this.urlContentLoader, "title", "Loading audio ...");
            this.add((Component)this.progressPanel, "Center");
            this.playerPanel = new JPanel();
            this.contentPane.add((Component)this.playerPanel, "South");
            this.channelSelectAllButton = new JRadioButton("All");
            try {
                MixerManager mm = new MixerManager();
                Mixer[] devices = mm.getDirectPlaybackMixers();
                if (devices != null && devices.length > 0) {
                    this.device = devices[0];
                    this.player = new Player(this.device);
                } else {
                    this.player = new Player();
                }
            }
            catch (LineUnavailableException e) {
                e.printStackTrace();
                this.showStatus("Could not get a direct audio device !");
            }
            if (this.player == null) {
                this.player = new Player();
            }
            if (this.player != null) {
                this.player.setPreferredLineBufferSizeMillis(PREFERRED_LINE_BUFFER_SIZE_MILLIS);
                this.player.setMeasureLevel(false);
                this.player.addPlayerListener(this);
            }
            this.updateTimer = new Timer(200, this);
            this.open = true;
            this.showStatus("Audio player initialized.");
            this.status = Status.INITIALIZED;
            System.out.println(this.getClass().getName() + " version " + VERSION + " initialized.");
        }
    }

    private void loadURL(URL url) {
        if (Status.LOADING.equals((Object)this.status)) {
            this.urlContentLoader.cancel();
        }
        try {
            this.urlContentLoader.close();
            this.urlContentLoader.reset();
        }
        catch (WorkerException e) {
            e.printStackTrace();
        }
        if (this.audioSample != null) {
            this.updateTimer.stop();
            this.currentControl.getStartAction().setEnabled(false);
            this.audioSample.setAudioSource(null);
        }
        if (this.player != null) {
            try {
                this.player.close();
                this.player.setAudioSource(null);
                this.showStatus("Audio player closed.");
            }
            catch (PlayerException e) {
                e.printStackTrace();
                this.showStatus("Could not close audio player !");
            }
        }
        StartPlayAudioSourceAction startAction = this.currentControl.getStartAction();
        startAction.setHighlighted(false);
        StopAction stopAction = this.currentControl.getStopAction();
        stopAction.setEnabled(false);
        stopAction.setHighlighted(false);
        this.audioSource = null;
        this.playbackSource = null;
        if (this.scrollPane != null) {
            this.contentPane.remove(this.scrollPane);
        }
        if (this.progressPanel != null) {
            this.contentPane.remove((Component)this.progressPanel);
        }
        this.status = Status.INITIALIZED;
        PlayerTransportUIApplet newControl = this.controllerTable.get(url);
        startAction = newControl.getStartAction();
        stopAction = newControl.getStopAction();
        startAction.setHighlighted(false);
        startAction.setEnabled(false);
        this.contentPane.add((Component)this.progressPanel, "Center");
        VectorBufferedOutputStream vbOut = new VectorBufferedOutputStream();
        this.urlContentLoader.setUrl(url);
        this.urlContentLoader.setOutputStream((OutputStream)vbOut);
        this.urlContentLoader.addProgressListener((ProgressListener)this);
        try {
            this.urlContentLoader.open();
        }
        catch (WorkerException e) {
            String errMsg = "Error loading audio from '" + this.audioURL + "' : " + e.getLocalizedMessage();
            this.showStatus(errMsg);
            JOptionPane.showMessageDialog(this, errMsg, "Audio applet loading error", 0);
            return;
        }
        this.status = Status.LOADING;
        this.showStatus("Downloading audio data from '" + this.audioURL + "' ...");
        this.urlContentLoader.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadControllers() {
        Hashtable<URL, PlayerTransportUIApplet> applet;
        ArrayList<PlayerTransportUIApplet> controllerList = new ArrayList<PlayerTransportUIApplet>();
        System.out.println("Query applets:");
        Enumeration<Applet> applets = this.getAppletContext().getApplets();
        int count = 0;
        while (applets.hasMoreElements()) {
            applet = applets.nextElement();
            ++count;
            if (applet instanceof PlayerTransportUIApplet) {
                PlayerTransportUIApplet ptApplet = (PlayerTransportUIApplet)((Object)applet);
                System.out.println(this.hashCode() + " found transportUI applet " + ((Object)applet).hashCode());
                if (ptApplet.isReady()) {
                    controllerList.add(ptApplet);
                    continue;
                }
                System.out.println(this.hashCode() + " applet " + ((Object)applet).hashCode() + " not initialized yet");
                continue;
            }
            System.out.println(this.hashCode() + " found applet " + ((Object)applet).hashCode());
        }
        System.out.println(this.hashCode() + " found " + count + " applets");
        System.out.println(this.hashCode() + " " + controllerList.size() + " > " + this.controllerTable.size());
        if (controllerList.size() > this.controllerTable.size()) {
            for (PlayerTransportUIApplet pt : controllerList) {
                URL ctrlAudioURL = pt.getAudioURL();
                if (ctrlAudioURL == null || pt.isBound()) continue;
                Hashtable<URL, PlayerTransportUIApplet> hashtable = this.controllerTable;
                synchronized (hashtable) {
                    this.controllerTable.put(ctrlAudioURL, pt);
                    StartPlayAudioSourceAction spa = pt.getStartAction();
                    spa.addActionListener(this);
                    spa.setEnabled(true);
                    StopAction sa = pt.getStopAction();
                    sa.setHighlighted(false);
                    sa.addActionListener(this);
                    pt.setBound(true);
                    System.out.println(this.hashCode() + ": player UI applet " + pt.hashCode() + " bound");
                }
            }
            if (this.currentControl == null) {
                applet = this.controllerTable;
                synchronized (applet) {
                    Enumeration<PlayerTransportUIApplet> ctrlEnum = this.controllerTable.elements();
                    if (ctrlEnum.hasMoreElements()) {
                        this.currentControl = ctrlEnum.nextElement();
                    }
                }
                if (this.currentControl != null) {
                    this.transportUI = new TransportUI(this.currentControl.getStartAction(), this.currentControl.getStopAction());
                    this.playerPanel.add(this.transportUI);
                    URL initialURL = this.currentControl.getAudioURL();
                    if (initialURL != null) {
                        this.loadURL(initialURL);
                    }
                }
            }
        }
    }

    public void _start() {
        System.out.println("_start() " + System.currentTimeMillis());
        if (this.status.equals((Object)Status.INITIALIZED)) {
            this.loadControllers();
            if (this.appletsSearchTimer == null) {
                this.appletsSearchTimer = new Timer(2000, this);
                this.appletsSearchTimer.setRepeats(true);
                this.appletsSearchTimer.start();
            }
        } else if (Status.APPLET_STOPPED.equals((Object)this.status)) {
            this.enableAudio();
            this.makeReady();
        }
    }

    public void makeReady() {
        this.contentPane.invalidate();
        this.contentPane.validate();
        this.repaint();
        this.status = Status.READY;
    }

    private void process() {
        this.status = Status.PROCESS;
        VectorBuffer vb = this.vbOut.getVectorBuffer();
        VectorBufferAudioSource vbAudioSource = new VectorBufferAudioSource(vb);
        this.playbackSource = this.audioSource = vbAudioSource;
        AudioClip audioClip = new AudioClip(this.audioSource);
        AudioClipProcessor processor = new AudioClipProcessor(audioClip);
        processor.setCalculateSBNR(true);
        this.showStatus("Processing audio data ...");
        try {
            processor.process();
        }
        catch (AudioSourceException e) {
            e.printStackTrace();
            this.showStatus("Error processing audio data.");
            return;
        }
        AudioClipDSPInfo dspInfo = audioClip.getClipDSPInfo();
        this.contentPane.add((Component)this.scrollPane, "Center");
        this.channels = dspInfo.getAudioFormat().getChannels();
        if (this.channelSelectButtons != null) {
            for (JRadioButton chSelButt : this.channelSelectButtons) {
                chSelButt.removeActionListener(this);
                this.playerPanel.remove(chSelButt);
            }
            this.channelSelectAllButton.removeActionListener(this);
            this.playerPanel.remove(this.channelSelectAllButton);
        }
        if (this.channels > 1) {
            this.channelSelectButtons = new JRadioButton[this.channels + 1];
            this.channelSelectButtonGroup = new ButtonGroup();
            for (int ch = 0; ch < this.channels; ++ch) {
                JRadioButton chSelButt = new JRadioButton("Ch " + ch);
                this.channelSelectButtonGroup.add(chSelButt);
                this.playerPanel.add(chSelButt);
                chSelButt.addActionListener(this);
                this.channelSelectButtons[ch] = chSelButt;
            }
            this.channelSelectAllButton.setSelected(true);
            this.channelSelectAllButton.addActionListener(this);
            this.channelSelectButtonGroup.add(this.channelSelectAllButton);
            this.channelSelectButtons[this.channels] = this.channelSelectAllButton;
            this.playerPanel.add(this.channelSelectAllButton);
        }
        this.contentPane.validate();
    }

    private void enableAudio() {
        if (this.audioSample != null) {
            this.audioSample.setAudioSource(this.audioSource);
            this.uiContainer.xZoomFitToPanel();
            if (this.player != null) {
                try {
                    this.player.setAudioSource(this.playbackSource);
                    this.currentControl.getStartAction().setEnabled(true);
                    this.currentControl.getStopAction().setHighlighted(true);
                    this.updateTimer.start();
                    this.showStatus("Audio player ready.");
                }
                catch (PlayerException e) {
                    e.printStackTrace();
                    this.showStatus("Could not set playback audio source !");
                }
            } else {
                this.showStatus("No audio player available.");
            }
        } else {
            this.showStatus("No audio clip available.");
        }
    }

    public void _stop() {
        System.out.println("_stop() " + System.currentTimeMillis());
        if (Status.LOADING.equals((Object)this.status)) {
            this.urlContentLoader.cancel();
            try {
                this.urlContentLoader.close();
                this.urlContentLoader.reset();
            }
            catch (WorkerException e) {
                e.printStackTrace();
            }
            this.status = Status.INITIALIZED;
        } else {
            if (this.audioSample != null) {
                this.updateTimer.stop();
                this.currentControl.getStartAction().setEnabled(false);
                this.audioSample.setAudioSource(null);
            }
            if (this.player != null) {
                try {
                    this.player.close();
                    this.showStatus("Audio player closed.");
                }
                catch (PlayerException e) {
                    e.printStackTrace();
                    this.showStatus("Could not close audio player !");
                }
            }
            this.status = Status.APPLET_STOPPED;
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        String ac = ae.getActionCommand();
        if (src == this.updateTimer) {
            this.audioSample.setFramePosition(this.player.getFramePosition());
        } else if (src == this.appletsSearchTimer) {
            this.loadControllers();
        } else if (StopAction.ACTION_COMMAND.equals(ac)) {
            this.player.stop();
        } else if (ae instanceof StartPlaybackActionEvent) {
            StartPlaybackActionEvent spae = (StartPlaybackActionEvent)ae;
            AudioSource as = spae.getPlaybackSource();
            if (as instanceof URLAudioSource) {
                URL newAudioUrl = ((URLAudioSource)as).getUrl();
                if (newAudioUrl.equals(this.audioURL)) {
                    this.playSelection();
                } else {
                    this.startWhenLoaded = true;
                    this.loadURL(newAudioUrl);
                }
            }
        } else if (this.channelSelectButtons != null) {
            AudioSource newPlaybackSource = null;
            if (src == this.channelSelectAllButton) {
                newPlaybackSource = this.audioSource;
            } else {
                for (int c = 0; c < this.channelSelectButtons.length; ++c) {
                    if (src != this.channelSelectButtons[c]) continue;
                    PluginChain pCh = new PluginChain(this.audioSource);
                    try {
                        pCh.add(new ChannelSelectorPlugin(c));
                    }
                    catch (AudioFormatNotSupportedException e) {
                        e.printStackTrace();
                    }
                    newPlaybackSource = pCh;
                }
            }
            if (newPlaybackSource != null) {
                this.playbackSource = newPlaybackSource;
                try {
                    this.player.close();
                    this.player.setAudioSource(this.playbackSource);
                    this.currentControl.getStartAction().setEnabled(true);
                    this.currentControl.getStopAction().setHighlighted(true);
                }
                catch (PlayerException e) {
                    e.printStackTrace();
                    this.showStatus("Could not close audio player !");
                }
            }
        }
    }

    private void playSelection() {
        if (this.player == null || this.player.isOpen()) {
            return;
        }
        Selection s = this.audioSample.getSelection();
        if (s != null) {
            this.player.setStartFramePosition(s.getLeft());
            this.player.setStopFramePosition(s.getRight());
        } else {
            this.player.setStartFramePosition(0L);
            this.player.setStopFramePosition(ThreadSafeAudioSystem.NOT_SPECIFIED);
        }
        try {
            this.player.open();
            this.showStatus("Audio player open.");
            this.player.play();
            this.showStatus("Audio player playing...");
            this.currentControl.getStopAction().setEnabled(true);
        }
        catch (PlayerException e) {
            e.printStackTrace();
            this.showStatus("Cannot play audio !");
        }
    }

    @Override
    public void update(PlayerEvent playerEvent) {
        StartPlayAudioSourceAction startAction = this.currentControl.getStartAction();
        StopAction stopAction = this.currentControl.getStopAction();
        if (playerEvent instanceof PlayerStartEvent) {
            stopAction.setEnabled(true);
            stopAction.setHighlighted(false);
            startAction.setEnabled(false);
            startAction.setHighlighted(true);
        } else if (playerEvent instanceof PlayerStopEvent) {
            if (this.open) {
                startAction.setEnabled(false);
                stopAction.setEnabled(false);
            }
            try {
                this.player.close();
            }
            catch (PlayerException e) {
                e.printStackTrace();
                this.showStatus("Could not close audio player !");
            }
        } else if (playerEvent instanceof PlayerCloseEvent) {
            if (this.open) {
                startAction.setEnabled(true);
                startAction.setHighlighted(false);
                stopAction.setEnabled(false);
                stopAction.setHighlighted(true);
            }
            this.showStatus("Audio player closed.");
        }
    }

    @Override
    public void audioClipChanged(AudioClipChangedEvent event) {
        SelectionChangedEvent selEv;
        if (event instanceof SelectionChangedEvent && (selEv = (SelectionChangedEvent)event).getSelection() != null) {
            this.playSelection();
        }
    }

    public void _destroy() {
        System.out.println("_destroy() " + System.currentTimeMillis());
        this.open = false;
        if (this.appletsSearchTimer != null) {
            this.appletsSearchTimer.stop();
            this.appletsSearchTimer = null;
        }
        if (this.updateTimer != null) {
            this.updateTimer.stop();
        }
        for (PlayerTransportUIApplet pt : this.controllerTable.values()) {
            StopAction sa;
            StartPlayAudioSourceAction spa = pt.getStartAction();
            if (spa != null) {
                spa.removeActionListener(this);
            }
            if ((sa = pt.getStopAction()) == null) continue;
            sa.removeActionListener(this);
        }
        if (this.signalUI != null) {
            this.signalUI.close();
        }
        if (this.audioSample != null) {
            this.audioSample.removeAudioSampleListener(this);
        }
        this.contentPane.removeAll();
        this.controllerTable.clear();
        this.status = Status.APPLET_DESTROYED;
    }

    public void update(ProgressEvent progressEvent) {
        ProgressStatus status = progressEvent.getProgressStatus();
        if (progressEvent instanceof ProgressErrorEvent) {
            this.contentPane.remove((Component)this.progressPanel);
            String errMsg = "Unknown error!";
            if (status != null) {
                errMsg = status.getMessage().localize();
            }
            this.showStatus(errMsg);
            JOptionPane.showMessageDialog(this, errMsg, "Audio applet loading error", 0);
        } else if (status != null && status.isDone()) {
            this.contentPane.remove((Component)this.progressPanel);
            this.vbOut = (VectorBufferedOutputStream)this.urlContentLoader.getOutputStream();
            this.audioURL = this.urlContentLoader.getUrl();
            this.currentControl.getStartAction().setEnabled(true);
            this.currentControl = this.controllerTable.get(this.audioURL);
            StartPlayAudioSourceAction startAction = this.currentControl.getStartAction();
            StopAction stopAction = this.currentControl.getStopAction();
            this.transportUI.setStartPlaybackAction(startAction);
            this.transportUI.setStopAction(stopAction);
            this.process();
            this.enableAudio();
            this.makeReady();
            if (this.startWhenLoaded) {
                this.playSelection();
                this.startWhenLoaded = false;
            }
        }
    }

    public static enum Status {
        EXISTING,
        INITIALIZED,
        LOADING,
        PROCESS,
        READY,
        APPLET_STOPPED,
        APPLET_DESTROYED;

    }
}

