/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.impl.j2audio2;

import ipsk.audio.AudioController2;
import ipsk.audio.AudioController4;
import ipsk.audio.AudioControllerException;
import ipsk.audio.AudioSource;
import ipsk.audio.DeviceInfo;
import ipsk.audio.DeviceProvider;
import ipsk.audio.DeviceProviderInfo;
import ipsk.audio.FileAudioSource;
import ipsk.audio.ajs.AJSAudioSystem;
import ipsk.audio.ajs.AJSDevice;
import ipsk.audio.ajs.AJSDeviceInfo;
import ipsk.audio.ajs.DeviceSelection;
import ipsk.audio.ajs.MixerProviderServiceDescriptor;
import ipsk.audio.capture.Capture3;
import ipsk.audio.capture.CaptureException;
import ipsk.audio.capture.CaptureListener;
import ipsk.audio.capture.PrimaryRecordTarget;
import ipsk.audio.capture.event.CaptureEvent;
import ipsk.audio.dsp.AudioOutputStreamFloatConverter;
import ipsk.audio.dsp.LevelInfo;
import ipsk.audio.dsp.LevelMeasureFloatAudioOutputStream;
import ipsk.audio.impl.j2audio2.DeviceProviderImpl;
import ipsk.audio.io.push.FloatAudioOutputStream;
import ipsk.audio.mixer.MixerManager;
import ipsk.audio.player.Player;
import ipsk.audio.player.PlayerException;
import ipsk.audio.player.PlayerListener;
import ipsk.audio.player.event.PlayerEvent;
import ipsk.io.ChannelRouting;
import java.io.File;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.spi.MixerProvider;

public class J2AudioController4
implements AudioController4,
PlayerListener,
CaptureListener {
    private Vector<AudioController2.AudioController2Listener> listeners;
    private DeviceSelection captureDeviceSelection;
    private Player player;
    private Capture3 capture;
    private MixerManager mm;
    private float preferredCaptureLineBufferSizeMilliSeconds;
    private float preferredPlaybackLineBufferSizeMilliSeconds;
    private AudioOutputStreamFloatConverter captureOutputStream;
    private LevelMeasureFloatAudioOutputStream captureLevelMeasureStream;
    private Logger logger;

    public J2AudioController4() {
        String packageName = this.getClass().getPackage().getName();
        this.logger = Logger.getLogger(packageName);
        this.logger.setLevel(Level.INFO);
        this.listeners = new Vector();
        this.player = new Player();
        this.player.addPlayerListener(this);
        this.capture = new Capture3();
        this.capture.addCaptureListener(this);
        this.captureOutputStream = new AudioOutputStreamFloatConverter();
        this.capture.addAudioOutputStream(this.captureOutputStream);
        this.captureLevelMeasureStream = new LevelMeasureFloatAudioOutputStream();
        this.captureOutputStream.addFloatAudioOutputStream(this.captureLevelMeasureStream);
        this.logger.info("J2AudioController3 created");
    }

    @Override
    public synchronized Mixer.Info[] getPlaybackMixerInfos() throws AudioControllerException {
        if (this.mm == null) {
            this.mm = new MixerManager();
        }
        try {
            return this.mm.getPlaybackMixerInfos();
        }
        catch (LineUnavailableException e1) {
            throw new AudioControllerException("Could not get playback mixer infos.", e1);
        }
    }

    @Override
    public synchronized Mixer.Info[] getCaptureMixerInfos() throws AudioControllerException {
        if (this.mm == null) {
            this.mm = new MixerManager();
        }
        try {
            return this.mm.getCaptureMixerInfos();
        }
        catch (LineUnavailableException e1) {
            throw new AudioControllerException("Could not get capture mixer infos.", e1);
        }
    }

    @Override
    public synchronized void setPlaybackDeviceByName(String deviceName) throws AudioControllerException {
        Mixer playbackMixer;
        if (this.mm == null) {
            this.mm = new MixerManager();
        }
        if ((playbackMixer = this.mm.getPlaybackMixerByName(deviceName)) == null) {
            throw new AudioControllerException("Playback device \"" + deviceName + "\" not found !");
        }
        try {
            this.player.setMixer(playbackMixer);
        }
        catch (PlayerException e1) {
            throw new AudioControllerException("Could not set playback device.", e1);
        }
    }

    @Override
    public synchronized void setCaptureDeviceByName(String deviceName) throws AudioControllerException {
        Mixer captureMixer;
        if (this.mm == null) {
            this.mm = new MixerManager();
        }
        if ((captureMixer = this.mm.getCaptureMixerByName(deviceName)) == null) {
            throw new AudioControllerException("Capture device \"" + deviceName + "\" not found !");
        }
        this.capture.setMixer(captureMixer);
    }

    @Override
    public AudioFormat getPlaybackAudioFormat() {
        if (this.player == null) {
            return null;
        }
        return this.player.getAudioFormat();
    }

    @Override
    public void openPlayback() throws AudioControllerException {
        try {
            this.player.open();
        }
        catch (PlayerException e) {
            throw new AudioControllerException(e);
        }
    }

    @Override
    public void closePlayback() throws AudioControllerException {
        try {
            this.player.close();
        }
        catch (PlayerException e) {
            throw new AudioControllerException(e);
        }
    }

    @Override
    public void openCapture() throws AudioControllerException {
        try {
            this.capture.open();
        }
        catch (CaptureException e) {
            throw new AudioControllerException(e);
        }
    }

    @Override
    public void closeCapture() throws AudioControllerException {
        try {
            this.capture.close();
        }
        catch (CaptureException e) {
            throw new AudioControllerException(e);
        }
    }

    @Override
    public boolean isCaptureOpen() {
        return this.capture.isOpen();
    }

    @Override
    public void setPlaybackFile(File playbackFile) throws AudioControllerException {
        try {
            this.player.setAudioSource(new FileAudioSource(playbackFile));
        }
        catch (PlayerException e) {
            throw new AudioControllerException(e);
        }
    }

    @Override
    public File getPlaybackFile() {
        if (this.player == null) {
            return null;
        }
        AudioSource as = this.player.getAudioSource();
        if (as instanceof FileAudioSource) {
            return ((FileAudioSource)as).getFile();
        }
        return null;
    }

    @Override
    public void setPlaybackAudioSource(AudioSource source) throws AudioControllerException {
        try {
            this.player.setAudioSource(source);
        }
        catch (PlayerException e) {
            throw new AudioControllerException(e);
        }
    }

    @Override
    public void setOverwrite(boolean overwrite) {
    }

    @Override
    public boolean isOverwrite() {
        return false;
    }

    @Override
    public void setRecordingFile(File recordingFile) {
        this.capture.setRecordingFile(recordingFile);
    }

    @Override
    public File getRecordingFile() {
        return this.capture.getRecordingFile();
    }

    @Override
    public void startPlayback() throws AudioControllerException {
        this.player.start();
    }

    @Override
    public void startCapture() throws AudioControllerException {
        this.capture.setCaptureOnly(true);
        this.capture.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startRecording() throws AudioControllerException {
        Capture3 capture3 = this.capture;
        synchronized (capture3) {
            this.capture.setCaptureOnly(false);
            this.capture.start();
        }
    }

    @Override
    public void pausePlayback() throws AudioControllerException {
        this.player.pause();
    }

    @Override
    public void stopPlayback() throws AudioControllerException {
        this.player.stop();
    }

    @Override
    public void stopCapture() throws AudioControllerException {
        try {
            this.capture.stop();
        }
        catch (CaptureException e) {
            throw new AudioControllerException(e);
        }
    }

    @Override
    public void stopRecording() throws AudioControllerException {
        try {
            this.capture.stop();
        }
        catch (CaptureException e) {
            throw new AudioControllerException(e);
        }
    }

    @Override
    public LevelInfo[] getCaptureLevelInfos() {
        return this.captureLevelMeasureStream.getLevelInfosBean().getLevelInfos();
    }

    @Override
    public LevelInfo[] getPlaybackLevelInfos() {
        return this.player.getLevelInfos();
    }

    @Override
    public boolean isPlaybackRandomPositioningSupported() {
        return false;
    }

    @Override
    public long getPlaybackFrameLength() {
        return this.player.getFrameLength();
    }

    @Override
    public long setPlaybackFramePosition(long newPosition) throws AudioControllerException {
        try {
            return this.player.setFramePosition(newPosition);
        }
        catch (PlayerException e) {
            throw new AudioControllerException(e);
        }
    }

    @Override
    public long getPlaybackFramePosition() {
        return this.player.getFramePosition();
    }

    @Override
    public void setPlaybackStartFramePosition(long startPosition) {
        this.player.setStartFramePosition(startPosition);
    }

    @Override
    public long getPlaybackStartFramePosition() {
        return this.player.getStartFramePosition();
    }

    @Override
    public void setPlaybackStopFramePosition(long stopPosition) {
        this.player.setStopFramePosition(stopPosition);
    }

    @Override
    public long getPlaybackStopFramePosition() {
        return this.player.getStopFramePosition();
    }

    @Override
    public long getCaptureFramePosition() {
        return this.capture.getFramePosition();
    }

    @Override
    public String[] getPropertyNames() {
        return new String[0];
    }

    @Override
    public String getPropertyDescription(String propertyName) {
        return null;
    }

    @Override
    public void setProperty(String propertyName, String value) {
    }

    @Override
    public String getProperty(String propertyName) {
        return null;
    }

    @Override
    public void addAudioController2Listener(AudioController2.AudioController2Listener acl) {
        if (acl != null && !this.listeners.contains(acl)) {
            this.listeners.addElement(acl);
        }
    }

    @Override
    public void removeAudioController2Listener(AudioController2.AudioController2Listener acl) {
        if (acl != null) {
            this.listeners.removeElement(acl);
        }
    }

    @Override
    public void setRecordingAudioFileFormat(AudioFileFormat audiofileFormat) {
        AudioFormat audioFormat = audiofileFormat.getFormat();
        int channels = audioFormat.getChannels();
        this.capture.setAudioFileFormat(audiofileFormat);
        boolean multiChannelMode = channels > 2;
        this.capture.setForceOpening(multiChannelMode);
    }

    @Override
    public AudioFileFormat getAudioFileFormat() {
        if (this.capture == null) {
            return null;
        }
        return this.capture.getAudioFileFormat();
    }

    @Override
    public void update(PlayerEvent playerEvent) {
        this.updateListeners(playerEvent);
    }

    @Override
    public void update(CaptureEvent captureEvent) {
        this.updateListeners(captureEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateListeners(AudioController2.AudioControllerEvent ace) {
        Vector<AudioController2.AudioController2Listener> vector = this.listeners;
        synchronized (vector) {
            for (AudioController2.AudioController2Listener listener : this.listeners) {
                listener.update(ace);
            }
        }
    }

    @Override
    public float getPreferredCaptureLineBufferSizeMilliSeconds() {
        return this.preferredCaptureLineBufferSizeMilliSeconds;
    }

    @Override
    public void setPreferredCaptureLineBufferSizeMilliSeconds(float preferredCaptureLineBufferSizeMilliSeconds) {
        this.preferredCaptureLineBufferSizeMilliSeconds = preferredCaptureLineBufferSizeMilliSeconds;
        this.capture.setPreferredLineBufferSizeMillis(Float.valueOf(preferredCaptureLineBufferSizeMilliSeconds));
    }

    @Override
    public float getPreferredPlaybackLineBufferSizeMilliSeconds() {
        return this.preferredPlaybackLineBufferSizeMilliSeconds;
    }

    @Override
    public void setPreferredPlaybackLineBufferSizeMilliSeconds(float preferredPlaybackLineBufferSizeMilliSeconds) {
        this.preferredPlaybackLineBufferSizeMilliSeconds = preferredPlaybackLineBufferSizeMilliSeconds;
        this.player.setPreferredLineBufferSizeMillis(Float.valueOf(preferredPlaybackLineBufferSizeMilliSeconds));
    }

    @Override
    public PrimaryRecordTarget getPrimaryRecordTarget() {
        return this.capture.getPrimaryRecordTarget();
    }

    @Override
    public void setPrimaryRecordTarget(PrimaryRecordTarget primaryRecordTarget) {
        this.capture.setPrimaryRecordTarget(primaryRecordTarget);
    }

    @Override
    public void setMaxRecordingFrameLength(Long maxFrameLength) {
        this.capture.setMaxFrameLength(maxFrameLength);
    }

    @Override
    public Long getMaxRecordingFrameLength() {
        return this.capture.getMaxFrameLength();
    }

    @Override
    public boolean isFileTransitionRecordingSupported() {
        return true;
    }

    @Override
    public File getRecordingSessionInfoFile() {
        return this.capture.getRecordingSessionInfoFile();
    }

    @Override
    public void setRecordingSessionInfoFile(File recordingSessionInfoFile) {
        this.capture.setWriteRecordingInfo(true);
        this.capture.setRecordingSessionInfoFile(recordingSessionInfoFile);
    }

    @Override
    public boolean isSessionInfoHandlingSupported() {
        return true;
    }

    @Override
    public boolean supportsDeviceProviders() {
        return true;
    }

    @Override
    public List<? extends DeviceProviderInfo> getDeviceProviderInfos() throws AudioControllerException {
        List<MixerProviderServiceDescriptor> mpsdList = AJSAudioSystem.listMixerProviderDescriptors();
        return mpsdList;
    }

    @Override
    public void setPlaybackDeviceByInfo(DeviceInfo deviceInfo) throws AudioControllerException {
        DeviceProviderInfo dpi = deviceInfo.getDeviceProviderInfo();
        String providerClassname = dpi.getImplementationClassname();
        String aiName = dpi.getAudioInterfaceName();
        List<MixerProviderServiceDescriptor> mpsdList = AJSAudioSystem.listMixerProviderDescriptors();
        if (providerClassname != null) {
            for (MixerProviderServiceDescriptor mpsd : mpsdList) {
                AJSDeviceInfo ajsDevInfo;
                AJSDevice device;
                if (!mpsd.isProvidesPlaybackDevices() || !providerClassname.equals(mpsd.getImplementationClassname()) || (device = AJSAudioSystem.getDevice(ajsDevInfo = new AJSDeviceInfo(mpsd, deviceInfo.getMixerInfo()))) == null) continue;
                try {
                    this.player.setMixer(device.getMixer());
                    return;
                }
                catch (PlayerException e) {
                    throw new AudioControllerException("Could not set playback device " + deviceInfo + ": " + e);
                }
            }
        } else if (aiName != null) {
            for (MixerProviderServiceDescriptor mpsd : mpsdList) {
                AJSDeviceInfo ajsDevInfo;
                AJSDevice device;
                String mpsdAi;
                if (!mpsd.isProvidesPlaybackDevices() || !(mpsdAi = mpsd.getAudioInterfaceName()).equals(aiName) || (device = AJSAudioSystem.getDevice(ajsDevInfo = new AJSDeviceInfo(mpsd, deviceInfo.getMixerInfo()))) == null) continue;
                try {
                    this.player.setMixer(device.getMixer());
                }
                catch (PlayerException e) {
                    continue;
                }
                return;
            }
        } else {
            for (MixerProviderServiceDescriptor mpsd : mpsdList) {
                AJSDeviceInfo ajsDevInfo;
                AJSDevice device;
                if (!mpsd.isProvidesPlaybackDevices() || (device = AJSAudioSystem.getDevice(ajsDevInfo = new AJSDeviceInfo(deviceInfo.getMixerInfo()))) == null) continue;
                try {
                    this.player.setMixer(device.getMixer());
                }
                catch (PlayerException e) {
                    throw new AudioControllerException("Could not set playback device " + deviceInfo);
                }
                return;
            }
        }
        throw new AudioControllerException("Could not set playback device " + deviceInfo);
    }

    @Override
    public void setCaptureDeviceByinfo(DeviceInfo deviceInfo) throws AudioControllerException {
        DeviceProviderInfo dpi = deviceInfo.getDeviceProviderInfo();
        String providerClassname = dpi.getImplementationClassname();
        String aiName = dpi.getAudioInterfaceName();
        List<MixerProviderServiceDescriptor> mpsdList = AJSAudioSystem.listMixerProviderDescriptors();
        if (providerClassname != null) {
            for (MixerProviderServiceDescriptor mpsd : mpsdList) {
                AJSDeviceInfo ajsDevInfo;
                AJSDevice device;
                if (!mpsd.isProvidesCaptureDevices() || !providerClassname.equals(mpsd.getImplementationClassname()) || (device = AJSAudioSystem.getDevice(ajsDevInfo = new AJSDeviceInfo(mpsd, deviceInfo.getMixerInfo()))) == null) continue;
                this.capture.setMixer(device.getMixer());
                return;
            }
        } else if (aiName != null) {
            for (MixerProviderServiceDescriptor mpsd : mpsdList) {
                AJSDeviceInfo ajsDevInfo;
                AJSDevice device;
                String mpsdAi;
                if (!mpsd.isProvidesCaptureDevices() || !(mpsdAi = mpsd.getAudioInterfaceName()).equals(aiName) || (device = AJSAudioSystem.getDevice(ajsDevInfo = new AJSDeviceInfo(mpsd, deviceInfo.getMixerInfo()))) == null) continue;
                this.capture.setMixer(device.getMixer());
                return;
            }
        } else {
            for (MixerProviderServiceDescriptor mpsd : mpsdList) {
                AJSDeviceInfo ajsDevInfo;
                AJSDevice device;
                if (!mpsd.isProvidesCaptureDevices() || (device = AJSAudioSystem.getDevice(ajsDevInfo = new AJSDeviceInfo(deviceInfo.getMixerInfo()))) == null) continue;
                this.capture.setMixer(device.getMixer());
                return;
            }
        }
        throw new AudioControllerException("Could not set capture device " + deviceInfo);
    }

    @Override
    public DeviceProvider getInstance(DeviceProviderInfo providerInfo) throws AudioControllerException {
        List<MixerProviderServiceDescriptor> mpsdList = AJSAudioSystem.listMixerProviderDescriptors();
        MixerProviderServiceDescriptor msd = null;
        for (MixerProviderServiceDescriptor mpsd : mpsdList) {
            String audioInterfaceName = mpsd.getAudioInterfaceName();
            if (!providerInfo.getAudioInterfaceName().equals(audioInterfaceName)) continue;
            msd = mpsd;
            break;
        }
        MixerProvider mp = AJSAudioSystem.getMixerProvider(msd);
        DeviceProviderImpl dp = new DeviceProviderImpl(mp, msd);
        return dp;
    }

    @Override
    public DeviceInfo convertLegacyDeviceName(String deviceName) throws AudioControllerException {
        AJSDeviceInfo ndi = null;
        List<MixerProviderServiceDescriptor> mpsdList = AJSAudioSystem.listMixerProviderDescriptors();
        for (MixerProviderServiceDescriptor mpsd : mpsdList) {
            String pSuffix = mpsd.getLegacyJavaSoundSuffix();
            if (pSuffix == null || deviceName == null || !deviceName.endsWith(pSuffix)) continue;
            String newName = deviceName.substring(0, deviceName.length() - pSuffix.length());
            AJSMixerInfo newMInfo = new AJSMixerInfo(newName);
            ndi = new AJSDeviceInfo(mpsd, newMInfo);
            break;
        }
        if (ndi == null) {
            for (MixerProviderServiceDescriptor mpsd : mpsdList) {
                if (!mpsd.isStandardJavaSoundWrapper()) continue;
                AJSMixerInfo deviceInfo = new AJSMixerInfo(deviceName);
                ndi = new AJSDeviceInfo(mpsd, deviceInfo);
                break;
            }
        }
        return ndi;
    }

    @Override
    public void setInputChannelRouting(ChannelRouting inputChannelRouting) {
        this.capture.setChannelRouting(inputChannelRouting);
    }

    @Override
    public ChannelRouting getInputChannelRouting() {
        return this.capture.getChannelRouting();
    }

    @Override
    public void stopRecording(boolean continueCapture) throws AudioControllerException {
        if (continueCapture) {
            this.capture.setCaptureOnly(true);
        } else {
            this.stopRecording();
        }
    }

    @Override
    public void addCaptureFloatAudioOutputStream(FloatAudioOutputStream floatAudioOutputStream) {
        this.captureOutputStream.addFloatAudioOutputStream(floatAudioOutputStream);
    }

    @Override
    public void removeCaptureFloatAudioOutputStream(FloatAudioOutputStream floatAudioOutputStream) {
        this.captureOutputStream.removeFloatAudioOutputStream(floatAudioOutputStream);
    }

    public static class AJSMixerInfo
    extends Mixer.Info {
        protected AJSMixerInfo(String arg0) {
            super(arg0, "", "", "");
        }
    }
}

