/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.plugins;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioPluginException;
import ipsk.audio.plugins.BasicPCMPlugin;
import ipsk.io.InterleaveEditInputStream;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class ChannelSelectorPlugin
extends BasicPCMPlugin {
    private int selectedChannel;

    public ChannelSelectorPlugin(int channel) {
        this.selectedChannel = channel;
    }

    @Override
    public AudioFormat[] getSupportedOutputFormats(AudioFormat inputFormat) {
        if (this.isInputFormatSupported(inputFormat)) {
            return new AudioFormat[]{this.getOutputFormat(inputFormat)};
        }
        return new AudioFormat[0];
    }

    @Override
    public boolean isOutputFormatSupported(AudioFormat inputFormat, AudioFormat outputFormat) {
        return this.isInputFormatSupported(inputFormat) && outputFormat.matches(this.getOutputFormat(inputFormat));
    }

    @Override
    public void setOutputFormat(AudioFormat outputFormat) throws AudioFormatNotSupportedException {
        if (!this.isOutputFormatSupported(this.inputFormat, outputFormat)) {
            throw new AudioFormatNotSupportedException(outputFormat);
        }
        this.outputFormat = outputFormat;
    }

    public AudioFormat getOutputFormat(AudioFormat inputFormat) {
        if (!this.isInputFormatSupported(inputFormat)) {
            return null;
        }
        AudioFormat outputFormat = new AudioFormat(inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), 1, inputFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED, inputFormat.isBigEndian());
        return outputFormat;
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioInputStream ais) throws AudioPluginException {
        AudioFormat af = ais.getFormat();
        long frameLength = ais.getFrameLength();
        int channels = af.getChannels();
        if (channels <= this.selectedChannel) {
            throw new AudioPluginException("Cannot select channel " + this.selectedChannel + ": stream has only " + channels + " channels.");
        }
        int frameSize = af.getFrameSize();
        int sampleSize = frameSize / channels;
        int frameOffset = this.selectedChannel * sampleSize;
        AudioFormat outFormat = new AudioFormat(af.getSampleRate(), af.getSampleSizeInBits(), 1, af.getEncoding() == AudioFormat.Encoding.PCM_SIGNED, af.isBigEndian());
        InterleaveEditInputStream eis = new InterleaveEditInputStream((InputStream)ais, frameSize, frameOffset, sampleSize);
        AudioInputStream editAudioInputStream = new AudioInputStream((InputStream)eis, outFormat, frameLength);
        return editAudioInputStream;
    }

    public int getSelectedChannel() {
        return this.selectedChannel;
    }

    public void setSelectedChannel(int selectedChannel) {
        this.selectedChannel = selectedChannel;
    }
}

