/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.synth;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioSourceException;
import ipsk.audio.BasicAudioSource;
import ipsk.audio.synth.WhiteNoiseGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class WhiteNoiseGeneratorSource
extends BasicAudioSource {
    private long length;
    private AudioFormat audioFormat;

    public WhiteNoiseGeneratorSource() {
        this(new AudioFormat(44100.0f, 16, 1, true, false), -1L);
    }

    public WhiteNoiseGeneratorSource(AudioFormat audioFormat, long length) {
        this.audioFormat = audioFormat;
        this.length = length;
    }

    @Override
    public AudioInputStream getAudioInputStream() throws AudioSourceException {
        WhiteNoiseGenerator wng;
        try {
            wng = new WhiteNoiseGenerator(this.audioFormat, this.length);
        }
        catch (AudioFormatNotSupportedException e) {
            throw new AudioSourceException(e);
        }
        return new AudioInputStream((InputStream)((Object)wng), this.audioFormat, this.length);
    }

    @Override
    public long getFrameLength() throws AudioSourceException {
        return this.length;
    }

    @Override
    public AudioFormat getFormat() throws AudioSourceException {
        return this.audioFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        WhiteNoiseGeneratorSource swg = new WhiteNoiseGeneratorSource(new AudioFormat(48000.0f, 16, 2, true, false), 10000000L);
        AudioInputStream swgAis = null;
        try {
            swgAis = swg.getAudioInputStream();
            AudioSystem.write(swgAis, AudioFileFormat.Type.WAVE, new File("test.wav"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (AudioSourceException e) {
            e.printStackTrace();
        }
        finally {
            if (swgAis != null) {
                try {
                    swgAis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

