/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.ui;

import ipsk.audio.actions.LoopAction;
import ipsk.audio.actions.PauseAction;
import ipsk.audio.actions.SetFramePositionAction;
import ipsk.audio.actions.StartPlaybackAction;
import ipsk.audio.actions.StartRecordAction;
import ipsk.audio.actions.StopAction;
import ipsk.audio.events.FramePositionActionEvent;
import ipsk.audio.events.PauseActionEvent;
import ipsk.audio.events.StartPlaybackActionEvent;
import ipsk.text.MediaTimeFormat;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TransportUI
extends JPanel
implements PropertyChangeListener,
ChangeListener {
    private static final boolean DEBUG = false;
    static final int STOP = 0;
    static final int PAUSE = 1;
    static final int PLAY_PAUSE = 2;
    static final int PLAY = 3;
    static final int REC_PAUSE = 4;
    static final int REC = 5;
    static final int BUSY = 6;
    static final int CLOSE = 7;
    private boolean pendingStart = false;
    private boolean posUpdate;
    private long playbackFramePos;
    private long playbackFrameLength;
    private JButton playB;
    private JButton recB;
    private JButton stopB;
    private JButton pauseB;
    private JCheckBox loopBox;
    private JTextField framePosLabel;
    private JPanel buttonPanel;
    private JPanel posPanel;
    private JSlider posSlider;
    private MediaTimeFormat timeFormatter;
    private Vector<ActionListener> listenerList = new Vector();
    private float frameRate;
    private boolean showRecordingUI = true;
    private StartPlaybackAction startPlaybackAction;
    private StartRecordAction startRecordAction;
    private StopAction stopAction;
    private PauseAction pauseAction;
    private boolean paused;
    private SetFramePositionAction setFramePositionAction;
    private LoopAction loopAction;

    TransportUI() {
    }

    public TransportUI(StartPlaybackAction startAction, StopAction stopAction) {
        this(startAction, stopAction, null);
    }

    public TransportUI(StartPlaybackAction startAction, StopAction stopAction, PauseAction pauseAction) {
        this(startAction, stopAction, pauseAction, null, null, null);
    }

    public TransportUI(StartPlaybackAction startAction, StopAction stopAction, PauseAction pauseAction, LoopAction loopAction) {
        this(startAction, stopAction, pauseAction, null, null, loopAction);
    }

    public TransportUI(StartPlaybackAction spa, StopAction stopAction, PauseAction pauseAction, SetFramePositionAction setFramePositionAction, StartRecordAction startRecordAction, LoopAction loopAction) {
        this.startPlaybackAction = spa;
        this.stopAction = stopAction;
        this.pauseAction = pauseAction;
        this.setFramePositionAction = setFramePositionAction;
        this.startRecordAction = startRecordAction;
        this.loopAction = loopAction;
        this.setLayout(new BorderLayout());
        this.framePosLabel = new JTextField("0", 10);
        this.framePosLabel.setEditable(false);
        this.framePosLabel.setHorizontalAlignment(4);
        this.playbackFrameLength = 100000L;
        this.buttonPanel = new JPanel(new FlowLayout());
        this.playB = new JButton(this.startPlaybackAction);
        this.playB.setBackground(Color.GREEN.darker());
        this.buttonPanel.add(this.playB);
        if (this.showRecordingUI && startRecordAction != null) {
            this.recB = new JButton(startRecordAction);
            this.recB.setBackground(Color.RED.darker());
            this.buttonPanel.add(this.recB);
            startRecordAction.addPropertyChangeListener(this);
        }
        this.stopB = new JButton(stopAction);
        this.stopB.setBackground(Color.YELLOW.darker());
        this.buttonPanel.add(this.stopB);
        if (pauseAction != null) {
            this.pauseB = new JButton(pauseAction);
            this.pauseB.setBackground(Color.YELLOW.darker());
            this.buttonPanel.add(this.pauseB);
            pauseAction.addPropertyChangeListener(this);
        }
        if (loopAction != null) {
            this.loopBox = new JCheckBox(loopAction);
            this.buttonPanel.add(this.loopBox);
        }
        this.posUpdate = false;
        if (setFramePositionAction != null) {
            this.posSlider = new JSlider();
            this.posSlider.setMinimum(0);
            this.posSlider.setMaximum((int)this.playbackFrameLength);
            this.posSlider.setMajorTickSpacing(500000);
            this.posSlider.setPaintTicks(true);
            this.posSlider.addChangeListener(this);
            this.posPanel = new JPanel(new GridLayout(2, 1));
            this.posPanel.add(this.framePosLabel);
            this.posPanel.add(this.posSlider);
            this.add((Component)this.posPanel, "Center");
            this.add((Component)this.buttonPanel, "North");
            setFramePositionAction.addPropertyChangeListener(this);
        } else {
            this.add((Component)this.buttonPanel, "Center");
        }
        this.timeFormatter = new MediaTimeFormat();
        this.startPlaybackAction.addPropertyChangeListener(this);
        stopAction.addPropertyChangeListener(this);
        this.validate();
        this.repaint();
    }

    @Override
    public synchronized void stateChanged(ChangeEvent ev) {
        JSlider source = (JSlider)ev.getSource();
        if (!source.getValueIsAdjusting() && !this.posUpdate) {
            if (source == this.posSlider) {
                long newPos = source.getValue();
                if (this.paused && this.pendingStart) {
                    this.pendingStart = false;
                    FramePositionActionEvent fpae = new FramePositionActionEvent((Object)this, newPos);
                    this.setFramePositionAction.actionPerformed(fpae);
                    StartPlaybackActionEvent spae = new StartPlaybackActionEvent(this);
                    this.startPlaybackAction.actionPerformed(spae);
                } else if (this.paused) {
                    FramePositionActionEvent fpae = new FramePositionActionEvent((Object)this, newPos);
                    this.setFramePositionAction.actionPerformed(fpae);
                }
            }
        } else if (source.getValueIsAdjusting() && !this.posUpdate && source == this.posSlider && this.posSlider.isEnabled()) {
            this.setPosLabel(source.getValue());
            if (!this.paused) {
                PauseActionEvent ppae = new PauseActionEvent(this);
                this.pauseAction.actionPerformed(ppae);
                this.pendingStart = true;
            }
        }
    }

    public void setFrameLength(long length) {
        this.playbackFrameLength = length;
        this.posUpdate = true;
        this.posSlider.setMaximum((int)this.playbackFrameLength);
        this.posUpdate = false;
    }

    private void setPosLabel(long pos) {
        Double formatObj = null;
        if (pos != -1L) {
            double seconds = (float)pos / this.frameRate;
            formatObj = new Double(seconds);
            this.framePosLabel.setText(this.timeFormatter.format((Object)formatObj));
        } else {
            this.framePosLabel.setText(this.timeFormatter.format(null));
        }
    }

    public synchronized void setFramePosition(long pos) {
        this.playbackFramePos = pos;
        if (!this.posSlider.getValueIsAdjusting()) {
            if (!this.paused) {
                this.posUpdate = true;
                this.posSlider.setValue((int)this.playbackFramePos);
                this.posUpdate = false;
            }
            this.setPosLabel(this.playbackFramePos);
        }
    }

    public synchronized void addActionListener(ActionListener acl) {
        if (acl != null && !this.listenerList.contains(acl)) {
            this.listenerList.addElement(acl);
        }
    }

    public synchronized void removeActionListener(ActionListener acl) {
        if (acl != null) {
            this.listenerList.removeElement(acl);
        }
    }

    protected synchronized void fireActionEvent(ActionEvent ae) {
        for (ActionListener listener : this.listenerList) {
            listener.actionPerformed(ae);
        }
    }

    public float getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(float f) {
        this.frameRate = f;
    }

    public boolean isShowRecordingUI() {
        return this.showRecordingUI;
    }

    public synchronized void setShowRecordingUI(boolean b) {
        if (this.showRecordingUI != b) {
            if (!b) {
                this.buttonPanel.remove(this.recB);
            }
            this.showRecordingUI = b;
        }
    }

    public StartPlaybackAction getStartPlaybackAction() {
        return this.startPlaybackAction;
    }

    public void setStartPlaybackAction(StartPlaybackAction startPlaybackAction) {
        this.startPlaybackAction.removePropertyChangeListener(this);
        this.startPlaybackAction = startPlaybackAction;
        if (this.playB != null) {
            this.playB.setAction(this.startPlaybackAction);
        }
        this.startPlaybackAction.addPropertyChangeListener(this);
    }

    public PauseAction getPauseAction() {
        return this.pauseAction;
    }

    public void setPauseAction(PauseAction pauseAction) {
        this.pauseAction = pauseAction;
        if (this.pauseB != null) {
            this.pauseB.setAction(pauseAction);
        }
    }

    public StartRecordAction getStartRecordAction() {
        return this.startRecordAction;
    }

    public void setStartRecordAction(StartRecordAction startRecordAction) {
        this.startRecordAction = startRecordAction;
    }

    public StopAction getStopAction() {
        return this.stopAction;
    }

    public void setStopAction(StopAction stopAction) {
        this.stopAction.removePropertyChangeListener(this);
        this.stopAction = stopAction;
        if (this.stopB != null) {
            this.stopB.setAction(this.stopAction);
        }
        this.stopAction.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object src = evt.getSource();
        if (src == this.startPlaybackAction) {
            if (this.startPlaybackAction.isHighlighted()) {
                this.playB.setBackground(Color.GREEN);
            } else {
                this.playB.setBackground(Color.GREEN.darker());
            }
        } else if (src == this.stopAction) {
            if (this.stopAction.isHighlighted()) {
                this.stopB.setBackground(Color.YELLOW);
            } else {
                this.stopB.setBackground(Color.YELLOW.darker());
            }
        } else if (src == this.pauseAction) {
            if (this.pauseAction.isHighlighted()) {
                this.pauseB.setBackground(Color.YELLOW);
            } else {
                this.pauseB.setBackground(Color.YELLOW.darker());
            }
        } else if (src == this.startRecordAction) {
            if (this.startRecordAction.isHighlighted()) {
                this.recB.setBackground(Color.RED);
            } else {
                this.recB.setBackground(Color.RED.darker());
            }
        } else if (src == this.setFramePositionAction) {
            boolean framePositioningEnabled = this.setFramePositionAction.isEnabled();
            this.posSlider.setEnabled(framePositioningEnabled);
            if (!framePositioningEnabled) {
                this.posSlider.setValueIsAdjusting(false);
            }
        }
    }

    public void setPaused(boolean b) {
        this.paused = b;
    }

    public boolean isPaused() {
        return this.paused;
    }
}

