/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.arr.clip.ui;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.FileAudioSource;
import ipsk.audio.arr.clip.AudioClip;
import ipsk.audio.arr.clip.AudioClipListener;
import ipsk.audio.arr.clip.events.AudioClipChangedEvent;
import ipsk.audio.arr.clip.events.AudioSourceChangedEvent;
import ipsk.audio.arr.clip.events.FramePositionChangedEvent;
import ipsk.audio.arr.clip.ui.AudioClipUI;
import ipsk.audio.arr.clip.ui.AudioSignalRenderer;
import ipsk.audio.arr.clip.ui.AudioSignalRendererEvent;
import ipsk.audio.arr.clip.ui.AudioSignalRendererListener;
import ipsk.audio.arr.clip.ui.BasicAudioClipUI;
import ipsk.audio.dsp.DSPUtils;
import ipsk.awt.GridTick;
import ipsk.awt.JScale;
import ipsk.swing.action.tree.AbstractActionLeaf;
import ipsk.swing.action.tree.ActionFolder;
import ipsk.swing.action.tree.ActionNode;
import ipsk.swing.action.tree.ActionTreeRoot;
import ipsk.swing.action.tree.RadioActionGroup;
import ipsk.swing.action.tree.RadioActionLeaf;
import ipsk.swing.scale.JDecimalAutoScale;
import ipsk.swing.scale.JMinimalScale;
import ipsk.util.LocalizableMessage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.math.BigDecimal;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.Scrollable;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;

public class AudioSignalUI
extends BasicAudioClipUI
implements Scrollable,
MouseListener,
MouseMotionListener,
AudioClipUI,
AudioClipListener,
AudioSignalRendererListener {
    private static final long serialVersionUID = 8102370942833020055L;
    private final boolean DEBUG = false;
    private final int DEFAULT_BORDER_LENGTH = 5;
    private final Color DEFAULT_BACKGROUND_COLOR = Color.BLACK;
    private final Color DEFAULT_SIGNAL_COLOR = Color.GREEN;
    private final Color DEFAULT_SIGNAL_COLOR_SELECTED = Color.YELLOW.darker();
    public static final int DEFAULT_BASELOG_LEVEL = -40;
    private boolean rendered = false;
    private int imgHeight;
    private int borderLength = 5;
    private MouseEvent pressedEvent = null;
    private MouseEvent dragStartEvent = null;
    private MouseEvent selEndMoveEvent;
    private MouseEvent selStartMoveEvent;
    private MouseEvent mouseOverResizeWest;
    private MouseEvent mouseOverResizeEast;
    private int preferredHeight = 60;
    private boolean imgHeightSet = false;
    private JMinimalScale[] yScales;
    private JPanel yScalesComponent;
    private AmplitudeScaleType amplitudeScaleType = AmplitudeScaleType.LINEAR;
    private int baseLogLevel = -40;
    private JPanel controlPanel;
    private ActionTreeRoot actionTree = new ActionTreeRoot();
    private boolean paintPolygons = true;
    private SetAmplitudeScaleTypeLinearAction setAmplitudeScaleTypeLinearAction = new SetAmplitudeScaleTypeLinearAction();
    private SetAmplitudeScaleTypeLogarithmAction setAmplitudeScaleTypeLogarithmAction = new SetAmplitudeScaleTypeLogarithmAction();
    private SetBaseLogLevelAction setBaseLogLevelAction;
    private AudioSignalRenderer renderer;
    private boolean useThread = true;
    private int pixelPosition;
    private int selectorWidth = 3;
    private SpinnerNumberModel amplitudeBaseLevelSpinnerModel;
    private JSpinner amplitudeBaseLevelSpinner;
    private boolean changeSelectionOnDrag = false;

    public int getBaseLogLevel() {
        return this.baseLogLevel;
    }

    public void setBaseLogLevel(int baseLogLevel) {
        this.baseLogLevel = baseLogLevel;
        if (AmplitudeScaleType.LOGARITHM.equals((Object)this.amplitudeScaleType)) {
            this.updateYScales();
        }
        this.repaint();
    }

    public AudioSignalUI() {
        this.setBackground(this.DEFAULT_BACKGROUND_COLOR);
        ActionFolder viewFolder = ActionFolder.buildTopLevelFolder((String)"view");
        RadioActionGroup actionGroup = new RadioActionGroup();
        actionGroup.add((RadioActionLeaf)this.setAmplitudeScaleTypeLinearAction);
        actionGroup.add((RadioActionLeaf)this.setAmplitudeScaleTypeLogarithmAction);
        this.setAmplitudeScaleTypeLinearAction.setSelected(true);
        this.setAmplitudeScaleTypeLinearAction.setRadioActionGroup(actionGroup);
        this.setAmplitudeScaleTypeLogarithmAction.setRadioActionGroup(actionGroup);
        ActionFolder timeSignalFolder = new ActionFolder("time_signal", new LocalizableMessage("Time signal"));
        timeSignalFolder.add((ActionNode)this.setAmplitudeScaleTypeLinearAction);
        timeSignalFolder.add((ActionNode)this.setAmplitudeScaleTypeLogarithmAction);
        this.setBaseLogLevelAction = new SetBaseLogLevelAction();
        timeSignalFolder.add((ActionNode)this.setBaseLogLevelAction);
        this.amplitudeBaseLevelSpinnerModel = new SpinnerNumberModel(-40, -120, 0, 1);
        this.amplitudeBaseLevelSpinner = new JSpinner(this.amplitudeBaseLevelSpinnerModel);
        viewFolder.add((ActionNode)timeSignalFolder);
        this.actionTree.add((ActionNode)viewFolder);
        this.listenerList = new Vector();
        this.yScalesComponent = new JPanel();
        this.yScalesComponent.setLayout(null);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public AudioSignalUI(AudioClip audioSample) throws AudioFormatNotSupportedException, AudioSourceException {
        this();
        this.setAudioSample(audioSample);
    }

    @Override
    public String getName() {
        return "Audio signal";
    }

    public void setImgHeight(int imgHeight) {
        this.imgHeight = imgHeight;
        this.imgHeightSet = true;
    }

    public AmplitudeScaleType getAmplitudeScaleType() {
        return this.amplitudeScaleType;
    }

    public void setAmplitudeScaleType(AmplitudeScaleType amplitudeScaleType) {
        this.amplitudeScaleType = amplitudeScaleType;
        this.setAmplitudeScaleTypeLinearAction.setEnabled(!AmplitudeScaleType.LINEAR.equals((Object)amplitudeScaleType));
        this.setAmplitudeScaleTypeLogarithmAction.setEnabled(!AmplitudeScaleType.LOGARITHM.equals((Object)amplitudeScaleType));
        this.updateYScales();
        this.repaint();
    }

    public void clear() {
        this.clearScreen();
    }

    public void clearScreen() {
        this.setCursor();
        this.repaint();
    }

    @Override
    public void audioClipChanged(AudioClipChangedEvent event) {
        super.audioClipChanged(event);
        if (event instanceof FramePositionChangedEvent) {
            this.setFramePosition(((FramePositionChangedEvent)event).getPosition());
        } else if (event instanceof AudioSourceChangedEvent) {
            this.close();
            this.clear();
            AudioSource as = ((AudioSourceChangedEvent)event).getAudioSource();
            if (as != null) {
                try {
                    if (this.renderer != null) {
                        this.renderer.close();
                    }
                    this.renderer = new AudioSignalRenderer(as, this);
                }
                catch (AudioFormatNotSupportedException e) {
                    JOptionPane.showMessageDialog(this, "Audio format not supported\n" + e.getLocalizedMessage(), "Audio signal renderer", 1);
                    e.printStackTrace();
                }
                catch (AudioSourceException e) {
                    JOptionPane.showMessageDialog(this, "Audio source error: \n" + e.getLocalizedMessage(), "Audio signal renderer error", 0);
                    e.printStackTrace();
                }
            }
            this.updateYScales();
        }
    }

    private void updateYScales() {
        this.yScalesComponent.removeAll();
        if (this.audioSource != null) {
            if (this.amplitudeScaleType == null || AmplitudeScaleType.LINEAR.equals((Object)this.amplitudeScaleType)) {
                this.yScales = new JMinimalScale[this.channels];
                for (int i = 0; i < this.yScales.length; ++i) {
                    this.yScales[i] = new JMinimalScale(JScale.Orientation.WEST, BigDecimal.valueOf(-1L, 0), BigDecimal.valueOf(1L, 0));
                    this.yScalesComponent.add((Component)this.yScales[i]);
                }
            } else if (AmplitudeScaleType.LOGARITHM.equals((Object)this.amplitudeScaleType)) {
                this.yScales = new JMinimalScale[this.channels * 2];
                for (int ch = 0; ch < this.channels; ++ch) {
                    int i = ch * 2;
                    this.yScales[i] = new JMinimalScale(JScale.Orientation.WEST, BigDecimal.valueOf(0L, 0), BigDecimal.valueOf(this.baseLogLevel, 0));
                    this.yScalesComponent.add((Component)this.yScales[i]);
                    this.yScales[i + 1] = new JMinimalScale(JScale.Orientation.WEST, BigDecimal.valueOf(this.baseLogLevel, 0), BigDecimal.valueOf(0L, 0));
                    this.yScalesComponent.add((Component)this.yScales[i + 1]);
                }
            }
        }
        this.doScalesLayout();
        this.yScalesComponent.revalidate();
        this.yScalesComponent.repaint();
    }

    private void doScalesLayout() {
        int compH = this.getSize().height;
        if (this.yScales != null && this.yScales.length > 0) {
            JMinimalScale yScale;
            int i;
            int scaleHeight = (compH - 2 * this.borderLength) / this.yScales.length;
            int scaleWidth = 0;
            for (i = 0; i < this.yScales.length; ++i) {
                yScale = this.yScales[i];
                if (yScale == null) continue;
                if (yScale instanceof JDecimalAutoScale) {
                    ((JDecimalAutoScale)yScale).setLength(scaleHeight);
                }
                Dimension scalePrefSize = yScale.getPreferredSize();
                int sW = scalePrefSize.width;
                if (sW <= scaleWidth) continue;
                scaleWidth = sW;
            }
            for (i = 0; i < this.yScales.length; ++i) {
                yScale = this.yScales[i];
                if (yScale == null) continue;
                int sYPos = this.borderLength + scaleHeight * i;
                Dimension scalePrefSize = yScale.getPreferredSize();
                int sW = scalePrefSize.width;
                yScale.setBounds(scaleWidth - sW, sYPos, sW, scaleHeight);
                yScale.doLayout();
            }
            Dimension preferredSize = new Dimension(scaleWidth, compH);
            this.yScalesComponent.setPreferredSize(preferredSize);
        } else {
            Dimension preferredSize = new Dimension(0, compH);
            this.yScalesComponent.setPreferredSize(preferredSize);
        }
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.clear();
        this.updateYScales();
        this.doScalesLayout();
    }

    @Override
    public double getLengthInSeconds() {
        return this.lengthInSeconds;
    }

    private void setCursor() {
        if (this.dragStartEvent != null) {
            if (this.dragStartEvent == this.selStartMoveEvent) {
                this.setCursor(Cursor.getPredefinedCursor(10));
            } else if (this.dragStartEvent == this.selStartMoveEvent) {
                this.setCursor(Cursor.getPredefinedCursor(11));
            }
        } else if (this.mouseOverResizeWest != null) {
            this.setCursor(Cursor.getPredefinedCursor(10));
        } else if (this.mouseOverResizeEast != null) {
            this.setCursor(Cursor.getPredefinedCursor(11));
        } else if (this.rendered) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    private void setFramePosition(long position) {
        int oldPixelPosition = this.pixelPosition;
        this.pixelPosition = this.mapFrameToPixel(position);
        if (EventQueue.isDispatchThread()) {
            this.paintImmediately(oldPixelPosition, 0, 1, this.getHeight());
            this.paintImmediately(this.pixelPosition, 0, 1, this.getHeight());
        } else {
            this.repaint(oldPixelPosition, 0, 1, this.getHeight());
            this.repaint(this.pixelPosition, 0, 1, this.getHeight());
        }
    }

    @Override
    public void printComponent(Graphics g) {
        super.printComponent(g);
        this._paintOrPrintComponent(g, false, true);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this._paintOrPrintComponent(g, this.useThread, false);
    }

    private void _paintOrPrintComponent(Graphics g, boolean useThread, boolean printMode) {
        Rectangle clipBounds = g.getClipBounds();
        if (this.audioSample == null || this.audioSample.getAudioSource() == null || this.channels == 0 || this.pixelsPerFrame == 0.0 || this.renderer == null) {
            return;
        }
        GridTick[] ticks = null;
        FontMetrics gf = g.getFontMetrics();
        int fontHeight = gf.getHeight();
        int height = this.getHeight();
        this.imgHeight = (height - 2 * this.borderLength) / this.channels;
        int paintFrom = clipBounds.x - (int)this.pixelsPerFrame - 1;
        if (paintFrom < 0) {
            paintFrom = 0;
        }
        int paintTo = clipBounds.x + clipBounds.width + (int)this.pixelsPerFrame + 1;
        if (this.showTimeScaleGrid && this.timeScaleTickProvider != null && (ticks = this.timeScaleTickProvider.getScaleTicks(clipBounds.x, clipBounds.x + clipBounds.width)) != null) {
            g.setColor(this.DEFAULT_TIME_GRID_COLOR);
            for (GridTick gt : ticks) {
                int gtPos = gt.getPosition();
                g.drawLine(gtPos, 0, gtPos, height);
            }
        }
        AudioSignalRenderer.RenderResult rr = null;
        try {
            rr = this.renderer.render(paintFrom, paintTo, this.framesPerPixel, useThread, printMode);
        }
        catch (AudioSourceException e) {
            e.printStackTrace();
        }
        this.rendered = rr.rendered;
        int[] minY = new int[this.channels];
        int[] maxY = new int[this.channels];
        int[][] polyX = new int[this.channels][4];
        int[][] polyY = new int[this.channels][4];
        g.setColor(this.DEFAULT_SIGNAL_COLOR);
        boolean firstValue = true;
        int to = rr.offset + rr.length;
        for (int valPos = rr.offset; valPos < to; ++valPos) {
            AudioSignalRenderer.Value v = rr.values[valPos];
            if (v == null) continue;
            int pixelPos = valPos + rr.pixelOffset;
            if (this.viewSelection != null) {
                if (this.viewSelection.isInXSelection(pixelPos)) {
                    g.setColor(this.DEFAULT_SIGNAL_COLOR_SELECTED);
                } else {
                    g.setColor(this.DEFAULT_SIGNAL_COLOR);
                }
            }
            for (int i = 0; i < this.channels; ++i) {
                double maxLevel;
                double minLevel;
                if (this.amplitudeScaleType.equals((Object)AmplitudeScaleType.LINEAR)) {
                    minLevel = v.min[i];
                    maxLevel = v.max[i];
                } else {
                    double normDblevelMax;
                    double logLevelMin = DSPUtils.toPowerLevelInDB(Math.abs(v.min[i]));
                    double logLevelMax = DSPUtils.toPowerLevelInDB(Math.abs(v.max[i]));
                    double normDblevelMin = 1.0 - logLevelMin / (double)this.baseLogLevel;
                    if (normDblevelMin < 0.0) {
                        normDblevelMin = 0.0;
                    }
                    if ((normDblevelMax = 1.0 - logLevelMax / (double)this.baseLogLevel) < 0.0) {
                        normDblevelMax = 0.0;
                    }
                    if (v.min[i] < 0.0) {
                        normDblevelMin = -normDblevelMin;
                    }
                    if (v.max[i] < 0.0) {
                        normDblevelMax = -normDblevelMax;
                    }
                    minLevel = normDblevelMin;
                    maxLevel = normDblevelMax;
                }
                minY[i] = (int)((0.5 - minLevel / 2.0) * (double)this.imgHeight + (double)(i * this.imgHeight) + (double)this.borderLength);
                maxY[i] = (int)((0.5 - maxLevel / 2.0) * (double)this.imgHeight + (double)(i * this.imgHeight) + (double)this.borderLength);
                if (this.paintPolygons) {
                    if (firstValue) {
                        polyX[i][0] = pixelPos;
                        polyY[i][0] = minY[i];
                        polyX[i][1] = pixelPos;
                        polyY[i][1] = maxY[i];
                        polyX[i][2] = pixelPos;
                        polyY[i][2] = minY[i];
                        polyX[i][3] = pixelPos;
                        polyY[i][3] = maxY[i];
                    } else {
                        polyX[i][0] = polyX[i][2];
                        polyY[i][0] = polyY[i][2];
                        polyX[i][1] = polyX[i][3];
                        polyY[i][1] = polyY[i][3];
                        polyX[i][2] = pixelPos;
                        polyY[i][2] = minY[i];
                        polyX[i][3] = pixelPos;
                        polyY[i][3] = maxY[i];
                    }
                    g.drawLine(polyX[i][0], polyY[i][0], polyX[i][1], polyY[i][1]);
                    g.drawLine(polyX[i][1], polyY[i][1], polyX[i][2], polyY[i][2]);
                    g.drawLine(polyX[i][2], polyY[i][2], polyX[i][3], polyY[i][3]);
                    g.drawLine(polyX[i][3], polyY[i][3], polyX[i][0], polyY[i][0]);
                    continue;
                }
                g.drawLine(pixelPos, minY[i], pixelPos, maxY[i]);
            }
            firstValue = false;
        }
        if (this.viewSelection != null) {
            g.setColor(Color.YELLOW);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
            int pixelPos = this.viewSelection.getXStart();
            g.drawLine(pixelPos, 0, pixelPos, height);
            String startStr = null;
            String endStr = null;
            startStr = this.formatPosition(this.viewSelection.getStart());
            endStr = this.formatPosition(this.viewSelection.getEnd());
            g.drawString(startStr, pixelPos, height - fontHeight);
            String selLengthStr = "Sel. length: " + this.formatPosition(this.viewSelection.getLength());
            g.drawString(selLengthStr, this.viewSelection.getXLeft(), 0 + fontHeight);
            pixelPos = this.viewSelection.getXEnd();
            g.drawLine(pixelPos, 0, pixelPos, height);
            g.drawString(endStr, pixelPos, height - fontHeight);
        }
        if (!printMode) {
            g.setColor(Color.RED);
            g.drawLine(this.pixelPosition, 0, this.pixelPosition, height);
            this.setCursor();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.getWidth(), 3);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.imgHeightSet) {
            return new Dimension(this.getWidth(), this.imgHeight);
        }
        return new Dimension(this.getWidth(), this.preferredHeight);
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle arg0, int arg1, int arg2) {
        return 50;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle arg0, int arg1, int arg2) {
        return 1;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    private void doSetBaseLogLevel() {
        int currentBaseLevel = this.getBaseLogLevel();
        this.amplitudeBaseLevelSpinnerModel.setValue(currentBaseLevel);
        int retVal = JOptionPane.showOptionDialog(this, this.amplitudeBaseLevelSpinner, "Logarithm base level", 2, -1, null, null, null);
        if (retVal == 0) {
            this.setBaseLogLevel((Integer)this.amplitudeBaseLevelSpinnerModel.getValue());
        } else {
            this.amplitudeBaseLevelSpinner.setValue(this.getBaseLogLevel());
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        long newSamplePosition = this.mapPixelToFrame(arg0.getX());
        this.audioSample.setFramePosition(newSamplePosition);
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    private boolean isInSelectorStart(int x) {
        int xStart = this.viewSelection.getXStart();
        return x >= xStart - this.selectorWidth && x <= xStart + this.selectorWidth;
    }

    private boolean isInSelectorEnd(int x) {
        int xEnd = this.viewSelection.getXEnd();
        return x >= xEnd - this.selectorWidth && x <= xEnd + this.selectorWidth;
    }

    private boolean isInSelectorLeft(int x) {
        int xLeft = this.viewSelection.getXLeft();
        return x >= xLeft - this.selectorWidth && x <= xLeft + this.selectorWidth;
    }

    private boolean isInSelectorRight(int x) {
        int xRight = this.viewSelection.getXRight();
        return x >= xRight - this.selectorWidth && x <= xRight + this.selectorWidth;
    }

    private void selectionByMouse(MouseEvent me) {
        if (this.dragStartEvent != null) {
            if (this.viewSelection != null) {
                this.viewSelection.limitTo(0L, this.length);
                this.audioSample.setSelection(this.viewSelection.getSelection());
                this.repaint();
            }
            this.checkMouseResizeSelection(me);
        }
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        this.dragStartEvent = null;
        this.pressedEvent = null;
        this.selStartMoveEvent = null;
        this.selEndMoveEvent = null;
        if (arg0.isPopupTrigger()) {
            this.getParent().dispatchEvent(arg0);
        } else {
            int x = arg0.getX();
            if (this.viewSelection != null) {
                if (this.isInSelectorStart(x)) {
                    this.selStartMoveEvent = arg0;
                } else if (this.isInSelectorEnd(x)) {
                    this.selEndMoveEvent = arg0;
                } else {
                    this.pressedEvent = arg0;
                }
                this.repaint();
            } else {
                this.pressedEvent = arg0;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        if (arg0.isPopupTrigger()) {
            this.getParent().dispatchEvent(arg0);
        } else {
            this.selectionByMouse(arg0);
        }
        this.dragStartEvent = null;
    }

    @Override
    public synchronized void mouseDragged(MouseEvent arg0) {
        if (this.pressedEvent != null) {
            this.dragStartEvent = this.pressedEvent;
            if (this.viewSelection == null) {
                this.viewSelection = new BasicAudioClipUI.ViewSelection(this);
            }
            this.viewSelection.setXStart(this.dragStartEvent.getX());
            this.viewSelection.setXEnd(arg0.getX());
            this.repaint();
        } else if (this.selStartMoveEvent != null) {
            this.dragStartEvent = this.selStartMoveEvent;
            this.viewSelection.setXStart(arg0.getX());
            this.setCursor();
            this.repaint();
        } else if (this.selEndMoveEvent != null) {
            this.dragStartEvent = this.selEndMoveEvent;
            this.viewSelection.setXEnd(arg0.getX());
            this.setCursor();
            this.repaint();
        }
        if (this.changeSelectionOnDrag) {
            this.selectionByMouse(arg0);
        }
    }

    private void checkMouseResizeSelection(MouseEvent arg0) {
        int x = arg0.getX();
        if (this.viewSelection != null) {
            if (this.isInSelectorLeft(x)) {
                this.mouseOverResizeEast = null;
                this.mouseOverResizeWest = arg0;
            } else if (this.isInSelectorRight(x)) {
                this.mouseOverResizeEast = arg0;
                this.mouseOverResizeWest = null;
            } else {
                this.mouseOverResizeEast = null;
                this.mouseOverResizeWest = null;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
        this.checkMouseResizeSelection(arg0);
        this.setCursor();
    }

    @Override
    public JComponent[] getYScales() {
        return new JComponent[]{this.yScalesComponent};
    }

    @Override
    public synchronized void addActionListener(ActionListener acl) {
        if (acl != null && !this.listenerList.contains(acl)) {
            this.listenerList.addElement(acl);
        }
    }

    @Override
    public synchronized void removeActionListener(ActionListener acl) {
        if (acl != null) {
            this.listenerList.removeElement(acl);
        }
    }

    protected synchronized void updateListeners(ActionEvent ae) {
        for (ActionListener listener : this.listenerList) {
            listener.actionPerformed(ae);
        }
    }

    @Override
    public void update(AudioSignalRendererEvent event) {
        Throwable renderException = event.getRenderException();
        if (renderException != null) {
            JOptionPane.showMessageDialog(this, "Audio renderer error: \n" + renderException.getLocalizedMessage(), "Audio signal renderer error", 0);
        } else if (AudioSignalRendererEvent.Type.DONE.equals((Object)event.getType())) {
            this.repaint();
        } else {
            int startPixle = event.getStartPixel();
            int len = event.getLen();
            if (len > 0) {
                this.repaint(startPixle, 0, len, this.getHeight());
            }
        }
    }

    @Override
    public void close() {
        if (this.renderer != null) {
            this.renderer.close();
        }
    }

    public JComponent getControlJComponent() {
        return this.controlPanel;
    }

    public boolean isUseThread() {
        return this.useThread;
    }

    public void setUseThread(boolean useThread) {
        this.useThread = useThread;
    }

    public ActionTreeRoot getActionTree() {
        return this.actionTree;
    }

    public static void main(final String[] args) {
        Runnable show = new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame();
                AudioClip ac = new AudioClip();
                AudioSignalUI jfm = new AudioSignalUI();
                f.getContentPane().add(jfm);
                f.pack();
                f.setVisible(true);
                jfm.setAudioSample(ac);
                ac.setAudioSource(new FileAudioSource(new File(args[0])));
            }
        };
        SwingUtilities.invokeLater(show);
    }

    private class SetBaseLogLevelAction
    extends AbstractActionLeaf {
        public SetBaseLogLevelAction() {
            super(new LocalizableMessage("Logarithm amplitude scale base level..."));
        }

        public void actionPerformed(ActionEvent arg0) {
            AudioSignalUI.this.doSetBaseLogLevel();
        }
    }

    private class SetAmplitudeScaleTypeLogarithmAction
    extends RadioActionLeaf {
        public SetAmplitudeScaleTypeLogarithmAction() {
            super(new LocalizableMessage("Logarithm amplitude scale"));
        }

        public void actionPerformed(ActionEvent arg0) {
            AudioSignalUI.this.setAmplitudeScaleType(AmplitudeScaleType.LOGARITHM);
        }
    }

    private class SetAmplitudeScaleTypeLinearAction
    extends RadioActionLeaf {
        public SetAmplitudeScaleTypeLinearAction() {
            super(new LocalizableMessage("Linear amplitude scale"));
        }

        public void actionPerformed(ActionEvent arg0) {
            AudioSignalUI.this.setAmplitudeScaleType(AmplitudeScaleType.LINEAR);
        }
    }

    public static enum AmplitudeScaleType {
        LINEAR,
        LOGARITHM;

    }
}

