/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.audioeditor.ui;

import ips.media.MediaView;
import ips.media.action.MediaViewActions;
import ipsk.apps.audioeditor.ui.AudioOptionsPanel;
import ipsk.apps.audioeditor.ui.InfoViewer;
import ipsk.apps.audioeditor.ui.StatusBar;
import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioOptions;
import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.ConvenienceFileAudioSource;
import ipsk.audio.PluginChain;
import ipsk.audio.ThreadSafeAudioSystem;
import ipsk.audio.URLAudioSource;
import ipsk.audio.actions.LoopAction;
import ipsk.audio.actions.PauseAction;
import ipsk.audio.actions.SetFramePositionAction;
import ipsk.audio.actions.StartPlaybackAction;
import ipsk.audio.actions.StartRecordAction;
import ipsk.audio.actions.StopAction;
import ipsk.audio.ajs.AJSAudioSystem;
import ipsk.audio.ajs.AJSDevice;
import ipsk.audio.ajs.AJSDeviceInfo;
import ipsk.audio.ajs.DeviceSelection;
import ipsk.audio.ajs.DeviceSelectionListener;
import ipsk.audio.ajs.ui.DevicesUI;
import ipsk.audio.arr.Selection;
import ipsk.audio.arr.clip.AudioClip;
import ipsk.audio.arr.clip.AudioClipListener;
import ipsk.audio.arr.clip.events.AudioClipChangedEvent;
import ipsk.audio.arr.clip.events.AudioSourceChangedEvent;
import ipsk.audio.arr.clip.events.FramePositionChangedEvent;
import ipsk.audio.arr.clip.events.SelectionChangedEvent;
import ipsk.audio.arr.clip.ui.AudioClipScrollPane;
import ipsk.audio.arr.clip.ui.AudioClipUIContainer;
import ipsk.audio.arr.clip.ui.AudioSignalUI;
import ipsk.audio.arr.clip.ui.AudioTimeScaleUI;
import ipsk.audio.arr.clip.ui.FourierUI;
import ipsk.audio.arr.clip.ui.FragmentActionBarUI;
import ipsk.audio.capture.Capture2;
import ipsk.audio.capture.CaptureException;
import ipsk.audio.capture.CaptureListener;
import ipsk.audio.capture.PrimaryRecordTarget;
import ipsk.audio.capture.event.CaptureCloseEvent;
import ipsk.audio.capture.event.CaptureErrorEvent;
import ipsk.audio.capture.event.CaptureEvent;
import ipsk.audio.capture.event.CaptureRecordedEvent;
import ipsk.audio.capture.event.CaptureStartCaptureEvent;
import ipsk.audio.capture.event.CaptureStartEvent;
import ipsk.audio.capture.event.CaptureStartRecordEvent;
import ipsk.audio.capture.event.CaptureStopEvent;
import ipsk.audio.dsp.AudioOutputStreamFloatConverter;
import ipsk.audio.dsp.LevelInfo;
import ipsk.audio.dsp.LevelInfosBean;
import ipsk.audio.dsp.LevelMeasureFloatAudioOutputStream;
import ipsk.audio.events.FramePositionActionEvent;
import ipsk.audio.events.StartPlaybackActionEvent;
import ipsk.audio.io.AudioFileWriter;
import ipsk.audio.io.AudioFileWriterListener;
import ipsk.audio.io.event.AudioFileWriterCancelledEvent;
import ipsk.audio.io.event.AudioFileWriterErrorEvent;
import ipsk.audio.io.event.AudioFileWriterEvent;
import ipsk.audio.io.event.AudioFileWriterWrittenEvent;
import ipsk.audio.mixer.ui.PortMixersUI;
import ipsk.audio.player.Player;
import ipsk.audio.player.PlayerException;
import ipsk.audio.player.PlayerListener;
import ipsk.audio.player.event.PlayerCloseEvent;
import ipsk.audio.player.event.PlayerErrorEvent;
import ipsk.audio.player.event.PlayerEvent;
import ipsk.audio.player.event.PlayerOpenEvent;
import ipsk.audio.player.event.PlayerPauseEvent;
import ipsk.audio.player.event.PlayerStartEvent;
import ipsk.audio.player.event.PlayerStopEvent;
import ipsk.audio.plugins.AppendPlugin;
import ipsk.audio.plugins.ChannelSelectorPlugin;
import ipsk.audio.plugins.CutPlugin;
import ipsk.audio.plugins.EditPlugin;
import ipsk.audio.plugins.EncodingPlugin;
import ipsk.audio.plugins.InsertPlugin;
import ipsk.audio.tools.FrameUnitParser;
import ipsk.audio.ui.AudioFileFilter;
import ipsk.audio.ui.AudioFileFormatChooser;
import ipsk.audio.ui.LevelMeter;
import ipsk.audio.ui.TransportUI;
import ipsk.awt.Worker;
import ipsk.awt.WorkerException;
import ipsk.awt.datatransfer.EmptyTransferable;
import ipsk.awt.print.ComponentPrinter;
import ipsk.swing.AbstractLocalizableAction;
import ipsk.swing.JPopupMenuListener;
import ipsk.swing.JProgressDialogPanel;
import ipsk.swing.TitledPanel;
import ipsk.swing.action.tree.ActionFolder;
import ipsk.swing.action.tree.ActionGroup;
import ipsk.swing.action.tree.ActionList;
import ipsk.swing.action.tree.ActionNode;
import ipsk.swing.action.tree.ActionTreeRoot;
import ipsk.swing.action.tree.JMenuBuilder;
import ipsk.swing.image.JComponentImageFileWriteAction;
import ipsk.text.StringTokenizer;
import ipsk.util.LocalizableMessage;
import ipsk.util.optionparser.Option;
import ipsk.util.optionparser.OptionParser;
import ipsk.util.optionparser.OptionParserException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;

public class AudioEditorUI
extends JFrame
implements ActionListener,
AdjustmentListener,
ClipboardOwner,
ComponentListener,
PlayerListener,
CaptureListener,
AudioFileWriterListener,
AudioClipListener,
FlavorListener,
WindowStateListener,
WindowListener,
DropTargetListener,
DeviceSelectionListener {
    private static final long serialVersionUID = 6684491340301105239L;
    static final boolean DEBUG = false;
    public static final String APPNAME = "Audio Editor";
    public static final String VERSION = AudioEditorUI.class.getPackage().getImplementationVersion();
    public static final String COPYRIGHT = "\u00a9 K.J\u00e4nsch, 2004-2019";
    public static final int REFRESH_DELAY = 200;
    public static final String PREF_WINDOW_RESTORE = "window.restore_on_startup";
    public static final String PREF_WINDOW_STATE = "window.preferredState";
    public static final String PREF_WINDOW_POS_X = "window.preferredPosition.x";
    public static final String PREF_WINDOW_POS_Y = "window.preferredPosition.y";
    public static final String PREF_WINDOW_WIDTH = "window.preferredSize.width";
    public static final String PREF_WINDOW_HEIGHT = "window.preferredSize.height";
    public static final String[] ICON_FILENAMES = new String[]{"audioeditor_64x64.png"};
    private List<Image> iconImages = new ArrayList<Image>();
    private static final int REOPEN_ON_SAVE = 0;
    private static final int CLOSE_ON_SAVE = 1;
    private static final int EXIT_ON_SAVE = 2;
    private static final Float PREFERRED_LINE_BUFFER_SIZE_MILLIS = Float.valueOf(4000.0f);
    public final boolean DEF_HOLD_LINE_OPEN = true;
    private static final boolean DEFAULT_FAST_LEVEL_MEASURING = false;
    private boolean viewUpdate;
    private AudioClip audioSample;
    private AudioClipUIContainer asc;
    private Clipboard clipBoard;
    private JMenuItem miAudioFormat;
    private String title;
    private PortMixersUI mixerUI;
    private DevicesUI devicesUI;
    private JPanel aboutPanel = null;
    private JMenuItem miMDevices;
    private JMenuBar mainMenuBar = new JMenuBar();
    private JMenu fileMenu = new JMenu("File");
    protected JMenuItem miNew;
    protected JMenuItem miOpen;
    protected JMenuItem miPrint;
    protected JMenuItem miClose;
    protected JMenuItem miSave;
    protected JMenuItem miSaveAs;
    protected JMenuItem miQuit;
    private CutAction cutAction = new CutAction();
    private CopyAction copyAction = new CopyAction();
    private PasteAction pasteAction = new PasteAction();
    private AppendAction appendAction = new AppendAction();
    private UndoAction undoAction = new UndoAction();
    private SelectAllAction selectAllAction = new SelectAllAction();
    private CancelSelectionAction cancelSelectionAction = new CancelSelectionAction();
    private JMenu editMenu;
    private JMenu naviMenu = new JMenu("Navigate");
    private JMenuItem miGoto = new JMenuItem("Go to");
    private JMenu generateMenu = new JMenu("Generate");
    private JMenuItem sineWaveGeneratorMi;
    private JMenu settingsMenu = new JMenu("Control");
    private JMenuItem miMixer;
    private JMenu miChannelSelector;
    private JMenuItem miAudioOptions;
    private JRadioButtonMenuItem[] miChannelSelects;
    private JRadioButtonMenuItem miChannelsAll;
    private JMenu optionsMenu = new JMenu("Options");
    private JCheckBoxMenuItem miRestoreWindow;
    private JMenu helpMenu = new JMenu("Help");
    private JMenuItem miAbout;
    private JMenuItem miInfo;
    private ResourceBundle rb;
    private File recFile;
    private AudioFileFormat audioFormat;
    private TransportUI tp;
    private LevelMeter lm;
    private JPanel levelPanel;
    private StatusBar statusBar;
    private StartPlaybackAction startPlaybackAction;
    private StopAction stopAction;
    private PauseAction pauseAction;
    private SetFramePositionAction setFramePositionAction;
    private StartRecordAction startRecordAction;
    private LoopAction loopAction;
    private Player playback;
    private Capture2 capture;
    private AudioOutputStreamFloatConverter captureOutputStream;
    private LevelMeasureFloatAudioOutputStream captureLevelMeasureStream;
    private AudioSource audioSource;
    private PluginChain editSource;
    private PluginChain playbackSource;
    private int editableOffset;
    private Timer viewUpdateTimer = null;
    private JPanel content;
    private static AudioEditorUI demo;
    private File lastOpenDirectory;
    private File lastSaveDirectory;
    private DeviceSelection captureDeviceSelection;
    private DeviceSelection playbackDeviceSelection;
    private boolean overwrite;
    private boolean viewUpdateRunning;
    private int selectedChannel = -1;
    private InfoViewer infoPanel;
    private int actionOnSaved = 0;
    private boolean saved = true;
    private AudioFileWriter afw;
    private int windowPreferredState = 0;
    private boolean restoringWindowState = false;
    private Dimension windowPreferredSize = null;
    private Preferences preferences = null;
    private AudioClipScrollPane arrScrollPane = null;
    private JDialog mixerDialog;
    private JProgressDialogPanel progressDialog = null;
    private boolean fastLevelMeasuring = false;
    private AudioOptions audioOptions;
    private String defaultPrimaryRecordTargetName;
    private volatile boolean closing = false;
    private boolean keepPlayerOpen = true;

    public AudioEditorUI() {
        this.addWindowListener(this);
        this.addWindowStateListener(this);
        this.addComponentListener(this);
        this.title = new String(APPNAME);
        this.setTitle(this.title);
        this.iconImages = new ArrayList<Image>();
        for (String ifn : ICON_FILENAMES) {
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource(ifn));
            Image iconImage = imageIcon.getImage();
            this.iconImages.add(iconImage);
        }
        this.setIconImages(this.iconImages);
        String packageName = this.getClass().getPackage().getName();
        this.rb = ResourceBundle.getBundle(packageName + ".ResBundle");
        try {
            System.setProperty("java.util.prefs.syncInterval", "100000000");
        }
        catch (SecurityException se) {
            System.err.println("Could not increase lockinterval");
        }
        this.preferences = Preferences.userNodeForPackage(this.getClass());
        this.restoringWindowState = this.preferences.getBoolean(PREF_WINDOW_RESTORE, false);
        if (this.restoringWindowState) {
            this.windowPreferredState = this.preferences.getInt(PREF_WINDOW_STATE, 0);
            String windowPreferredWidthStr = this.preferences.get(PREF_WINDOW_WIDTH, null);
            String windowPreferredHeightStr = this.preferences.get(PREF_WINDOW_HEIGHT, null);
            if (windowPreferredWidthStr != null && windowPreferredHeightStr != null) {
                int width = Integer.parseInt(windowPreferredWidthStr);
                int height = Integer.parseInt(windowPreferredHeightStr);
                this.windowPreferredSize = new Dimension(width, height);
            }
            int locX = this.preferences.getInt(PREF_WINDOW_POS_X, 0);
            int locY = this.preferences.getInt(PREF_WINDOW_POS_Y, 0);
            this.setLocation(locX, locY);
        } else {
            this.setLocationByPlatform(true);
        }
        this.audioOptions = new AudioOptions();
        PrimaryRecordTarget primaryRecordTargetApplDefault = PrimaryRecordTarget.TEMP_RAW_FILE;
        this.defaultPrimaryRecordTargetName = "Default: " + primaryRecordTargetApplDefault;
        String primRecTgtUsrPref = this.preferences.get("primaryRecordTarget", null);
        if (primRecTgtUsrPref != null) {
            try {
                PrimaryRecordTarget primaryRecordTarget = PrimaryRecordTarget.valueOf(primRecTgtUsrPref);
                this.audioOptions.setPrimaryRecordTarget(primaryRecordTarget);
            }
            catch (IllegalArgumentException iae) {
                iae.printStackTrace();
                JOptionPane.showMessageDialog(this, "Could not set primary recording target setting " + primRecTgtUsrPref + ".", "Primary recording target setting error", 0);
            }
        }
        if (this.capture != null) {
            this.audioOptions.setLineBufferSize(this.capture.getLineBufferSize());
        }
        this.content = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.content.setOpaque(true);
        this.miNew = new JMenuItem("New");
        this.fileMenu.add(this.miNew);
        this.miNew.setEnabled(false);
        this.miNew.addActionListener(this);
        this.miOpen = new JMenuItem("Open");
        this.fileMenu.add(this.miOpen);
        this.miOpen.setEnabled(false);
        this.miOpen.addActionListener(this);
        this.miPrint = new JMenuItem("Print...");
        this.fileMenu.add(this.miPrint);
        this.miPrint.addActionListener(this);
        this.miSave = new JMenuItem("Save");
        this.fileMenu.add(this.miSave);
        this.miSave.setEnabled(false);
        this.miSave.addActionListener(this);
        this.miSaveAs = new JMenuItem("Save As");
        this.fileMenu.add(this.miSaveAs);
        this.miSaveAs.setEnabled(false);
        this.miSaveAs.addActionListener(this);
        this.miClose = new JMenuItem("Close");
        this.miClose.setEnabled(false);
        this.fileMenu.add(this.miClose);
        this.miClose.addActionListener(this);
        this.miQuit = new JMenuItem("Exit");
        this.fileMenu.add(this.miQuit);
        this.miQuit.addActionListener(this);
        this.appendAction.setEnabled(false);
        this.selectAllAction.setEnabled(false);
        this.cancelSelectionAction.setEnabled(false);
        this.undoAction.setEnabled(false);
        this.undoAction.setEnabled(false);
        this.naviMenu.add(this.miGoto);
        this.miGoto.setEnabled(false);
        this.miGoto.addActionListener(this);
        this.sineWaveGeneratorMi = new JMenuItem("Sine wave");
        this.sineWaveGeneratorMi.addActionListener(this);
        this.generateMenu.add(this.sineWaveGeneratorMi);
        this.miMixer = new JMenuItem("Mixer");
        this.miMixer.addActionListener(this);
        this.settingsMenu.add(this.miMixer);
        this.miAudioFormat = new JMenuItem("Audio format");
        this.miAudioFormat.addActionListener(this);
        this.settingsMenu.add(this.miAudioFormat);
        this.miMDevices = new JMenuItem("Devices");
        this.miMDevices.addActionListener(this);
        this.settingsMenu.add(this.miMDevices);
        this.miAudioOptions = new JMenuItem("Audio options");
        this.miAudioOptions.addActionListener(this);
        this.settingsMenu.add(this.miAudioOptions);
        this.miChannelSelector = new JMenu("Channels");
        this.settingsMenu.add(this.miChannelSelector);
        this.miChannelsAll = new JRadioButtonMenuItem("All channels");
        this.miChannelsAll.addActionListener(this);
        this.miRestoreWindow = new JCheckBoxMenuItem("Restore window size and state");
        this.miRestoreWindow.setSelected(this.restoringWindowState);
        this.miRestoreWindow.addActionListener(this);
        this.optionsMenu.add(this.miRestoreWindow);
        this.miAbout = new JMenuItem("About");
        this.miAbout.addActionListener(this);
        this.helpMenu.add(this.miAbout);
        this.miInfo = new JMenuItem("Info");
        this.miInfo.addActionListener(this);
        this.helpMenu.add(this.miInfo);
        this.overwrite = false;
        AJSAudioSystem.setApplicationName(APPNAME);
        this.captureDeviceSelection = new DeviceSelection(AJSAudioSystem.DeviceType.CAPTURE);
        AJSDevice defCaptureDev = AJSAudioSystem.getDefaultCaptureDevice();
        this.captureDeviceSelection.setDevice(defCaptureDev);
        this.playbackDeviceSelection = new DeviceSelection(AJSAudioSystem.DeviceType.PLAYBACK);
        AJSDevice defPlayDev = AJSAudioSystem.getDefaultPlaybackDevice();
        this.playbackDeviceSelection.setDevice(defPlayDev);
        try {
            this.devicesUI = new DevicesUI(this.captureDeviceSelection, this.playbackDeviceSelection);
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Audio devices error", 0);
        }
        this.audioFormat = new AudioFileFormat(AudioFileFormat.Type.WAVE, new AudioFormat(44100.0f, 16, 2, true, false), ThreadSafeAudioSystem.NOT_SPECIFIED);
        this.startPlaybackAction = new StartPlaybackAction();
        this.startPlaybackAction.setEnabled(false);
        this.startPlaybackAction.addActionListener(this);
        this.stopAction = new StopAction();
        this.stopAction.addActionListener(this);
        this.pauseAction = new PauseAction();
        this.pauseAction.addActionListener(this);
        this.setFramePositionAction = new SetFramePositionAction();
        this.setFramePositionAction.addActionListener(this);
        this.startRecordAction = new StartRecordAction();
        this.startRecordAction.addActionListener(this);
        this.loopAction = new LoopAction();
        this.loopAction.addActionListener(this);
        this.tp = new TransportUI(this.startPlaybackAction, this.stopAction, this.pauseAction, this.setFramePositionAction, this.startRecordAction, this.loopAction);
        this.playback = new Player(this.playbackDeviceSelection.getMixer());
        this.playback.addPlayerListener(this);
        this.capture = new Capture2(this.captureDeviceSelection.getMixer());
        this.capture.addCaptureListener(this);
        this.captureOutputStream = new AudioOutputStreamFloatConverter();
        this.capture.addAudioOutputStream(this.captureOutputStream);
        this.captureLevelMeasureStream = new LevelMeasureFloatAudioOutputStream();
        this.captureOutputStream.addFloatAudioOutputStream(this.captureLevelMeasureStream);
        this.playback.setPreferredLineBufferSizeMillis(PREFERRED_LINE_BUFFER_SIZE_MILLIS);
        this.captureDeviceSelection.addDeviceSelectionListener(this);
        this.playbackDeviceSelection.addDeviceSelectionListener(this);
        this.capture.setPrimaryRecordTarget(PrimaryRecordTarget.TEMP_RAW_FILE);
        this.capture.setPreferredLineBufferSizeMillis(PREFERRED_LINE_BUFFER_SIZE_MILLIS);
        this.capture.setAudioFileFormat(this.audioFormat);
        this.viewUpdateTimer = new Timer(200, this);
        this.viewUpdateTimer.setRepeats(true);
        this.viewUpdate = false;
        this.lastOpenDirectory = new File(System.getProperty("user.home"));
        this.lastSaveDirectory = new File(System.getProperty("user.home"));
        AudioSignalUI signalView = new AudioSignalUI();
        signalView.setUseThread(false);
        FourierUI sonagram = new FourierUI();
        sonagram.setUseThread(true);
        FragmentActionBarUI playActionBar = new FragmentActionBarUI();
        playActionBar.setStartPlaybackAction(this.startPlaybackAction);
        AudioTimeScaleUI timeScale = new AudioTimeScaleUI();
        this.asc = new AudioClipUIContainer();
        this.asc.add(signalView);
        this.asc.add(sonagram);
        this.asc.add((Component)((Object)timeScale));
        this.asc.add(playActionBar);
        this.asc.addActionListener(this);
        this.arrScrollPane = new AudioClipScrollPane();
        this.arrScrollPane.setShowYScales(true);
        this.arrScrollPane.setAudioClipUiContainer(this.asc);
        JComponentImageFileWriteAction pa = new JComponentImageFileWriteAction((Component)this.asc, new LocalizableMessage("Save to image file ..."));
        ActionTreeRoot ascActionTree = this.arrScrollPane.getActionTreeRoot();
        ActionTreeRoot afft = new ActionTreeRoot();
        ActionFolder aff = ActionFolder.buildTopLevelFolder((String)"file");
        afft.add((ActionNode)aff);
        aff.add((ActionNode)pa);
        ActionFolder aef = ActionFolder.buildTopLevelFolder((String)"edit");
        ActionGroup aeurg = new ActionGroup("undo_redo");
        aeurg.add((ActionNode)this.undoAction);
        aef.add((ActionNode)aeurg);
        afft.add((ActionNode)aef);
        ActionFolder avf = ActionFolder.buildTopLevelFolder((String)"view");
        afft.add((ActionNode)avf);
        aef.add((ActionNode)this.cutAction);
        aef.add((ActionNode)this.copyAction);
        aef.add((ActionNode)this.pasteAction);
        aef.add((ActionNode)this.appendAction);
        aef.add((ActionNode)this.selectAllAction);
        aef.add((ActionNode)this.cancelSelectionAction);
        afft.merge((ActionList)ascActionTree);
        MediaViewActions mediaViewActions = new MediaViewActions((MediaView)this.asc);
        ActionGroup lengthUnitGroup = new ActionGroup("view.length_unit");
        ActionFolder uaf = new ActionFolder("view.units", new LocalizableMessage("Units"));
        lengthUnitGroup.add((ActionNode)uaf);
        ActionFolder tff = new ActionFolder("view.units.time", new LocalizableMessage("Time"));
        uaf.add((ActionNode)tff);
        MediaViewActions.MediaLengthUnitFramesAction mediaLenFramesAction = mediaViewActions.getMediaLenFramesAction();
        MediaViewActions.MediaLengthUnitTimeAction mediaLenTimeAction = mediaViewActions.getMediaLenTimeAction();
        MediaViewActions.TimeFormatSecondsMsAction timeFormatSecondsMsAction = mediaViewActions.getTimeFormatSecondsMsAction();
        MediaViewActions.MediaTimeFormatAction mediaTimeAction = mediaViewActions.getMediaTimeAction();
        tff.add((ActionNode)timeFormatSecondsMsAction);
        tff.add((ActionNode)mediaTimeAction);
        timeFormatSecondsMsAction.setSelected(true);
        uaf.add((ActionNode)mediaLenFramesAction);
        uaf.add((ActionNode)mediaLenTimeAction);
        avf.add((ActionNode)lengthUnitGroup);
        try {
            System.getProperty("user.home");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        JMenuBuilder menuBuilder = new JMenuBuilder((ActionFolder)afft);
        JPopupMenu pm = menuBuilder.buildJPopupMenu();
        JPopupMenuListener pml = new JPopupMenuListener(pm);
        this.arrScrollPane.addMouseListener((MouseListener)pml);
        this.asc.addPopupMouseListener((MouseListener)pml);
        this.editMenu = menuBuilder.buildMenu("edit");
        JMenu viewMenu = menuBuilder.buildMenu("view");
        this.mainMenuBar.add(this.fileMenu);
        this.mainMenuBar.add(this.editMenu);
        this.mainMenuBar.add(viewMenu);
        this.mainMenuBar.add(this.naviMenu);
        this.mainMenuBar.add(this.settingsMenu);
        this.mainMenuBar.add(this.optionsMenu);
        this.mainMenuBar.add(Box.createHorizontalGlue());
        this.mainMenuBar.add(this.helpMenu);
        if (this.restoringWindowState && this.windowPreferredSize != null) {
            this.setPreferredSize(this.windowPreferredSize);
        }
        this.addComponentListener(this);
        this.levelPanel = new TitledPanel(this.rb.getString("level"));
        this.lm = new LevelMeter();
        this.lm.setUseIntervalPeakLevel(true);
        this.lm.addActionListener(this);
        this.levelPanel.setLayout(new BorderLayout());
        this.levelPanel.add((Component)this.lm, "Center");
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 1.0;
        c.fill = 1;
        this.content.add((Component)this.levelPanel, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 1;
        this.content.add((Component)this.arrScrollPane, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 2;
        c.fill = 2;
        this.content.add((Component)this.tp, c);
        this.statusBar = new StatusBar();
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        this.content.add((Component)this.statusBar, c);
        this.setJMenuBar(this.mainMenuBar);
        this.setDefaultCloseOperation(0);
        this.setContentPane(this.content);
        this.getRootPane().setMinimumSize(this.content.getMinimumSize());
        Toolkit toolkit = this.getToolkit();
        this.clipBoard = toolkit.getSystemClipboard();
        this.clipBoard.addFlavorListener(this);
        DropTarget dt = new DropTarget(this, this);
        this.audioSample = new AudioClip();
        this.asc.setAudioClip(this.audioSample);
        this.audioSample.addAudioSampleListener(this);
    }

    public void init() throws PlayerException {
        AJSDevice pDevInfo;
        AJSDevice cDevInfo = AJSAudioSystem.getDefaultResolvedCaptureDevice();
        if (cDevInfo != null) {
            this.capture.setMixer(cDevInfo.getMixer());
        }
        if ((pDevInfo = AJSAudioSystem.getDefaultResolvedPlaybackDevice()) != null) {
            this.playback.setMixer(pDevInfo.getMixer());
        }
    }

    public boolean isRestoringWindowState() {
        return this.restoringWindowState;
    }

    private void startViewUpdates() {
        if (this.viewUpdateRunning) {
            return;
        }
        this.viewUpdateRunning = true;
        this.viewUpdateTimer.start();
    }

    private void stopViewUpdates() {
        this.viewUpdateTimer.stop();
        this.viewUpdateRunning = false;
        this.updateView();
    }

    private void updatePlaybackView() {
        this.viewUpdate = true;
        LevelInfo[] lis = this.playback.getLevelInfos();
        this.lm.setLevelInfos(lis);
        if (lis != null) {
            for (LevelInfo li : lis) {
                li.resetIntervalPeakLevel();
            }
        }
        long pos = this.playback.getFramePosition();
        this.audioSample.setFramePosition(pos);
        this.tp.setFramePosition(pos);
        this.viewUpdate = false;
    }

    private void updateCaptureView() {
        this.viewUpdate = true;
        if (!this.fastLevelMeasuring) {
            LevelInfosBean lib = this.captureLevelMeasureStream.getLevelInfosBean();
            this.lm.setLevelInfos(lib.getLevelInfos());
            lib.resetIntervalPeakLevel();
        }
        this.tp.setFramePosition(this.capture.getFramePosition());
        this.viewUpdate = false;
    }

    private void updateView() {
        if (this.capture.isRecording() || this.capture.isCapturing()) {
            this.updateCaptureView();
        } else {
            this.updatePlaybackView();
        }
    }

    private void doCopy() {
        Selection selection = this.audioSample.getSelection();
        PluginChain copyData = (PluginChain)this.editSource.clone();
        try {
            copyData.add(new EditPlugin(selection));
        }
        catch (AudioFormatNotSupportedException e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Copy error", 0);
            e.printStackTrace();
            return;
        }
        this.clipBoard.setContents(copyData, this);
        this.updatePaste();
    }

    private void doCut() {
        Selection selection = this.audioSample.getSelection();
        PluginChain cutData = (PluginChain)this.editSource.clone();
        try {
            cutData.add(new EditPlugin(selection));
            this.editSource.add(new CutPlugin(selection));
        }
        catch (AudioFormatNotSupportedException e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Cut error", 0);
            e.printStackTrace();
            return;
        }
        this.clipBoard.setContents(cutData, this);
        this.updatePaste();
        this.audioSample.setSelection(null);
        this.miSave.setEnabled(true);
        this.saved = false;
        this.audioSource = this.editSource;
        this.openEditSource();
        this.preparePlaybackSources();
    }

    private void doPaste() {
        Transferable pasteTrans = this.clipBoard.getContents(this);
        long pastePosition = this.audioSample.getFramePosition();
        PluginChain pasteData = null;
        try {
            pasteData = (PluginChain)pasteTrans.getTransferData(new DataFlavor(PluginChain.class, ""));
            this.editSource.add(new InsertPlugin(pasteData, pastePosition));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Paste error", 0);
            e.printStackTrace();
            return;
        }
        this.miSave.setEnabled(true);
        this.saved = false;
        this.audioSource = this.editSource;
        this.openEditSource();
        this.preparePlaybackSources();
    }

    private void doAppend() {
        Transferable pasteTrans = this.clipBoard.getContents(this);
        PluginChain pasteData = null;
        try {
            pasteData = (PluginChain)pasteTrans.getTransferData(new DataFlavor(PluginChain.class, ""));
            AppendPlugin appPlugin = new AppendPlugin(pasteData);
            this.editSource.add(appPlugin);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Append error", 0);
            e.printStackTrace();
        }
        this.miSave.setEnabled(true);
        this.saved = false;
        this.audioSource = this.editSource;
        this.openEditSource();
        this.preparePlaybackSources();
    }

    private void doUndo() {
        this.editSource.removeLast();
        this.miSave.setEnabled(true);
        this.saved = false;
        this.openEditSource();
        this.preparePlaybackSources();
    }

    private void doCancelSelection() {
        this.audioSample.setSelection(null);
    }

    private void doSelectAll() {
        try {
            this.audioSample.setSelection(new Selection(0L, this.audioSample.getAudioSource().getFrameLength()));
        }
        catch (AudioSourceException e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Audio source error", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent ev) {
        Object src = ev.getSource();
        if (src == this.viewUpdateTimer) {
            this.updateView();
        } else if (src == this.miNew) {
            this.doNew();
        } else if (src == this.miOpen) {
            this.doOpen();
        } else if (src == this.miPrint) {
            this.doPrint();
        } else if (src == this.miSaveAs) {
            int returnVal;
            File file = null;
            JFileChooser fch = new JFileChooser(this.lastSaveDirectory);
            AudioFileFormat.Type aff = null;
            AudioFileFormat.Type[] fileTypes = ThreadSafeAudioSystem.getAudioFileTypes();
            AudioFileFormat.Type currentFileFormat = this.audioFormat.getType();
            AudioFileFilter selAfFilter = null;
            for (AudioFileFormat.Type ft : fileTypes) {
                AudioFileFilter afFilter = new AudioFileFilter(ft);
                fch.addChoosableFileFilter(afFilter);
                if (!ft.equals(currentFileFormat)) continue;
                selAfFilter = afFilter;
            }
            if (selAfFilter != null) {
                fch.setFileFilter(selAfFilter);
            }
            if ((returnVal = fch.showSaveDialog(this)) != 0) {
                return;
            }
            file = fch.getSelectedFile();
            FileFilter ff = fch.getFileFilter();
            aff = ((AudioFileFilter)fch.getFileFilter()).getAudioFileTypes()[0];
            this.lastSaveDirectory = fch.getCurrentDirectory();
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.actionOnSaved = 0;
            if (this.checkOverWrite(file)) {
                this.save(aff, file);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else if (src == this.miSave) {
            AudioFileFormat.Type aff = AudioFileFormat.Type.WAVE;
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.actionOnSaved = 0;
            if (this.overwrite || this.checkOverWrite(this.recFile)) {
                this.save(aff, this.recFile);
                this.miSave.setEnabled(false);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else if (src == this.miClose) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.doClose();
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else if (src == this.miGoto) {
            long newFramePos;
            String newFramePosString = JOptionPane.showInputDialog(this, (Object)"Input frame position to go");
            try {
                newFramePos = Long.parseLong(newFramePosString);
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this, "\"" + newFramePosString + "\" is not a integer number", "Number format error", 0);
                return;
            }
            this.audioSample.setFramePosition(newFramePos);
        } else if (src == this.miMixer) {
            if (this.mixerUI == null) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    this.mixerUI = new PortMixersUI();
                }
                catch (LineUnavailableException e) {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Mixer device error", 0);
                    e.printStackTrace();
                }
                JOptionPane optPane = new JOptionPane(this.mixerUI);
                this.mixerDialog = optPane.createDialog(this, this.rb.getString("mixer"));
                this.mixerDialog.setModal(false);
                this.mixerDialog.setResizable(true);
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            this.mixerDialog.setVisible(true);
        } else if (src == this.miMDevices) {
            int result;
            if (this.devicesUI == null) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    this.devicesUI = new DevicesUI(this.captureDeviceSelection, this.playbackDeviceSelection);
                }
                catch (LineUnavailableException e) {
                    JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Audio devices error", 0);
                    return;
                }
                finally {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            if ((result = JOptionPane.showOptionDialog(this, this.devicesUI, "Mixer", 2, -1, null, null, null)) == 0) {
                AJSDeviceInfo cdi = this.devicesUI.getSelectedCaptureDeviceInfo();
                AJSDevice cDev = null;
                if (cdi != null) {
                    cDev = AJSAudioSystem.getResolvedCaptureDevice(cdi);
                }
                this.captureDeviceSelection.setDevice(cDev);
                AJSDeviceInfo pdi = this.devicesUI.getSelectedPlaybackDeviceInfo();
                AJSDevice pDev = null;
                if (pdi != null) {
                    pDev = AJSAudioSystem.getResolvedPlaybackDevice(pdi);
                }
                this.playbackDeviceSelection.setDevice(pDev);
            }
        } else if (src == this.miAudioFormat) {
            this.audioFormat = AudioFileFormatChooser.showDialog((Component)this, this.audioFormat);
            this.capture.setAudioFileFormat(this.audioFormat);
        } else if (src == this.miAudioOptions) {
            this.audioOptions.setLineBufferSize(this.capture.getLineBufferSize());
            AudioOptionsPanel audioOptionsPanel = new AudioOptionsPanel(this.audioOptions, this.defaultPrimaryRecordTargetName);
            audioOptionsPanel.showDialog(this);
            PrimaryRecordTarget primaryRecordTarget = this.audioOptions.getPrimaryRecordTarget();
            if (primaryRecordTarget != null) {
                this.preferences.put("primaryRecordTarget", primaryRecordTarget.name());
            } else {
                this.preferences.remove("primaryRecordTarget");
            }
        } else if (src == this.miRestoreWindow) {
            this.preferences.putBoolean(PREF_WINDOW_RESTORE, this.miRestoreWindow.isSelected());
        } else if (src == this.miAbout) {
            if (this.aboutPanel == null) {
                this.aboutPanel = new JPanel(new GridLayout(2, 1));
                this.aboutPanel.add(new JLabel("Audio Editor version " + VERSION + " \u00a9 K.J\u00e4nsch, 2004-2019"));
            }
            JOptionPane.showMessageDialog(this, this.aboutPanel, this.rb.getString("about"), 1);
        } else if (src == this.miInfo) {
            this.infoPanel = new InfoViewer();
            this.infoPanel.setRecordingFile(this.recFile);
            JOptionPane.showMessageDialog(this, this.infoPanel, "Info", 1);
        } else if (src == this.miQuit) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.doQuit();
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else if (ev.getActionCommand() == StartPlaybackAction.ACTION_COMMAND) {
            if (this.tp.isPaused()) {
                try {
                    this.playback.open();
                    this.playback.pause();
                }
                catch (PlayerException e1) {
                    JOptionPane.showMessageDialog(this, e1.getLocalizedMessage(), "Playback pause error", 0);
                }
            } else {
                if (ev instanceof StartPlaybackActionEvent) {
                    StartPlaybackActionEvent pe = (StartPlaybackActionEvent)ev;
                    this.playback.setStartFramePosition(pe.getStartFramePosition());
                    this.playback.setStopFramePosition(pe.getStopFramePosition());
                }
                try {
                    this.playback.open();
                    this.playback.play();
                }
                catch (PlayerException e) {
                    JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Playback open error", 0);
                }
            }
        } else if (ev.getActionCommand() == StopAction.ACTION_COMMAND) {
            this.playback.stop();
            try {
                this.capture.stop();
            }
            catch (CaptureException e) {
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Record stream error", 0);
            }
            if (this.tp.isPaused()) {
                this.tp.setPaused(false);
                this.pauseAction.setHighlighted(false);
            }
            this.stopAction.setEnabled(false);
            this.stopAction.setHighlighted(true);
        } else if (ev.getActionCommand() == PauseAction.ACTION_COMMAND) {
            boolean paused = this.playback.isPaused();
            boolean tpPaused = this.tp.isPaused();
            if (this.playback.isPlaying() && !paused) {
                this.playback.pause();
            } else if (paused && tpPaused) {
                this.playback.start();
            } else if (this.capture.isCapturing() && tpPaused) {
                this.capture.setCaptureOnly(false);
                this.capture.start();
            } else {
                this.tp.setPaused(!tpPaused);
                this.pauseAction.setHighlighted(!tpPaused);
                this.stopAction.setEnabled(!tpPaused);
                this.stopAction.setHighlighted(tpPaused);
            }
        } else if (ev.getActionCommand() == SetFramePositionAction.ACTION_COMMAND) {
            try {
                this.playback.setFramePosition(((FramePositionActionEvent)ev).getFramePosition());
            }
            catch (PlayerException e) {
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Playback positioning error", 0);
            }
        } else if (ev.getActionCommand() == StartRecordAction.ACTION_COMMAND) {
            boolean tpPaused = this.tp.isPaused();
            if (tpPaused && !this.capture.isCapturing()) {
                this.startCaptureInterActive();
            } else {
                this.startRecordingInterActive();
            }
        } else if (ev.getActionCommand() == LoopAction.ACTION_COMMAND) {
            if (src instanceof ItemSelectable) {
                Object[] sel = ((ItemSelectable)src).getSelectedObjects();
                this.playback.setLooping(sel != null && sel.length > 0);
            }
        } else if (ev.getActionCommand() == "Reset peak hold") {
            this.playback.resetPeakHold();
        } else if (src == this.miChannelsAll) {
            this.selectedChannel = -1;
            this.preparePlaybackSources();
        } else if (this.isChannelSelectMenuItem(src)) {
            for (int i = 0; i < this.miChannelSelects.length; ++i) {
                if (src != this.miChannelSelects[i]) continue;
                this.doChannelSelect(i);
            }
        }
    }

    private void doChannelSelect(int i) {
        try {
            this.playback.close();
        }
        catch (PlayerException e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Playback close error", 0);
            e.printStackTrace();
        }
        this.selectedChannel = i;
        this.preparePlaybackSources();
    }

    private boolean isChannelSelectMenuItem(Object src) {
        for (int i = 0; i < this.miChannelSelects.length; ++i) {
            if (src != this.miChannelSelects[i]) continue;
            return true;
        }
        return false;
    }

    private void doOpen() {
        File file = null;
        JFileChooser fch = new JFileChooser(this.lastOpenDirectory);
        AudioFileFilter audioFileFilter = new AudioFileFilter();
        fch.setFileFilter(audioFileFilter);
        int returnVal = fch.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        file = fch.getSelectedFile();
        this.lastOpenDirectory = fch.getCurrentDirectory();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.openFile(file);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Open error", 0);
            e.printStackTrace();
        }
        this.lm.setScaleEnabled(true);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void doPrint() {
        boolean viewUpdating = this.viewUpdateRunning;
        this.stopViewUpdates();
        PrinterJob printJob = PrinterJob.getPrinterJob();
        ComponentPrinter cp = new ComponentPrinter((Component)this);
        printJob.setPrintable((Printable)cp);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (PrinterException e) {
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Print error", 0);
                e.printStackTrace();
            }
        }
        if (viewUpdating) {
            this.startViewUpdates();
        }
    }

    private void doSave() {
        AudioFileFormat.Type aff = this.audioFormat.getType();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.overwrite || this.checkOverWrite(this.recFile)) {
            this.save(aff, this.recFile);
        }
        this.miSave.setEnabled(false);
    }

    private void openFile(File file) throws UnsupportedAudioFileException, IOException, AudioSourceException {
        this.overwrite = false;
        this.miSave.setEnabled(false);
        this.recFile = file;
        this.capture.setRecordingFile(file);
        this.updateActions();
        this.audioSource = new ConvenienceFileAudioSource(file);
        Transferable clipBoardContents = this.clipBoard.getContents(this);
        if (clipBoardContents != null && clipBoardContents.isDataFlavorSupported(AudioSource.DATA_FLAVOR)) {
            this.pasteAction.setEnabled(true);
            this.appendAction.setEnabled(true);
        }
        this.editSource = new PluginChain(this.audioSource);
        try {
            this.editSource.add(new EncodingPlugin(AudioFormat.Encoding.PCM_SIGNED));
        }
        catch (AudioFormatNotSupportedException e1) {
            JOptionPane.showMessageDialog(this, e1.getLocalizedMessage(), "Format unsupported error", 0);
        }
        this.editableOffset = this.editSource.size();
        this.openEditSource();
        this.preparePlaybackSources();
        this.setTitle(file.getName() + " - " + this.title);
    }

    private void openURL(URL url) throws UnsupportedAudioFileException, IOException, AudioSourceException, URISyntaxException {
        if (url.getProtocol().equals("file")) {
            File urlFile = new File(url.toURI().getPath());
            this.openFile(urlFile);
        }
        this.audioSource = new URLAudioSource(url);
        this.preparePlaybackSources();
        this.setTitle(url + " - " + this.title);
    }

    private void preparePlaybackSources() {
        try {
            this.playback.close();
        }
        catch (PlayerException e) {
            JOptionPane.showMessageDialog(this, "Could not close playback engine.", "Playback engine close warning", 2);
        }
        int srcChannels = -1;
        try {
            srcChannels = this.editSource.getFormat().getChannels();
        }
        catch (AudioSourceException e1) {
            this.playbackSource = null;
            JOptionPane.showMessageDialog(this, "Could not select playback channel.", "Playback error", 0);
            return;
        }
        if (this.selectedChannel != -1) {
            this.playbackSource = new PluginChain(this.editSource);
            try {
                this.playbackSource.add(new ChannelSelectorPlugin(this.selectedChannel));
            }
            catch (AudioFormatNotSupportedException e) {
                this.playbackSource = null;
                JOptionPane.showMessageDialog(this, "Could not select playback channel.", "Playback error", 0);
                return;
            }
        } else {
            this.playbackSource = this.editSource;
            this.miChannelsAll.setSelected(true);
        }
        try {
            this.playback.setAudioSource(this.playbackSource);
            this.playback.open();
        }
        catch (PlayerException pe) {
            if (srcChannels > 2) {
                JOptionPane.showMessageDialog(this, "The playback engine cannot play " + srcChannels + " channels simultanously.\nThe first channel will be selected for playback.", "Playback engine", 1);
                this.selectedChannel = 0;
                this.miChannelSelects[this.selectedChannel].setSelected(true);
                this.playbackSource = new PluginChain(this.editSource);
                try {
                    this.playbackSource.add(new ChannelSelectorPlugin(this.selectedChannel));
                    this.playback.close();
                    this.playback.setAudioSource(this.playbackSource);
                    this.playback.open();
                }
                catch (AudioFormatNotSupportedException e) {
                    this.playbackSource = null;
                    JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Playback open error", 0);
                    return;
                }
                catch (PlayerException e) {
                    this.playbackSource = null;
                    JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Playback open error", 0);
                    return;
                }
            }
            this.playbackSource = null;
            JOptionPane.showMessageDialog(this, pe.getLocalizedMessage(), "Playback open error", 0);
            return;
        }
        try {
            AudioFormat af = this.playback.getAudioFormat();
            long frameLength = this.editSource.getFrameLength();
            this.lm.setAudioFormat(af);
            this.tp.setFrameLength(this.playback.getFrameLength());
            this.tp.setFrameRate(af.getFrameRate());
            this.statusBar.setAudioFormat(af);
            this.statusBar.setFrameLength(frameLength);
        }
        catch (AudioSourceException e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Audio source error", 0);
        }
        this.updateActions();
        this.stopAction.setHighlighted(true);
        this.pauseAction.setEnabled(true);
        this.startViewUpdates();
    }

    private void openEditSource() {
        this.audioSample.setAudioSource(this.editSource);
        int srcChannels = -1;
        try {
            srcChannels = this.editSource.getFormat().getChannels();
        }
        catch (AudioSourceException e) {
            e.printStackTrace();
        }
        this.miChannelSelector.removeAll();
        ButtonGroup bg = new ButtonGroup();
        this.miChannelSelects = new JRadioButtonMenuItem[srcChannels];
        for (int i = 0; i < srcChannels; ++i) {
            JRadioButtonMenuItem chItem = new JRadioButtonMenuItem("Channel " + i);
            bg.add(chItem);
            chItem.addActionListener(this);
            this.miChannelSelects[i] = chItem;
            this.miChannelSelector.add(chItem);
            if (i != this.selectedChannel) continue;
            chItem.setSelected(true);
        }
        this.miChannelSelector.add(this.miChannelsAll);
        bg.add(this.miChannelsAll);
        this.undoAction.setEnabled(this.editSource.size() > this.editableOffset);
        this.miAudioFormat.setEnabled(false);
        this.miSaveAs.setEnabled(true);
        this.miClose.setEnabled(true);
        this.miOpen.setEnabled(false);
        this.miPrint.setEnabled(true);
        this.miNew.setEnabled(false);
        this.miGoto.setEnabled(true);
    }

    public void close() {
        this.closing = true;
        try {
            this.capture.close();
        }
        catch (CaptureException e) {
            JOptionPane.showMessageDialog(this, "Could not close capture engine.", "Capture engine close warning", 2);
        }
        try {
            this.playback.close();
        }
        catch (PlayerException e) {
            JOptionPane.showMessageDialog(this, "Could not close playback engine.", "Playback engine close warning", 2);
        }
        this.playbackSource = null;
        this.asc.close();
        this.selectedChannel = -1;
        this.overwrite = false;
        this.stopViewUpdates();
        this.lm.resetPeakHold();
        this.stopAction.setEnabled(false);
        this.pauseAction.setEnabled(false);
        this.setFramePositionAction.setEnabled(false);
        this.recFile = null;
        this.saved = true;
        this.updateActions();
        this.audioSample.setAudioSource(null);
        this.lm.abandonDecay();
        this.lm.setLevels(null);
        this.lm.setScaleEnabled(false);
        this.statusBar.setAudioFormat(null);
        this.statusBar.setFrameLength(ThreadSafeAudioSystem.NOT_SPECIFIED);
        this.miClose.setEnabled(false);
        this.cutAction.setEnabled(false);
        this.copyAction.setEnabled(false);
        this.pasteAction.setEnabled(false);
        this.appendAction.setEnabled(false);
        this.miSave.setEnabled(false);
        this.miSaveAs.setEnabled(false);
        this.miOpen.setEnabled(true);
        this.miNew.setEnabled(true);
        this.miAudioFormat.setEnabled(true);
        this.miGoto.setEnabled(false);
        this.setTitle(this.title);
        this.closing = false;
    }

    private void save(AudioFileFormat.Type aff, File file) {
        File[] usedAudioFiles;
        this.miSave.setEnabled(false);
        this.miSaveAs.setEnabled(false);
        this.miClose.setEnabled(false);
        AudioInputStream ais = null;
        try {
            ais = this.editSource.getAudioInputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.clipBoard.isDataFlavorAvailable(PluginChain.DATA_FLAVOR)) {
            Transferable clipBoardContents = this.clipBoard.getContents(this);
            try {
                File[] filesInUseByClipboard;
                PluginChain clipBoardPluginChain = (PluginChain)clipBoardContents.getTransferData(PluginChain.DATA_FLAVOR);
                File[] fileArray = filesInUseByClipboard = clipBoardPluginChain.getUsedAudioFiles();
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    File fileInUseByClipboard = fileArray[i];
                    if (!file.equals(fileInUseByClipboard)) continue;
                    clipBoardPluginChain.setValid(false);
                    this.clipBoard.setContents((Transferable)new EmptyTransferable(), this);
                    this.updatePaste();
                }
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        boolean fileInUse = false;
        for (File uf : usedAudioFiles = this.editSource.getUsedAudioFiles()) {
            if (!file.equals(uf)) continue;
            fileInUse = true;
        }
        if (fileInUse) {
            // empty if block
        }
        this.afw = new AudioFileWriter((AudioFileWriterListener)this, ais, aff, file, true);
        this.progressDialog = new JProgressDialogPanel((Worker)this.afw, "Write audio file", "Writing...");
        try {
            this.afw.open();
        }
        catch (WorkerException e) {
            e.printStackTrace();
        }
        this.afw.start();
        Object val = this.progressDialog.showDialog((JFrame)this);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent arg0) {
    }

    public void selected(Selection selection) {
    }

    public static void main(String[] args) {
        StartupRunnable startupRunnable = new StartupRunnable();
        String audioURL = null;
        OptionParser op = new OptionParser();
        op.addOption("open", null);
        op.addOption("s0", null);
        op.addOption("s1", null);
        op.addOption("xzoom", null);
        try {
            op.parse(args);
        }
        catch (OptionParserException e) {
            System.err.println(e.getLocalizedMessage());
            JOptionPane.showMessageDialog(null, e.getLocalizedMessage(), "ERROR", 0);
            System.exit(-1);
        }
        Option[] options = op.getOptions();
        for (int i = 0; i < options.length; ++i) {
            if (options[i].getOptionName().equals("open")) {
                audioURL = options[i].getParam();
                continue;
            }
            if (options[i].getOptionName().equals("s0")) {
                startupRunnable.setS0(options[i].getParam());
                continue;
            }
            if (options[i].getOptionName().equals("s1")) {
                startupRunnable.setS1(options[i].getParam());
                continue;
            }
            if (!options[i].getOptionName().equals("xzoom")) continue;
            startupRunnable.setXZoom(options[i].getParam());
        }
        String[] params = op.getParams();
        if (params.length <= 1) {
            if (params.length == 1) {
                audioURL = params[0];
            }
            startupRunnable.setAudioURL(audioURL);
            SwingUtilities.invokeLater(startupRunnable);
        } else {
            System.err.println("Usage: java " + demo.getClass().getName() + " [audioFile]");
            System.exit(-1);
        }
    }

    private int showSaveDialog() {
        return JOptionPane.showConfirmDialog(this, this.recFile.getName() + " is not saved. Do you want to save ?", "Save file ?", 1);
    }

    private void doClose() {
        if (!this.saved) {
            int save = this.showSaveDialog();
            if (save == 0) {
                this.actionOnSaved = 1;
                this.doSave();
            } else {
                if (save == 2) {
                    return;
                }
                this.close();
            }
        } else {
            this.close();
        }
    }

    private void doQuit() {
        if (!this.saved) {
            int save = this.showSaveDialog();
            if (save == 0) {
                this.actionOnSaved = 2;
                this.doSave();
            } else {
                if (save == 2) {
                    return;
                }
                this.exit();
            }
        } else {
            this.exit();
        }
    }

    public void exit() {
        this.close();
        System.exit(0);
    }

    @Override
    public void lostOwnership(Clipboard arg0, Transferable arg1) {
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
        WindowEvent we;
        Object src = arg0.getSource();
        int x = arg0.getComponent().getX();
        int y = arg0.getComponent().getY();
        int state = this.getExtendedState();
        if (arg0 instanceof WindowEvent && (we = (WindowEvent)arg0).getNewState() != state) {
            System.out.println("State differs !!");
        }
        if (src == this && state == 0) {
            this.preferences.putInt(PREF_WINDOW_POS_X, x);
            this.preferences.putInt(PREF_WINDOW_POS_Y, y);
            if (x == -4 && y == -4) {
                System.out.println("Pref. xy set: " + x + " " + y + " state: " + state);
            }
        }
    }

    @Override
    public void componentResized(ComponentEvent ce) {
        Object src = ce.getSource();
        if (src == this && this.getExtendedState() == 0) {
            Dimension d = ce.getComponent().getSize();
            double width = d.getWidth();
            double height = d.getHeight();
            Dimension minD = this.content.getMinimumSize();
            double minWidth = minD.getWidth();
            double minHeight = minD.getHeight();
            if (minWidth > width || minHeight > height) {
                double newWidth = width;
                if (minWidth > width) {
                    newWidth = minWidth;
                }
                double newHeight = height;
                if (minHeight > height) {
                    newHeight = minHeight;
                }
                this.setSize((int)newWidth, (int)newHeight);
            }
            int awidth = this.getWidth();
            int aheight = this.getHeight();
            this.preferences.putInt(PREF_WINDOW_WIDTH, awidth);
            this.preferences.putInt(PREF_WINDOW_HEIGHT, aheight);
        }
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    private boolean checkOverWrite(File file) {
        if (!file.exists()) {
            return true;
        }
        return JOptionPane.showConfirmDialog(this, file.getName() + " exists. Do you want to overwrite ?", "Overwrite file ?", 0) == 0;
    }

    public void startCaptureInterActive() {
        File recFile = this.capture.getRecordingFile();
        if (this.overwrite || this.checkOverWrite(recFile)) {
            this.audioSample.setAudioSource(null);
            this.statusBar.setFrameLength(ThreadSafeAudioSystem.NOT_SPECIFIED);
            this.capture.setAudioFileFormat(this.audioFormat);
            this.capture.setPrimaryRecordTarget(this.audioOptions.getNNPrimaryRecordTarget());
            try {
                this.capture.open();
                this.lm.setAudioFormat(this.audioFormat.getFormat());
            }
            catch (CaptureException e) {
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Audio capture open error", 0);
            }
            this.capture.setCaptureOnly(true);
            this.capture.start();
            this.startRecordAction.setHighlighted(true);
        }
    }

    public void startRecordingInterActive() {
        File recFile = this.capture.getRecordingFile();
        if (!this.overwrite && recFile.exists() && JOptionPane.showConfirmDialog(this, recFile.getName() + " exists. Do you want to overwrite ?", "Overwrite file ?", 0) != 0) {
            return;
        }
        try {
            this.playback.close();
        }
        catch (PlayerException e1) {
            e1.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, "Could not close player before recording: " + e1.getLocalizedMessage());
        }
        this.audioSample.setAudioSource(null);
        this.statusBar.setFrameLength(ThreadSafeAudioSystem.NOT_SPECIFIED);
        this.capture.setAudioFileFormat(this.audioFormat);
        this.capture.setPrimaryRecordTarget(this.audioOptions.getNNPrimaryRecordTarget());
        try {
            this.capture.open();
        }
        catch (CaptureException e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Capture open error", 0);
            return;
        }
        this.capture.setCaptureOnly(false);
        this.lm.setAudioFormat(this.audioFormat.getFormat());
        if (this.fastLevelMeasuring) {
            this.lm.setLevelInfosBean(this.captureLevelMeasureStream.getLevelInfosBean());
        }
        this.capture.start();
        this.startRecordAction.setHighlighted(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNew() {
        File file = null;
        JFileChooser fch = new JFileChooser(this.lastSaveDirectory);
        fch.setFileFilter(new AudioFileFilter());
        int returnVal = fch.showSaveDialog(this);
        if (returnVal != 0) {
            return;
        }
        file = fch.getSelectedFile();
        this.lastSaveDirectory = fch.getCurrentDirectory();
        if (file.exists() && JOptionPane.showConfirmDialog(this, file.getName() + " exists. Do you want to overwrite ?", "Overwrite file ?", 0) != 0) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        ByteArrayInputStream zeroBis = new ByteArrayInputStream(new byte[0]);
        AudioInputStream zeroAis = new AudioInputStream(zeroBis, this.audioFormat.getFormat(), 0L);
        try {
            ThreadSafeAudioSystem.write(zeroAis, this.audioFormat.getType(), file);
            this.overwrite = true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "New error", 0);
            e.printStackTrace();
        }
        finally {
            try {
                zeroBis.close();
                zeroAis.close();
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(this, e1.getLocalizedMessage(), "New error", 0);
            }
            this.setTitle(file.getName() + " - Audio Editor");
            try {
                this.openFile(file);
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(this, e1.getLocalizedMessage(), "New open error", 0);
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void playbackFinished() {
        if (!this.closing) {
            this.playback.setStartFramePosition(0L);
            this.playback.setStopFramePosition(ThreadSafeAudioSystem.NOT_SPECIFIED);
            this.setFramePositionAction.setEnabled(false);
            this.pauseAction.setHighlighted(false);
            this.stopAction.setEnabled(false);
            this.stopAction.setHighlighted(true);
            this.updateActions();
            this.pauseAction.setEnabled(true);
        }
        this.tp.setPaused(false);
        this.startPlaybackAction.setHighlighted(false);
        this.updatePlaybackView();
    }

    @Override
    public void update(PlayerEvent playerEvent) {
        if (playerEvent instanceof PlayerStartEvent) {
            this.tp.setPaused(false);
            this.startPlaybackAction.setEnabled(false);
            this.startPlaybackAction.setHighlighted(true);
            this.stopAction.setEnabled(true);
            this.stopAction.setHighlighted(false);
            this.pauseAction.setEnabled(true);
            this.pauseAction.setHighlighted(false);
            this.startRecordAction.setEnabled(false);
            this.setFramePositionAction.setEnabled(true);
        } else if (playerEvent instanceof PlayerStopEvent) {
            if (playerEvent instanceof PlayerPauseEvent) {
                this.tp.setPaused(true);
                this.pauseAction.setHighlighted(true);
                this.startPlaybackAction.setHighlighted(true);
                this.stopAction.setEnabled(true);
                this.stopAction.setHighlighted(false);
                this.startRecordAction.setEnabled(false);
                this.startPlaybackAction.setEnabled(true);
                this.pauseAction.setEnabled(true);
                this.updatePlaybackView();
            } else if (this.keepPlayerOpen) {
                this.playbackFinished();
            } else {
                try {
                    this.playback.close();
                }
                catch (PlayerException e) {
                    e.printStackTrace();
                }
            }
        } else if (playerEvent instanceof PlayerOpenEvent) {
            this.setFramePositionAction.setEnabled(true);
        } else if (playerEvent instanceof PlayerCloseEvent) {
            if (!this.keepPlayerOpen) {
                this.playbackFinished();
            }
        } else if (playerEvent instanceof PlayerErrorEvent) {
            System.err.println(playerEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deviceChanged(Object src, AJSDevice oldDevice, AJSDevice newDevice) {
        if (src == this.playbackDeviceSelection) {
            this.playback.stop();
            try {
                this.playback.close();
                Mixer newPlaybackMixer = null;
                if (newDevice != null) {
                    newPlaybackMixer = newDevice.getMixer();
                }
                this.playback.setMixer(newPlaybackMixer);
            }
            catch (PlayerException e) {
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Error setting playback device", 0);
            }
        } else if (src == this.captureDeviceSelection) {
            try {
                this.capture.stop();
                this.capture.close();
            }
            catch (CaptureException e) {
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Error stopping/closing capture engine", 0);
            }
            finally {
                Mixer newCaptureMixer = null;
                if (newDevice != null) {
                    newCaptureMixer = newDevice.getMixer();
                }
                this.capture.setMixer(newCaptureMixer);
            }
        }
        this.updateActions();
    }

    private void updateActions() {
        boolean captureEnabled = this.recFile != null && this.captureDeviceSelection.getDevice() != null;
        this.startRecordAction.setEnabled(captureEnabled);
        boolean pbEnabled = this.playbackSource != null && this.playbackDeviceSelection.getDevice() != null;
        this.startPlaybackAction.setEnabled(pbEnabled);
    }

    @Override
    public void update(CaptureEvent captureEvent) {
        if (captureEvent instanceof CaptureStartEvent) {
            this.startRecordAction.setHighlighted(true);
            this.stopAction.setHighlighted(false);
            this.stopAction.setEnabled(true);
            this.startPlaybackAction.setEnabled(false);
            this.setFramePositionAction.setEnabled(false);
            if (captureEvent instanceof CaptureStartRecordEvent) {
                this.tp.setPaused(false);
                this.pauseAction.setEnabled(false);
                this.pauseAction.setHighlighted(false);
                this.startRecordAction.setEnabled(false);
            } else if (captureEvent instanceof CaptureStartCaptureEvent) {
                this.tp.setPaused(true);
                this.pauseAction.setEnabled(true);
                this.pauseAction.setHighlighted(true);
                this.startRecordAction.setEnabled(true);
            }
        } else if (captureEvent instanceof CaptureStopEvent) {
            try {
                this.capture.close();
                this.tp.setFramePosition(this.capture.getFramePosition());
            }
            catch (CaptureException e) {
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Error on record close", 0);
            }
            if (captureEvent instanceof CaptureRecordedEvent) {
                this.overwrite = false;
            }
        } else if (captureEvent instanceof CaptureCloseEvent) {
            this.tp.setPaused(false);
            boolean recFileLoaded = this.recFile != null;
            this.startRecordAction.setHighlighted(false);
            this.stopAction.setHighlighted(false);
            this.stopAction.setEnabled(false);
            this.pauseAction.setEnabled(recFileLoaded);
            this.updateActions();
            this.pauseAction.setHighlighted(false);
            this.setFramePositionAction.setEnabled(false);
            try {
                this.openFile(this.capture.getRecordingFile());
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Error opening recorded file", 0);
            }
        } else if (captureEvent instanceof CaptureErrorEvent) {
            String errMsg = ((CaptureErrorEvent)captureEvent).getCause().getLocalizedMessage();
            if (errMsg == null) {
                errMsg = "Unknown cause";
            }
            System.err.println("Capture error: " + errMsg);
            JOptionPane.showMessageDialog(this, errMsg, "Capture (recording) error", 0);
            try {
                this.capture.close();
            }
            catch (CaptureException e) {
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Capture close error", 0);
            }
        }
    }

    private void processAudioFileWriterevent(AudioFileWriterEvent event) {
        if (event instanceof AudioFileWriterWrittenEvent) {
            AudioFileWriterWrittenEvent we = (AudioFileWriterWrittenEvent)event;
            this.saved = true;
            if (this.actionOnSaved == 0) {
                try {
                    this.openFile(we.getOutFile());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "Cannot open saved file:\n" + e.getLocalizedMessage(), "Open error", 0);
                }
            } else if (this.actionOnSaved == 1) {
                this.close();
            } else if (this.actionOnSaved == 2) {
                this.exit();
            }
        } else if (event instanceof AudioFileWriterErrorEvent) {
            Exception e = ((AudioFileWriterErrorEvent)event).getCause();
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Saving error", 0);
            this.miSave.setEnabled(!this.saved);
            this.miSaveAs.setEnabled(true);
        } else if (event instanceof AudioFileWriterCancelledEvent) {
            JOptionPane.showMessageDialog(this, "Saving cancelled", "Saving", 1);
            this.miSave.setEnabled(!this.saved);
            this.miSaveAs.setEnabled(true);
            this.miClose.setEnabled(true);
        }
    }

    @Override
    public void update(AudioFileWriterEvent event) {
        if (EventQueue.isDispatchThread()) {
            this.processAudioFileWriterevent(event);
        } else {
            try {
                EventQueue.invokeAndWait(new AudioFilewriterEventProcessor(event));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void audioClipChanged(AudioClipChangedEvent event) {
        if (event instanceof FramePositionChangedEvent) {
            if (!this.viewUpdate) {
                long newFramePosition = ((FramePositionChangedEvent)event).getPosition();
                try {
                    this.playback.setFramePosition(newFramePosition);
                    this.tp.setFramePosition(newFramePosition);
                }
                catch (PlayerException e) {
                    e.printStackTrace();
                }
            }
        } else if (event instanceof SelectionChangedEvent) {
            SelectionChangedEvent selEvent = (SelectionChangedEvent)event;
            Selection selection = selEvent.getSelection();
            if (selection == null) {
                this.cutAction.setEnabled(false);
                this.copyAction.setEnabled(false);
                this.cancelSelectionAction.setEnabled(false);
                this.playback.setStartFramePosition(0L);
                this.playback.setStopFramePosition(-1L);
            } else {
                this.cutAction.setEnabled(true);
                this.copyAction.setEnabled(true);
                this.cancelSelectionAction.setEnabled(true);
                this.playback.setStartFramePosition(selection.getLeft());
                this.playback.setStopFramePosition(selection.getRight());
            }
        } else if (event instanceof AudioSourceChangedEvent) {
            AudioSourceChangedEvent ev = (AudioSourceChangedEvent)event;
            this.cutAction.setEnabled(false);
            this.copyAction.setEnabled(false);
            this.cancelSelectionAction.setEnabled(false);
            if (ev.getAudioSource() == null) {
                this.selectAllAction.setEnabled(false);
            } else {
                this.selectAllAction.setEnabled(true);
            }
        }
    }

    public AudioClip getAudioSample() {
        return this.audioSample;
    }

    public void setAudioSample(AudioClip audioSample) {
        this.audioSample = audioSample;
    }

    public AudioClipUIContainer getAsc() {
        return this.asc;
    }

    public void setAsc(AudioClipUIContainer asc) {
        this.asc = asc;
    }

    private void updatePaste() {
        boolean dataAvail = this.clipBoard.isDataFlavorAvailable(PluginChain.DATA_FLAVOR);
        this.pasteAction.setEnabled(dataAvail);
        this.appendAction.setEnabled(dataAvail);
    }

    @Override
    public void flavorsChanged(FlavorEvent arg0) {
        this.updatePaste();
    }

    private String windowStateToString(int state) {
        if (state == 0) {
            return "normal";
        }
        StringBuffer stateStr = new StringBuffer();
        if ((state & 1) > 0) {
            stateStr.append("iconified ");
        }
        if ((state & 6) > 0) {
            stateStr.append("maximized ");
        }
        return stateStr.toString();
    }

    @Override
    public void windowStateChanged(WindowEvent arg0) {
        this.preferences.putInt(PREF_WINDOW_STATE, arg0.getNewState());
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        this.doQuit();
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File checkForSingleAudiofile(List<File> fileList) {
        if (fileList.size() == 1) {
            File f = fileList.get(0);
            AudioInputStream ais = null;
            try {
                ais = AudioSystem.getAudioInputStream(f);
            }
            catch (UnsupportedAudioFileException e) {
                File file = null;
                return file;
            }
            catch (IOException e) {
                File file = null;
                return file;
            }
            finally {
                if (ais != null) {
                    try {
                        ais.close();
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
            }
            return f;
        }
        return null;
    }

    private boolean checkForSingleAudiofileFlavour(Transferable tr) {
        DataFlavor[] dfs;
        for (DataFlavor df : dfs = tr.getTransferDataFlavors()) {
            String mimeType;
            String[] mimeElements;
            if (df.isFlavorJavaFileListType()) {
                return true;
            }
            if (!df.isFlavorTextType() || (mimeElements = StringTokenizer.split((String)(mimeType = df.getMimeType()), (char)';', (boolean)true)).length <= 0 || !"text/uri-list".equals(mimeElements[0])) continue;
            try {
                Reader r = df.getReaderForText(tr);
                LineNumberReader lnr = new LineNumberReader(r);
                ArrayList<String> lines = new ArrayList<String>();
                String line = null;
                while ((line = lnr.readLine()) != null) {
                    lines.add(line);
                }
                if (lines.size() != 1) continue;
                return true;
            }
            catch (UnsupportedFlavorException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File checkForSingleAudiofile(Transferable tr) {
        DataFlavor[] dfs;
        for (DataFlavor df : dfs = tr.getTransferDataFlavors()) {
            String mimeType;
            String[] mimeElements;
            if (df.isFlavorJavaFileListType()) {
                File f;
                List fileList;
                block27: {
                    fileList = null;
                    try {
                        Object trDataObj = tr.getTransferData(df);
                        if (!(trDataObj instanceof List)) break block27;
                        fileList = (List)trDataObj;
                    }
                    catch (UnsupportedFlavorException e) {
                        continue;
                    }
                    catch (IOException e) {
                        continue;
                    }
                }
                if (fileList == null || (f = this.checkForSingleAudiofile(fileList)) == null) continue;
                return f;
            }
            if (!df.isFlavorTextType() || (mimeElements = StringTokenizer.split((String)(mimeType = df.getMimeType()), (char)';', (boolean)true)).length <= 0 || !"text/uri-list".equals(mimeElements[0])) continue;
            try {
                Reader r = df.getReaderForText(tr);
                LineNumberReader lnr = new LineNumberReader(r);
                ArrayList<String> lines = new ArrayList<String>();
                String line = null;
                while ((line = lnr.readLine()) != null) {
                    lines.add(line);
                }
                if (lines.size() != 1) continue;
                try {
                    URI uri = new URI((String)lines.get(0));
                    String scheme = uri.getScheme();
                    if (!"file".equalsIgnoreCase(scheme)) continue;
                    String path = uri.getPath();
                    File f = new File(path);
                    AudioInputStream ais = null;
                    try {
                        ais = AudioSystem.getAudioInputStream(f);
                    }
                    catch (UnsupportedAudioFileException e) {
                        if (ais == null) continue;
                        try {
                            ais.close();
                        }
                        catch (IOException e2) {}
                        continue;
                    }
                    catch (IOException e) {
                        if (ais == null) continue;
                        try {
                            ais.close();
                        }
                        catch (IOException e3) {}
                        continue;
                    }
                    finally {
                        if (ais != null) {
                            try {
                                ais.close();
                            }
                            catch (IOException e) {
                                continue;
                            }
                        }
                    }
                    return f;
                }
                catch (URISyntaxException e) {}
            }
            catch (UnsupportedFlavorException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    private void processDropTargetDragEvent(DropTargetDragEvent dtde) {
        boolean accept = this.checkForSingleAudiofileFlavour(dtde.getTransferable());
        if (accept) {
            dtde.acceptDrag(dtde.getDropAction());
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.processDropTargetDragEvent(dtde);
    }

    @Override
    public void dragExit(DropTargetEvent arg0) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        this.processDropTargetDragEvent(dtde);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Transferable tr = dtde.getTransferable();
        boolean success = false;
        dtde.acceptDrop(dtde.getDropAction());
        File af = this.checkForSingleAudiofile(tr);
        if (af != null) {
            this.close();
            try {
                this.openFile(af);
                success = true;
            }
            catch (UnsupportedAudioFileException e) {
                success = false;
            }
            catch (IOException e) {
                success = false;
            }
            catch (AudioSourceException e) {
                success = false;
            }
            dtde.dropComplete(success);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent arg0) {
    }

    public static class StartupRunnable
    implements Runnable {
        private String audioURL = null;
        private String s0 = null;
        private String s1 = null;
        private String xZoom = null;

        public void setAudioURL(String audioURL) {
            this.audioURL = audioURL;
        }

        public void setS0(String s0) {
            this.s0 = s0;
        }

        public void setS1(String s1) {
            this.s1 = s1;
        }

        public void setXZoom(String xZoom) {
            this.xZoom = xZoom;
        }

        @Override
        public void run() {
            demo = new AudioEditorUI();
            Preferences preferences = Preferences.userNodeForPackage(demo.getClass());
            int prefWindowState = preferences.getInt(AudioEditorUI.PREF_WINDOW_STATE, 0);
            demo.pack();
            Dimension minSize = demo.getMinimumSize();
            Dimension mbMinSize = demo.getJMenuBar().getMinimumSize();
            Dimension mbPrefSize = demo.getJMenuBar().getPreferredSize();
            demo.setMinimumSize(new Dimension(minSize.width, minSize.height + (mbPrefSize.height - mbMinSize.height)));
            demo.setVisible(true);
            if (demo.isRestoringWindowState()) {
                WindowStateRunnable wsr = new WindowStateRunnable(demo, prefWindowState);
                SwingUtilities.invokeLater(wsr);
            }
            try {
                demo.init();
            }
            catch (PlayerException e2) {
                e2.printStackTrace();
                JOptionPane.showMessageDialog(demo, e2.getMessage(), "Playback default device error", 0);
                System.err.println(e2.getMessage());
            }
            if (this.audioURL == null) {
                demo.close();
            } else {
                try {
                    URL url = new URL(this.audioURL);
                    try {
                        demo.openURL(url);
                    }
                    catch (Exception e) {
                        System.err.println(e.getLocalizedMessage());
                        System.exit(-1);
                    }
                }
                catch (MalformedURLException e1) {
                    try {
                        demo.openFile(new File(this.audioURL));
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(demo, e.getMessage(), "File open error", 0);
                        System.err.println(e.getMessage());
                        e.printStackTrace();
                        System.exit(-1);
                    }
                }
            }
            if (this.s0 != null && this.s1 != null) {
                AudioClip clip = demo.getAudioSample();
                FrameUnitParser fup = null;
                try {
                    fup = new FrameUnitParser(clip);
                }
                catch (AudioSourceException e) {
                    e.printStackTrace();
                }
                long s0l = fup.parseFrameUnitString(this.s0);
                long s1l = fup.parseFrameUnitString(this.s1);
                clip.setSelection(new Selection(s0l, s1l));
            }
            if (this.xZoom != null) {
                AudioClipUIContainer asc = demo.getAsc();
                asc.setFixXZoomFitToPanel(false);
                asc.setXZoom(Double.parseDouble(this.xZoom));
            }
        }
    }

    public static class WindowStateRunnable
    implements Runnable {
        private JFrame frame;
        private int windowState;

        public WindowStateRunnable(JFrame frame, int windowState) {
            this.frame = frame;
            this.windowState = windowState;
        }

        @Override
        public void run() {
            this.frame.setExtendedState(this.windowState);
        }
    }

    class EncodingConversionAllowedAction
    extends AbstractAction {
        private static final long serialVersionUID = 71761657739109628L;

        public EncodingConversionAllowedAction(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    public class CancelSelectionAction
    extends ipsk.swing.CancelSelectionAction {
        private static final long serialVersionUID = -8147414359554906777L;

        public void actionPerformed(ActionEvent arg0) {
            AudioEditorUI.this.doCancelSelection();
        }
    }

    public class SelectAllAction
    extends ipsk.swing.SelectAllAction {
        private static final long serialVersionUID = -4467050585331391998L;

        public void actionPerformed(ActionEvent arg0) {
            AudioEditorUI.this.doSelectAll();
        }
    }

    public class UndoAction
    extends ipsk.swing.UndoAction {
        private static final long serialVersionUID = -5162984122121810941L;

        public void actionPerformed(ActionEvent arg0) {
            AudioEditorUI.this.doUndo();
        }
    }

    public class AppendAction
    extends AbstractLocalizableAction {
        private static final long serialVersionUID = 4123861114935395069L;

        public AppendAction() {
            super("append", new LocalizableMessage("Append"));
        }

        public void actionPerformed(ActionEvent arg0) {
            AudioEditorUI.this.doAppend();
        }
    }

    public class PasteAction
    extends ipsk.swing.PasteAction {
        private static final long serialVersionUID = -6510760462243552390L;

        public void actionPerformed(ActionEvent arg0) {
            AudioEditorUI.this.doPaste();
        }
    }

    public class CopyAction
    extends ipsk.swing.CopyAction {
        private static final long serialVersionUID = -8578607687877669062L;

        public void actionPerformed(ActionEvent arg0) {
            AudioEditorUI.this.doCopy();
        }
    }

    public class CutAction
    extends ipsk.swing.CutAction {
        private static final long serialVersionUID = 7140861734683174053L;

        public void actionPerformed(ActionEvent arg0) {
            AudioEditorUI.this.doCut();
        }
    }

    private class AudioFilewriterEventProcessor
    implements Runnable {
        final AudioFileWriterEvent event;

        AudioFilewriterEventProcessor(AudioFileWriterEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            AudioEditorUI.this.processAudioFileWriterevent(this.event);
        }
    }

    public static enum WindowState {
        NORMAL(0),
        MAXIMIZED_BOTH(6),
        MAXIMIZED_HORIZ(2),
        MAXIMIZED_VERT(4),
        ICONIFIED(1);

        public final int awtState;

        private WindowState(int awtState) {
            this.awtState = awtState;
        }
    }
}

