/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class LimitLengthAudioInputStream
extends AudioInputStream {
    private AudioInputStream srcAudioInputStream;
    private long maxFrameLength;
    private int frameSize;
    private long bytesRead = 0L;
    private long maxBytesLength;

    public LimitLengthAudioInputStream(AudioInputStream srcAudioInputStream, long maxFrameLength) {
        super(srcAudioInputStream, srcAudioInputStream.getFormat(), srcAudioInputStream.getFrameLength());
        this.srcAudioInputStream = srcAudioInputStream;
        this.maxFrameLength = maxFrameLength;
        this.frameSize = srcAudioInputStream.getFormat().getFrameSize();
        this.maxBytesLength = maxFrameLength * (long)this.frameSize;
    }

    @Override
    public int available() throws IOException {
        return this.srcAudioInputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.srcAudioInputStream.close();
    }

    @Override
    public AudioFormat getFormat() {
        return this.srcAudioInputStream.getFormat();
    }

    @Override
    public long getFrameLength() {
        long srcFrameLength = this.srcAudioInputStream.getFrameLength();
        if (srcFrameLength > this.maxFrameLength) {
            return this.maxFrameLength;
        }
        return srcFrameLength;
    }

    @Override
    public void mark(int readlimit) {
        this.srcAudioInputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.srcAudioInputStream.markSupported();
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        int read = this.read(buf, 0, 1);
        if (read == -1) {
            return -1;
        }
        return 0xFF & read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bytesRead + (long)len > this.maxBytesLength) {
            len = (int)(this.maxBytesLength - this.bytesRead);
        }
        if (len <= 0) {
            return -1;
        }
        int r = this.srcAudioInputStream.read(b, off, len);
        this.bytesRead += (long)r;
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public void reset() throws IOException {
        this.srcAudioInputStream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.srcAudioInputStream.skip(n);
    }
}

