/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.ajs;

import ipsk.audio.ajs.AJSAudioSystem;
import ipsk.audio.ajs.AJSDevice;
import ipsk.audio.ajs.DeviceSelectionListener;
import java.util.Vector;
import javax.sound.sampled.Mixer;

public class DeviceSelection {
    private AJSAudioSystem.DeviceType deviceType;
    private AJSDevice device;
    private Vector<DeviceSelectionListener> listeners = new Vector();

    public DeviceSelection(AJSAudioSystem.DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public AJSDevice getDevice() {
        return this.device;
    }

    public void setDevice(AJSDevice device) {
        AJSDevice oldDevice = this.device;
        this.device = device;
        for (DeviceSelectionListener l : this.listeners) {
            l.deviceChanged(this, oldDevice, this.device);
        }
    }

    public AJSAudioSystem.DeviceType getDeviceType() {
        return this.deviceType;
    }

    public Mixer getMixer() {
        Mixer m = null;
        if (this.device != null) {
            m = this.device.getMixer();
        }
        return m;
    }

    public void addDeviceSelectionListener(DeviceSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeDeviceSelectionListener(DeviceSelectionListener listener) {
        this.listeners.remove(listener);
    }
}

