/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.applet;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.PluginChain;
import ipsk.audio.ThreadSafeAudioSystem;
import ipsk.audio.VectorBufferAudioSource;
import ipsk.audio.arr.Selection;
import ipsk.audio.arr.clip.AudioClip;
import ipsk.audio.arr.clip.AudioClipListener;
import ipsk.audio.arr.clip.events.AudioClipChangedEvent;
import ipsk.audio.arr.clip.events.SelectionChangedEvent;
import ipsk.audio.arr.clip.ui.AudioClipUIContainer;
import ipsk.audio.arr.clip.ui.AudioSignalUI;
import ipsk.audio.arr.clip.ui.AudioTimeScaleUI;
import ipsk.audio.arr.clip.ui.FourierUI;
import ipsk.audio.dsp.AudioClipDSPInfo;
import ipsk.audio.dsp.AudioClipProcessor;
import ipsk.audio.dsp.ui.AudioClipDSPInfoViewer;
import ipsk.audio.mixer.MixerManager;
import ipsk.audio.player.Player;
import ipsk.audio.player.PlayerException;
import ipsk.audio.player.PlayerListener;
import ipsk.audio.player.event.PlayerCloseEvent;
import ipsk.audio.player.event.PlayerEvent;
import ipsk.audio.player.event.PlayerStartEvent;
import ipsk.audio.player.event.PlayerStopEvent;
import ipsk.audio.plugins.ChannelSelectorPlugin;
import ipsk.awt.ProgressListener;
import ipsk.awt.Worker;
import ipsk.awt.WorkerException;
import ipsk.awt.event.ProgressErrorEvent;
import ipsk.awt.event.ProgressEvent;
import ipsk.io.VectorBuffer;
import ipsk.io.VectorBufferedOutputStream;
import ipsk.net.URLContentLoader;
import ipsk.swing.JProgressDialogPanel;
import ipsk.util.ProgressStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class AudioPlayerApplet
extends JApplet
implements ActionListener,
PlayerListener,
AudioClipListener,
ProgressListener {
    public static final boolean DEBUG = false;
    public static final String VERSION = AudioPlayerApplet.class.getPackage().getImplementationVersion();
    private static final Float PREFERRED_LINE_BUFFER_SIZE_MILLIS = Float.valueOf(1000.0f);
    protected URL audioURL;
    private VectorBufferedOutputStream vbOut;
    protected AudioSource audioSource;
    protected AudioSource playbackSource;
    protected AudioClipUIContainer uiContainer;
    protected AudioClip audioSample;
    private JPanel playerPanel;
    private JButton playButton;
    private JButton stopButton;
    private JRadioButton[] channelSelectButtons = null;
    private JRadioButton channelSelectAllButton;
    private ButtonGroup channelSelectButtonGroup;
    private Player player;
    private Timer updateTimer;
    private Mixer device;
    private Container contentPane;
    private AudioSignalUI signalUI = null;
    private FourierUI fourierUI = null;
    private boolean open = false;
    private URLContentLoader urlContentLoader;
    private JProgressDialogPanel progressPanel;
    private JScrollPane scrollPane;
    private Status status = Status.EXISTING;
    private int channels;

    @Override
    public void init() {
        if (EventQueue.isDispatchThread()) {
            this._init();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        AudioPlayerApplet.this._init();
                    }
                });
            }
            catch (InterruptedException e) {
                this.showStatus(e.getMessage());
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                this.showStatus(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void start() {
        if (EventQueue.isDispatchThread()) {
            this._start();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        AudioPlayerApplet.this._start();
                    }
                });
            }
            catch (InterruptedException e) {
                this.showStatus(e.getMessage());
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                this.showStatus(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void stop() {
        if (EventQueue.isDispatchThread()) {
            this._stop();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        AudioPlayerApplet.this._stop();
                    }
                });
            }
            catch (InterruptedException e) {
                this.showStatus(e.getMessage());
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                this.showStatus(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void destroy() {
        if (EventQueue.isDispatchThread()) {
            this._destroy();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        AudioPlayerApplet.this._destroy();
                    }
                });
            }
            catch (InterruptedException e) {
                this.showStatus(e.getMessage());
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                this.showStatus(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void _init() {
        if (Status.EXISTING.equals((Object)this.status)) {
            String audioURLStr = this.getParameter("url");
            try {
                this.audioURL = new URL(audioURLStr);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                this.showStatus("Malformed URL: '" + this.audioURL + "'");
                return;
            }
            this.vbOut = new VectorBufferedOutputStream();
            this.urlContentLoader = new URLContentLoader(this.audioURL, (OutputStream)this.vbOut, "URL content loader");
            this.contentPane = this.getContentPane();
            this.contentPane.setLayout(new BorderLayout());
            this.signalUI = new AudioSignalUI();
            this.fourierUI = new FourierUI();
            this.fourierUI.setUseThread(true);
            AudioTimeScaleUI timeScale = new AudioTimeScaleUI();
            this.uiContainer = new AudioClipUIContainer();
            this.uiContainer.add(this.signalUI);
            this.uiContainer.add(this.fourierUI);
            this.uiContainer.add((Component)((Object)timeScale));
            this.scrollPane = new JScrollPane(this.uiContainer);
            this.audioSample = new AudioClip();
            this.audioSample.addAudioSampleListener(this);
            this.uiContainer.setAudioClip(this.audioSample);
            this.progressPanel = new JProgressDialogPanel((Worker)this.urlContentLoader, "title", "Loading audio ...");
            this.add((Component)this.progressPanel, "Center");
            this.playerPanel = new JPanel();
            this.playButton = new JButton("Play");
            this.stopButton = new JButton("Stop");
            this.playerPanel.add(this.playButton);
            this.playerPanel.add(this.stopButton);
            this.playButton.addActionListener(this);
            this.stopButton.addActionListener(this);
            this.contentPane.add((Component)this.playerPanel, "South");
            this.channelSelectAllButton = new JRadioButton("All");
            try {
                MixerManager mm = new MixerManager();
                Mixer[] devices = mm.getDirectPlaybackMixers();
                if (devices != null && devices.length > 0) {
                    this.device = devices[0];
                    this.player = new Player(this.device);
                } else {
                    this.player = new Player();
                }
            }
            catch (LineUnavailableException e) {
                e.printStackTrace();
                this.showStatus("Could not get a direct audio device !");
            }
            if (this.player == null) {
                this.player = new Player();
            }
            if (this.player != null) {
                this.player.setPreferredLineBufferSizeMillis(PREFERRED_LINE_BUFFER_SIZE_MILLIS);
                this.player.setMeasureLevel(false);
                this.player.addPlayerListener(this);
            }
            this.playButton.setEnabled(false);
            this.stopButton.setEnabled(false);
            this.updateTimer = new Timer(200, this);
            this.open = true;
            this.showStatus("Audio player initialized.");
            this.status = Status.INITIALIZED;
        }
    }

    public void _start() {
        if (this.status.equals((Object)Status.INITIALIZED)) {
            this.urlContentLoader.addProgressListener((ProgressListener)this);
            try {
                this.urlContentLoader.open();
            }
            catch (WorkerException e) {
                String errMsg = "Error loading audio from '" + this.audioURL + "' : " + e.getLocalizedMessage();
                this.showStatus(errMsg);
                JOptionPane.showMessageDialog(this, errMsg, "Audio applet loading error", 0);
                return;
            }
            this.status = Status.LOADING;
            this.showStatus("Downloading audio data from '" + this.audioURL + "' ...");
            this.urlContentLoader.start();
        } else if (Status.APPLET_STOPPED.equals((Object)this.status)) {
            this.enableAudio();
            this.makeReady();
        }
    }

    public void makeReady() {
        this.contentPane.invalidate();
        this.contentPane.validate();
        this.repaint();
        this.status = Status.READY;
    }

    private void process() {
        this.status = Status.PROCESS;
        VectorBuffer vb = this.vbOut.getVectorBuffer();
        VectorBufferAudioSource vbAudioSource = new VectorBufferAudioSource(vb);
        this.playbackSource = this.audioSource = vbAudioSource;
        AudioClip audioClip = new AudioClip(this.audioSource);
        AudioClipProcessor processor = new AudioClipProcessor(audioClip);
        processor.setCalculateSBNR(true);
        this.showStatus("Processing audio data ...");
        try {
            processor.process();
        }
        catch (AudioSourceException e) {
            e.printStackTrace();
            this.showStatus("Error processing audio data.");
            return;
        }
        AudioClipDSPInfo dspInfo = audioClip.getClipDSPInfo();
        AudioClipDSPInfoViewer infoView = new AudioClipDSPInfoViewer(dspInfo);
        this.contentPane.add((Component)infoView, "North");
        this.contentPane.add((Component)this.scrollPane, "Center");
        this.channels = dspInfo.getAudioFormat().getChannels();
        if (this.channelSelectButtons != null) {
            for (JRadioButton chSelButt : this.channelSelectButtons) {
                chSelButt.removeActionListener(this);
                this.playerPanel.remove(chSelButt);
            }
            this.channelSelectAllButton.removeActionListener(this);
            this.playerPanel.remove(this.channelSelectAllButton);
        }
        if (this.channels > 1) {
            this.channelSelectButtons = new JRadioButton[this.channels + 1];
            this.channelSelectButtonGroup = new ButtonGroup();
            for (int ch = 0; ch < this.channels; ++ch) {
                JRadioButton chSelButt = new JRadioButton("Ch " + ch);
                this.channelSelectButtonGroup.add(chSelButt);
                this.playerPanel.add(chSelButt);
                chSelButt.addActionListener(this);
                this.channelSelectButtons[ch] = chSelButt;
            }
            this.channelSelectAllButton.setSelected(true);
            this.channelSelectAllButton.addActionListener(this);
            this.channelSelectButtonGroup.add(this.channelSelectAllButton);
            this.channelSelectButtons[this.channels] = this.channelSelectAllButton;
            this.playerPanel.add(this.channelSelectAllButton);
        }
        this.contentPane.validate();
    }

    private void enableAudio() {
        if (this.audioSample != null) {
            this.audioSample.setAudioSource(this.audioSource);
            this.uiContainer.xZoomFitToPanel();
            if (this.player != null) {
                try {
                    this.player.setAudioSource(this.playbackSource);
                    this.playButton.setEnabled(true);
                    this.updateTimer.start();
                    this.showStatus("Audio player ready.");
                }
                catch (PlayerException e) {
                    e.printStackTrace();
                    this.showStatus("Could not set playback audio source !");
                }
            } else {
                this.showStatus("No audio player available.");
            }
        } else {
            this.showStatus("No audio clip available.");
        }
    }

    public void _stop() {
        if (Status.LOADING.equals((Object)this.status)) {
            this.urlContentLoader.cancel();
            try {
                this.urlContentLoader.close();
                this.urlContentLoader.reset();
            }
            catch (WorkerException e) {
                e.printStackTrace();
            }
            this.status = Status.INITIALIZED;
        } else {
            if (this.audioSample != null) {
                this.updateTimer.stop();
                this.playButton.setEnabled(false);
                this.audioSample.setAudioSource(null);
            }
            if (this.player != null) {
                try {
                    this.player.close();
                    this.showStatus("Audio player closed.");
                }
                catch (PlayerException e) {
                    e.printStackTrace();
                    this.showStatus("Could not close audio player !");
                }
            }
            this.status = Status.APPLET_STOPPED;
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object src = arg0.getSource();
        if (src == this.updateTimer) {
            this.audioSample.setFramePosition(this.player.getFramePosition());
        } else if (src == this.playButton) {
            this.playSelection();
        } else if (src == this.stopButton) {
            this.player.stop();
        } else if (this.channelSelectButtons != null) {
            AudioSource newPlaybackSource = null;
            if (src == this.channelSelectAllButton) {
                newPlaybackSource = this.audioSource;
            } else {
                for (int c = 0; c < this.channelSelectButtons.length; ++c) {
                    if (src != this.channelSelectButtons[c]) continue;
                    PluginChain pCh = new PluginChain(this.audioSource);
                    try {
                        pCh.add(new ChannelSelectorPlugin(c));
                    }
                    catch (AudioFormatNotSupportedException e) {
                        e.printStackTrace();
                    }
                    newPlaybackSource = pCh;
                }
            }
            if (newPlaybackSource != null) {
                this.playbackSource = newPlaybackSource;
                try {
                    this.player.close();
                    this.player.setAudioSource(this.playbackSource);
                }
                catch (PlayerException e) {
                    e.printStackTrace();
                    this.showStatus("Could not close audio player !");
                }
            }
        }
    }

    private void playSelection() {
        if (this.player == null || this.player.isOpen()) {
            return;
        }
        Selection s = this.audioSample.getSelection();
        if (s != null) {
            this.player.setStartFramePosition(s.getLeft());
            this.player.setStopFramePosition(s.getRight());
        } else {
            this.player.setStartFramePosition(0L);
            this.player.setStopFramePosition(ThreadSafeAudioSystem.NOT_SPECIFIED);
        }
        try {
            this.player.open();
            this.showStatus("Audio player open.");
            this.player.play();
            this.showStatus("Audio player playing...");
            this.stopButton.setEnabled(true);
        }
        catch (PlayerException e) {
            e.printStackTrace();
            this.showStatus("Cannot play audio !");
        }
    }

    @Override
    public void update(PlayerEvent playerEvent) {
        if (playerEvent instanceof PlayerStartEvent) {
            if (this.open) {
                this.stopButton.setEnabled(true);
                this.playButton.setEnabled(false);
            }
        } else if (playerEvent instanceof PlayerStopEvent) {
            if (this.open) {
                this.stopButton.setEnabled(false);
                this.playButton.setEnabled(false);
            }
            try {
                this.player.close();
            }
            catch (PlayerException e) {
                e.printStackTrace();
                this.showStatus("Could not close audio player !");
            }
        } else if (playerEvent instanceof PlayerCloseEvent) {
            if (this.open) {
                this.playButton.setEnabled(true);
                this.stopButton.setEnabled(false);
            }
            this.showStatus("Audio player closed.");
        }
    }

    @Override
    public void audioClipChanged(AudioClipChangedEvent event) {
        SelectionChangedEvent selEv;
        if (event instanceof SelectionChangedEvent && (selEv = (SelectionChangedEvent)event).getSelection() != null) {
            this.playSelection();
        }
    }

    public void _destroy() {
        this.open = false;
        if (this.updateTimer != null) {
            this.updateTimer.stop();
        }
        if (this.uiContainer != null) {
            this.uiContainer.close();
        }
        if (this.audioSample != null) {
            this.audioSample.removeAudioSampleListener(this);
        }
        this.contentPane.removeAll();
        this.status = Status.APPLET_DESTROYED;
    }

    public void update(ProgressEvent progressEvent) {
        ProgressStatus status = progressEvent.getProgressStatus();
        if (progressEvent instanceof ProgressErrorEvent) {
            this.contentPane.remove((Component)this.progressPanel);
            String errMsg = "Unknown error!";
            if (status != null) {
                errMsg = status.getMessage().localize();
            }
            this.showStatus(errMsg);
            JOptionPane.showMessageDialog(this, errMsg, "Audio applet loading error", 0);
        } else if (status != null && status.isDone()) {
            this.contentPane.remove((Component)this.progressPanel);
            this.process();
            this.enableAudio();
            this.makeReady();
        }
    }

    public static enum Status {
        EXISTING,
        INITIALIZED,
        LOADING,
        PROCESS,
        READY,
        APPLET_STOPPED,
        APPLET_DESTROYED;

    }
}

