/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.applet;

import ipsk.audio.bean.AudioPlayerBean;
import ipsk.swing.applet.JAppletDispatchThreadWrapper;
import java.awt.HeadlessException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;

public class AudioPlayerBeanApplet
extends JAppletDispatchThreadWrapper
implements PropertyChangeListener {
    public static final boolean DEBUG = false;
    public static final String VERSION = AudioPlayerBeanApplet.class.getPackage().getImplementationVersion();
    protected AudioPlayerBean audioPlayer = null;
    protected URL audioURL;
    protected static String[][] pInfo = new String[][]{{"url", "url", "Audio URL"}, {"ui", "string", "Comma separated list of UI modules: signal,sonagram,dsp-info"}};

    public String[][] getParameterInfo() {
        return pInfo;
    }

    public void initByDT() {
        this.audioPlayer = new AudioPlayerBean();
        this.getContentPane().add(this.audioPlayer);
        String uiConfig = this.getParameter("ui");
        boolean showDSPInfo = false;
        boolean showAudioSignal = false;
        boolean showSona = false;
        boolean showTimeScale = false;
        if (uiConfig != null) {
            String[] uiModuls;
            for (String uiModstr : uiModuls = uiConfig.split(",")) {
                String uiModul = uiModstr.toUpperCase(Locale.ENGLISH).trim();
                if (uiModul.equals("SIGNAL")) {
                    showAudioSignal = true;
                    continue;
                }
                if (uiModul.equals("SONAGRAM")) {
                    showSona = true;
                    continue;
                }
                if (uiModul.equals("TIMESCALE")) {
                    showTimeScale = true;
                    continue;
                }
                if (!uiModul.equals("DSPINFO")) continue;
                showDSPInfo = true;
            }
        } else {
            showAudioSignal = true;
            showTimeScale = true;
        }
        this.audioPlayer.setShowDSPInfo(showDSPInfo);
        this.audioPlayer.setShowSonagram(showSona);
        this.audioPlayer.setShowTimeScale(showTimeScale);
        this.audioPlayer.setVisualizing(true);
        String audioURLStr = this.getParameter("url");
        try {
            this.audioURL = new URL(audioURLStr);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            this.showStatus("Malformed URL: '" + this.audioURL + "'");
            return;
        }
        this.audioPlayer.addPropertyChangeListener(this);
    }

    public void startByDT() {
        this.audioPlayer.setURL(this.audioURL);
        this.audioPlayer.reactivate();
        this.getContentPane().validate();
    }

    public void stopByDT() {
        this.audioPlayer.deactivate();
    }

    public void destroyByDT() {
        this.getContentPane().removeAll();
        this.audioPlayer.close();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String pName;
        if (evt != null && "message".equals(pName = evt.getPropertyName())) {
            String msg = (String)evt.getNewValue();
            if (msg != null) {
                this.showStatus(msg);
            } else {
                this.showStatus("");
            }
        }
    }

    public static enum Status {
        EXISTING,
        INITIALIZED,
        LOADING,
        PROCESS,
        READY,
        APPLET_STOPPED,
        APPLET_DESTROYED;

    }
}

