/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.bean;

import ipsk.audio.FileAudioSource;
import ipsk.audio.ThreadSafeAudioSystem;
import ipsk.audio.actions.PauseAction;
import ipsk.audio.actions.StartPlaybackAction;
import ipsk.audio.actions.StopAction;
import ipsk.audio.arr.Selection;
import ipsk.audio.arr.clip.AudioClip;
import ipsk.audio.arr.clip.AudioClipListener;
import ipsk.audio.arr.clip.events.AudioClipChangedEvent;
import ipsk.audio.arr.clip.events.AudioSourceChangedEvent;
import ipsk.audio.arr.clip.events.SelectionChangedEvent;
import ipsk.audio.events.StartPlaybackActionEvent;
import ipsk.audio.player.Player;
import ipsk.audio.player.PlayerException;
import ipsk.audio.player.PlayerListener;
import ipsk.audio.player.event.PlayerCloseEvent;
import ipsk.audio.player.event.PlayerEvent;
import ipsk.audio.player.event.PlayerPauseEvent;
import ipsk.audio.player.event.PlayerStartEvent;
import ipsk.audio.player.event.PlayerStopEvent;
import ipsk.awt.PropertyChangeAWTEventTransferAgent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.EventListener;
import java.util.EventObject;
import javax.sound.sampled.Mixer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class AudioClipPlayer
extends Player
implements ActionListener,
PlayerListener,
AudioClipListener {
    public static final boolean DEBUG = false;
    public static final String VERSION = AudioClipPlayer.class.getPackage().getImplementationVersion();
    private static final Float PREFERRED_LINE_BUFFER_SIZE_MILLIS = Float.valueOf(1000.0f);
    protected PropertyChangeAWTEventTransferAgent pChTa = new PropertyChangeAWTEventTransferAgent();
    protected AudioClip audioClip;
    private Timer updateTimer;
    private Mixer device;
    private boolean autoPlayOnLoad = false;
    private Selection selection;
    private boolean startPlayOnSelect;
    private int channels;
    private String message;
    private StartPlaybackAction startAction;
    private StopAction stopAction;
    private PauseAction pauseAction;

    public AudioClipPlayer(AudioClip audioClip) {
        this(audioClip, null);
    }

    public AudioClipPlayer(AudioClip audioClip, Mixer device) {
        super(device);
        this.audioClip = audioClip;
        this.setPreferredLineBufferSizeMillis(PREFERRED_LINE_BUFFER_SIZE_MILLIS);
        this.setMeasureLevel(false);
        this.addPlayerListener(this);
        this.startAction = new StartPlaybackAction();
        this.stopAction = new StopAction();
        this.pauseAction = new PauseAction();
        this.startAction.setEnabled(false);
        this.stopAction.setEnabled(false);
        this.pauseAction.setEnabled(false);
        this.startAction.addActionListener(this);
        this.stopAction.addActionListener(this);
        this.pauseAction.addActionListener(this);
        this.updateTimer = new Timer(200, this);
        this.updateTimer.addActionListener(this);
        this.updateTimer.start();
        this.setMessage("Audio player initialized.");
        audioClip.addAudioSampleListener(this);
    }

    public void setAudioClip(AudioClip audioClip) throws PlayerException {
        if (audioClip != null && audioClip.equals(this.audioClip)) {
            return;
        }
        this.close();
        this.audioClip = audioClip;
        if (audioClip != null) {
            this.setAudioSource(audioClip.getAudioSource());
        } else {
            this.setAudioSource(null);
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object src = arg0.getSource();
        String actionCommand = arg0.getActionCommand();
        if (src == this.updateTimer) {
            long framePosition = this.getFramePosition();
            if (framePosition != (long)ThreadSafeAudioSystem.NOT_SPECIFIED) {
                this.audioClip.setFramePosition(framePosition);
            }
        } else if (actionCommand == StartPlaybackAction.ACTION_COMMAND) {
            if (arg0 instanceof StartPlaybackActionEvent) {
                StartPlaybackActionEvent spae = (StartPlaybackActionEvent)arg0;
                this.setStartFramePosition(spae.getStartFramePosition());
                this.setStopFramePosition(spae.getStopFramePosition());
                if (!this.isOpen()) {
                    try {
                        this.open();
                        this.setMessage("Audio player open.");
                        this.play();
                    }
                    catch (PlayerException e) {
                        e.printStackTrace();
                        this.setMessage("Cannot play audio !");
                    }
                }
            } else {
                this.playSelection();
            }
        } else if (actionCommand == StopAction.ACTION_COMMAND) {
            this.stop();
        } else if (actionCommand == PauseAction.ACTION_COMMAND) {
            this.pause();
        }
    }

    @Override
    public void update(PlayerEvent playerEvent) {
        if (playerEvent instanceof PlayerStartEvent) {
            this.setMessage("Audio player playing...");
            this.stopAction.setEnabled(true);
            this.stopAction.setHighlighted(false);
            this.pauseAction.setEnabled(true);
            this.pauseAction.setHighlighted(false);
            this.startAction.setEnabled(false);
            this.startAction.setHighlighted(true);
        } else if (playerEvent instanceof PlayerPauseEvent) {
            this.setMessage("Audio player paused.");
            this.stopAction.setEnabled(true);
            this.stopAction.setHighlighted(false);
            this.pauseAction.setEnabled(true);
            this.pauseAction.setHighlighted(true);
            this.startAction.setEnabled(false);
            this.startAction.setHighlighted(true);
        } else if (playerEvent instanceof PlayerStopEvent) {
            this.stopAction.setEnabled(false);
            this.stopAction.setHighlighted(true);
            this.pauseAction.setEnabled(false);
            this.pauseAction.setHighlighted(false);
            this.startAction.setEnabled(false);
            this.startAction.setHighlighted(false);
            this.setMessage("Audio player stopped.");
            try {
                super.close();
            }
            catch (PlayerException e) {
                e.printStackTrace();
                this.setMessage("Could not close audio player !");
            }
        } else if (playerEvent instanceof PlayerCloseEvent) {
            this.stopAction.setEnabled(false);
            this.stopAction.setHighlighted(true);
            this.startAction.setEnabled(true);
            this.startAction.setHighlighted(false);
            this.setMessage("Audio player closed.");
        }
    }

    @Override
    public void audioClipChanged(AudioClipChangedEvent event) {
        if (event instanceof SelectionChangedEvent) {
            SelectionChangedEvent selEv = (SelectionChangedEvent)event;
            if (selEv.getSelection() != null && this.startPlayOnSelect) {
                this.playSelection();
            }
        } else if (event instanceof AudioSourceChangedEvent) {
            try {
                if (this.audioClip != null) {
                    this.setAudioSource(this.audioClip.getAudioSource());
                } else {
                    this.setAudioSource(null);
                }
            }
            catch (PlayerException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void close() throws PlayerException {
        super.close();
        if (this.updateTimer != null) {
            this.updateTimer.stop();
        }
        if (this.audioClip != null) {
            this.audioClip.removeAudioSampleListener(this);
        }
    }

    public void setSelection(Selection selection) {
        this.selection = selection;
        this.audioClip.setSelection(selection);
    }

    public Selection getSelection() {
        return this.selection;
    }

    private void playSelection() {
        if (this.isOpen()) {
            return;
        }
        if (this.audioClip != null) {
            Selection s = this.audioClip.getSelection();
            if (s != null) {
                this.setStartFramePosition(s.getLeft());
                this.setStopFramePosition(s.getRight());
            } else {
                this.setStartFramePosition(0L);
                this.setStopFramePosition(-1L);
            }
            try {
                this.open();
                this.setMessage("Audio player open.");
                this.play();
            }
            catch (PlayerException e) {
                e.printStackTrace();
                this.setMessage("Cannot play audio !");
            }
        }
    }

    public boolean isStartPlayOnSelect() {
        return this.startPlayOnSelect;
    }

    public void setStartPlayOnSelect(boolean startPlayOnSelect) {
        this.startPlayOnSelect = startPlayOnSelect;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: AudioPlayerBean audioFile");
            System.exit(-1);
        }
        final File audioFile = new File(args[0]);
        Runnable playRunnable = new Runnable(){

            @Override
            public void run() {
                AudioClip ac = new AudioClip();
                AudioClipPlayer acp = new AudioClipPlayer(ac);
                ac.setAudioSource(new FileAudioSource(audioFile));
                acp.getStartAction().actionPerformed(new ActionEvent(acp, 1001, StartPlaybackAction.ACTION_COMMAND));
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                acp.getStopAction().actionPerformed(new ActionEvent(acp, 1001, StopAction.ACTION_COMMAND));
            }
        };
        SwingUtilities.invokeLater(playRunnable);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        String oldMessage = this.message;
        this.message = message;
        this.pChTa.fireEvent((EventObject)new PropertyChangeEvent(this, "message", oldMessage, this.message));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pChTa.addListener((EventListener)listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pChTa.removeListener((EventListener)listener);
    }

    public StartPlaybackAction getStartAction() {
        return this.startAction;
    }

    public void setStartAction(StartPlaybackAction startAction) {
        if (this.startAction != startAction) {
            this.startAction.removeActionListener(this);
            this.startAction = startAction;
            startAction.addActionListener(this);
        }
    }

    public StopAction getStopAction() {
        return this.stopAction;
    }

    public void setStopAction(StopAction stopAction) {
        if (this.stopAction != stopAction) {
            this.stopAction.removeActionListener(this);
            this.stopAction = stopAction;
            this.stopAction.addActionListener(this);
        }
    }
}

