/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.capture.session.info;

import ipsk.audio.capture.session.info.RecordingFile;
import ipsk.audio.capture.session.info.RecordingSequence;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class RecordingSession {
    public static final String DEFAULT_RECORDING_SESSION_INFO_FILENAME = "recording_session_info.xml";
    private List<RecordingSequence> recordingSequenceList = new ArrayList<RecordingSequence>();

    @XmlElement(name="recordingSequence")
    public List<RecordingSequence> getRecordingSequenceList() {
        return this.recordingSequenceList;
    }

    public void setRecordingSequenceList(List<RecordingSequence> recordingSequenceList) {
        this.recordingSequenceList = recordingSequenceList;
    }

    public RecordingFile removeRecordingFile(File recFile) {
        List<RecordingSequence> seqInfos = this.getRecordingSequenceList();
        RecordingFile rfFound = null;
        RecordingSequence rseqFound = null;
        int seqFoundInd = -1;
        ArrayList<RecordingFile> beforeList = new ArrayList<RecordingFile>();
        ArrayList<RecordingFile> afterList = new ArrayList<RecordingFile>();
        for (int i = 0; i < seqInfos.size(); ++i) {
            RecordingSequence rSeq = seqInfos.get(i);
            List<RecordingFile> rfs = rSeq.getRecordingFileList();
            for (RecordingFile rf : rfs) {
                File f = rf.getFile();
                if (f.equals(recFile) || !f.isAbsolute() && recFile.getName().equals(f.getName())) {
                    rfFound = rf;
                    rseqFound = rSeq;
                    seqFoundInd = i;
                    continue;
                }
                if (rfFound == null) {
                    beforeList.add(rf);
                    continue;
                }
                afterList.add(rf);
            }
            if (rfFound != null) break;
        }
        if (rfFound != null) {
            seqInfos.remove(seqFoundInd);
            if (afterList.size() > 0) {
                RecordingSequence afterSeq = new RecordingSequence();
                afterSeq.setRecordingFileList(afterList);
                seqInfos.add(seqFoundInd, afterSeq);
            }
            if (beforeList.size() > 0) {
                RecordingSequence beforeSeq = new RecordingSequence();
                beforeSeq.setRecordingFileList(beforeList);
                seqInfos.add(seqFoundInd, beforeSeq);
            }
        }
        return rfFound;
    }

    public static void main(String[] args) {
        RecordingFile rf = new RecordingFile(new File("blafile.wav"));
        rf.setLastModified(new Date());
        RecordingFile rf2 = new RecordingFile(new File("blafile2.wav"));
        RecordingSequence rseq = new RecordingSequence();
        rseq.getRecordingFileList().add(rf);
        rseq.getRecordingFileList().add(rf2);
        rseq.setFrameLength(12345000L);
        RecordingSession rs = new RecordingSession();
        rs.getRecordingSequenceList().add(rseq);
        JAXB.marshal((Object)rs, (OutputStream)System.out);
    }
}

