/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.dsp;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.RandomAccessAudioStream;
import ipsk.audio.dsp.AudioFrameProcessor;
import ipsk.audio.dsp.FloatRandomAccessStream;

public class BufferedFloatRandomAccessStream
extends FloatRandomAccessStream {
    private static final int DEF_MAX_CACHE_SIZE = 80000000;
    private int maxCacheSize = 80000000;
    private double[][] cache;
    int cacheFilledFrames = 0;
    long framePos = 0L;

    public BufferedFloatRandomAccessStream(AudioSource audioSource) throws AudioFormatNotSupportedException, AudioSourceException {
        this(audioSource, 80000000);
    }

    public BufferedFloatRandomAccessStream(AudioSource audioSource, int maxCacheSize) throws AudioFormatNotSupportedException, AudioSourceException {
        super(audioSource);
        long length;
        this.maxCacheSize = maxCacheSize;
        long frameLength = audioSource.getFrameLength();
        this.raas = new RandomAccessAudioStream(audioSource);
        this.audioFormat = audioSource.getFormat();
        this.frameSize = this.audioFormat.getFrameSize();
        int channels = this.audioFormat.getChannels();
        this.buffer = new byte[0];
        this.bufferProcessor = new AudioFrameProcessor(this.audioFormat);
        int cacheLen = maxCacheSize / (64 * channels);
        if (frameLength != -1L && (long)maxCacheSize >= (length = frameLength * (long)channels * 64L)) {
            cacheLen = (int)frameLength;
        }
        this.cache = new double[cacheLen][channels];
    }

    @Override
    public void close() throws AudioSourceException {
        this.raas.close();
    }

    private int availCachedFrames(int len) {
        if (this.framePos >= (long)this.cacheFilledFrames) {
            return 0;
        }
        return (int)((long)this.cacheFilledFrames - this.framePos);
    }

    private int cachableFrames(int frames) {
        long cachableFrames = this.framePos + (long)frames - (long)this.cacheFilledFrames;
        if (cachableFrames < 0L) {
            return 0;
        }
        long cacheFree = this.cache.length - this.cacheFilledFrames;
        if (cachableFrames > cacheFree) {
            cachableFrames = cacheFree;
        }
        return (int)cachableFrames;
    }

    @Override
    public int readFrames(double[][] normBuf, int frameOffset, int frames) throws AudioSourceException {
        int availFrames;
        int cacheableFrames = this.cachableFrames(frames);
        if (cacheableFrames > 0) {
            int readFrames;
            this.raas.setPosition(this.cacheFilledFrames);
            int bytesToRead = this.frameSize * cacheableFrames;
            if (this.buffer.length < bytesToRead) {
                this.buffer = new byte[bytesToRead];
            }
            if ((readFrames = this.raas.readFrames(this.buffer, 0, cacheableFrames)) != -1) {
                this.bufferProcessor.getNormalizedInterleavedValues(this.buffer, readFrames, this.cache, this.cacheFilledFrames);
                this.cacheFilledFrames += readFrames;
            }
        }
        if ((availFrames = this.availCachedFrames(frames)) > 0) {
            int toCopy = availFrames;
            if (toCopy > frames) {
                toCopy = frames;
            }
            for (int i = 0; i < toCopy; ++i) {
                for (int ch = 0; ch < this.audioFormat.getChannels(); ++ch) {
                    normBuf[frameOffset + i][ch] = this.cache[(int)this.framePos + i][ch];
                }
            }
            this.framePos += (long)toCopy;
            return toCopy;
        }
        this.raas.setPosition(this.framePos);
        int frRead = super.readFrames(normBuf, frameOffset, frames);
        if (frRead == -1) {
            return -1;
        }
        this.framePos += (long)frRead;
        return frRead;
    }

    @Override
    public void setFramePosition(long newPos) throws AudioSourceException {
        this.framePos = newPos;
    }

    @Override
    public long skipFrames(long framesToSkip) throws AudioSourceException {
        this.raas.setPosition(this.framePos * (long)this.frameSize);
        long skippedFrames = this.raas.skipFrames(framesToSkip);
        this.framePos += skippedFrames;
        return skippedFrames;
    }

    @Override
    public String toString() {
        return new String("Float value audio source (scale -1 to +1) based on:" + this.audioSource.toString());
    }

    @Override
    public long getFrameLength() throws AudioSourceException {
        return this.audioSource.getFrameLength();
    }

    @Override
    public int getChannels() throws AudioSourceException {
        return this.audioSource.getFormat().getChannels();
    }
}

