/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.dsp;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.dsp.AudioFrameProcessor;
import ipsk.audio.dsp.LevelInfo;
import javax.sound.sampled.AudioFormat;

public class PeakDetector
extends AudioFrameProcessor {
    private float[] levels;
    private float[] peakLevels;
    protected static float ln = (float)(20.0 / Math.log(10.0));
    private float[] max;
    private float[] min;
    private double[] absSum;

    public PeakDetector(AudioFormat af) throws AudioFormatNotSupportedException {
        super(af);
        this.levels = new float[this.channels];
        this.peakLevels = new float[this.channels];
        this.max = new float[this.channels];
        this.min = new float[this.channels];
        this.absSum = new double[this.channels];
    }

    public LevelInfo[] processBuffer(byte[] data, int offset, int length) {
        for (int i = 0; i < this.channels; ++i) {
            this.max[i] = Float.NEGATIVE_INFINITY;
            this.min[i] = Float.POSITIVE_INFINITY;
            this.absSum[i] = 0.0;
        }
        int bc = offset;
        int frames = length / this.frameSize;
        if (frames == 0) {
            return null;
        }
        for (int f = 0; f < frames; ++f) {
            this.processFrame(this.getFloatValues(data, bc));
            bc += this.frameSize;
        }
        LevelInfo[] levelInfos = new LevelInfo[this.channels];
        for (int i = 0; i < this.channels; ++i) {
            levelInfos[i] = new LevelInfo((float)(this.absSum[i] / (double)frames), Math.max(Math.abs(this.max[i]), Math.abs(this.min[i])) * 2.0f);
        }
        return levelInfos;
    }

    public void processBuffer(byte[] data, int offset, int length, LevelInfo[] levelInfos) {
        int i;
        if (levelInfos.length != this.channels) {
            throw new IllegalArgumentException("Level info array must match channel count !");
        }
        for (int i2 = 0; i2 < this.channels; ++i2) {
            this.max[i2] = Float.NEGATIVE_INFINITY;
            this.min[i2] = Float.POSITIVE_INFINITY;
            this.absSum[i2] = 0.0;
        }
        int bc = offset;
        int frames = length / this.frameSize;
        if (frames == 0) {
            for (i = 0; i < levelInfos.length; ++i) {
                levelInfos[i].setLevel(0.0f);
                levelInfos[i].setPeakLevel(0.0f);
            }
        }
        for (int f = 0; f < frames; ++f) {
            this.processFrame(this.getFloatValues(data, bc));
            bc += this.frameSize;
        }
        for (i = 0; i < this.channels; ++i) {
            LevelInfo li = levelInfos[i];
            li.setLevel((float)(this.absSum[i] / (double)frames));
            float peakLevel = Math.max(Math.abs(this.max[i]), Math.abs(this.min[i])) * 2.0f;
            li.setPeakLevel(peakLevel);
            float currentPeakLevelHold = li.getPeakLevelHold();
            if (!(currentPeakLevelHold < peakLevel)) continue;
            li.setPeakLevelHold(peakLevel);
        }
    }

    public void process(byte[] data, int offset, int length) {
        for (int i = 0; i < this.channels; ++i) {
            this.max[i] = Float.NEGATIVE_INFINITY;
            this.min[i] = Float.POSITIVE_INFINITY;
            this.absSum[i] = 0.0;
        }
        int bc = offset;
        int frames = length / this.frameSize;
        for (int f = 0; f < frames; ++f) {
            this.processFrame(this.getFloatValues(data, bc));
            bc += this.frameSize;
        }
        for (int i = 0; i < this.channels; ++i) {
            this.levels[i] = (float)(this.absSum[i] / (double)frames);
            this.peakLevels[i] = Math.max(Math.abs(this.max[i]), Math.abs(this.min[i])) * 2.0f;
        }
    }

    protected void processFrame(float[] f) {
        for (int i = 0; i < f.length; ++i) {
            int n = i;
            this.absSum[n] = this.absSum[n] + (double)Math.abs(f[i]);
            if (f[i] > this.max[i]) {
                this.max[i] = f[i];
            }
            if (!(f[i] < this.min[i])) continue;
            this.min[i] = f[i];
        }
    }

    public float[] getPeakLevels() {
        return this.peakLevels;
    }

    public float[] getLevels() {
        return this.levels;
    }

    public void setLevels(float[] levels) {
        this.levels = levels;
    }
}

