/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.impl.j2audio;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.dsp.PeakDetector;
import ipsk.audio.impl.j2audio.LineStatus;
import ipsk.audio.impl.j2audio.PlaybackListener;
import ipsk.audio.impl.j2audio.SynchronizedStatus;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class Playback
implements Runnable,
LineListener {
    static final boolean DEBUG = false;
    static final long END_OF_AUDIO_FILE = -1L;
    private Mixer mixer;
    private Line.Info lineInfo;
    private SourceDataLine line = null;
    private int lineBufferSize;
    private LineStatus lineStatus = new LineStatus("Closed");
    private boolean open;
    private PlayerStatus ps = new PlayerStatus("Idle");
    private PlaybackListener pbl;
    private AudioFormat format;
    private int numChannels;
    private long lengthInFrames;
    private int frameSize;
    private long stopPosition = -1L;
    private long runStopPosition = Long.MAX_VALUE;
    private long startPosition = 0L;
    private long framePosition = 0L;
    private long playAisPos = 0L;
    private long framePosOffset;
    boolean posIsSynced = true;
    private InputStream inputStream = null;
    private AudioInputStream playAis;
    private AudioSource playSource = null;
    private Thread sdlThread = null;
    private int read;
    private int toWrite;
    private int wrote;
    private int numBuffers = 2;
    private int bufferSize;
    private byte[][] buffers;
    private PeakDetector peakDetector = null;
    private float[] levels;
    private Vector<BufferLevel> peaks;
    private long statisticPos;

    public Playback(PlaybackListener pbl, Mixer m) {
        this.pbl = pbl;
        this.mixer = m;
        this.peaks = new Vector();
        this.open = false;
    }

    public Playback(PlaybackListener pbl, SourceDataLine line) {
        this.pbl = pbl;
        this.line = line;
        this.mixer = null;
        this.peaks = new Vector();
        this.open = false;
    }

    public SourceDataLine open(AudioFormat af) throws AudioFormatNotSupportedException, LineUnavailableException {
        this.format = af;
        this.numChannels = af.getChannels();
        this.frameSize = af.getFrameSize();
        this.framePosOffset = 0L;
        this.levels = new float[this.numChannels];
        this.resetLevels();
        this.peaks.removeAllElements();
        this.lineInfo = new DataLine.Info(SourceDataLine.class, this.format);
        if (this.mixer != null) {
            this.line = (SourceDataLine)this.mixer.getLine(this.lineInfo);
        }
        this.lineStatus = new LineStatus("Closed");
        this.line.addLineListener(this);
        this.line.open(this.format);
        this.lineBufferSize = this.line.getBufferSize();
        this.bufferSize = this.lineBufferSize / 4;
        int bufferSizeInFrames = this.bufferSize / this.frameSize;
        this.bufferSize = bufferSizeInFrames * this.frameSize;
        this.buffers = new byte[this.numBuffers][this.bufferSize];
        Control sampleRateCtrl = null;
        try {
            sampleRateCtrl = this.line.getControl(FloatControl.Type.SAMPLE_RATE);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (sampleRateCtrl != null) {
            ((FloatControl)sampleRateCtrl).setValue(this.format.getSampleRate());
        }
        this.peakDetector = new PeakDetector(af);
        this.open = true;
        this.statisticPos = 0L;
        return this.line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isPlaying() {
        PlayerStatus playerStatus = this.ps;
        synchronized (playerStatus) {
            return this.ps.getStatus() == "Playing";
            {
            }
        }
    }

    private void resetLevels() {
        for (int i = 0; i < this.numChannels; ++i) {
            this.levels[i] = 0.0f;
        }
    }

    public void prepareToPlay(AudioSource src) throws AudioSourceException, UnsupportedAudioFileException, IOException {
        this.inputStream = null;
        this.playSource = src;
        this.peaks.removeAllElements();
        this.prepareToPlay(this.startPosition);
    }

    public void prepareToPlay(InputStream is) throws AudioSourceException, UnsupportedAudioFileException, IOException {
        this.playSource = null;
        this.inputStream = is;
        this.peaks.removeAllElements();
        this.prepareToPlay(this.startPosition);
    }

    private void prepareToPlay(long position) throws AudioSourceException, UnsupportedAudioFileException, IOException {
        if (this.ps.getStatus() == "Playing") {
            throw new IOException("Playback is busy.");
        }
        if (this.playAis != null) {
            this.playAis.close();
        }
        if (this.playSource != null) {
            this.playAis = this.playSource.getAudioInputStream();
        } else if (this.inputStream != null) {
            this.playAis = AudioSystem.getAudioInputStream(this.inputStream);
        }
        if (this.playAis == null) {
            throw new AudioSourceException("cannot get audio stream");
        }
        if (this.line != null) {
            this.line.flush();
        }
        this.lengthInFrames = this.playAis.getFrameLength();
        if (this.lengthInFrames < this.startPosition) {
            this.startPosition = this.lengthInFrames;
        }
        if (this.stopPosition != -1L) {
            if (this.lengthInFrames < this.stopPosition) {
                this.stopPosition = this.lengthInFrames;
            }
            if (position > this.stopPosition) {
                position = this.stopPosition;
            }
        }
        if (position < this.startPosition) {
            position = this.startPosition;
        }
        if (this.lengthInFrames < position) {
            position = this.lengthInFrames;
        }
        for (long toSkip = (long)this.frameSize * position; toSkip > 0L; toSkip -= this.playAis.skip(toSkip)) {
        }
        this.playAisPos = position;
        this.runStopPosition = this.stopPosition == -1L ? this.lengthInFrames : this.stopPosition;
        if (this.line != null) {
            this.line.flush();
            this.framePosOffset = this.line.getLongFramePosition() - position;
        }
        if (this.ps.getStatus() != "Pause") {
            this.ps.setStatus("Prepared");
        }
    }

    public void play() {
        if (this.ps.getStatus() == "Playing") {
            return;
        }
        this.startSourceDataLine();
    }

    public float[] getLevels() {
        if (this.ps.getStatus() == "Playing" || this.ps.getStatus() == "Draining") {
            int i;
            BufferLevel ps = null;
            long pos = this.getFramePosition();
            for (i = 0; i < this.peaks.size(); ++i) {
                ps = this.peaks.elementAt(i);
                if (ps.framePos <= pos && ps.framePos + (long)ps.length > pos) break;
            }
            if (ps == null) {
                return null;
            }
            for (int r = 0; r < i - 1; ++r) {
                this.peaks.remove(0);
            }
            this.levels = ps.peakLevels;
        } else {
            this.resetLevels();
        }
        return this.levels;
    }

    public void close() {
        if (this.ps.getStatus() == "Playing") {
            this.stopPlayback();
        }
        if (this.line != null && this.line.isOpen()) {
            this.line.close();
            while (this.line.isOpen()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.line.close();
            }
        }
        if (this.line != null) {
            this.line.removeLineListener(this);
        }
        this.open = false;
    }

    public boolean isOpen() {
        return this.open;
    }

    public synchronized boolean startPlayback() {
        String psSt = this.ps.getStatus();
        if (psSt == "Prepared") {
            this.ps.setStatus("Playing");
            if (this.playAisPos < this.runStopPosition) {
                this.line.start();
                this.startNewPlaybackThread();
                return true;
            }
            this.ps.setStatus("Idle");
            return false;
        }
        if (psSt == "Pause") {
            if (this.framePosition < this.runStopPosition) {
                this.ps.setStatus("Playing");
                this.line.start();
                return true;
            }
            this.ps.setStatus("Idle");
            return false;
        }
        return false;
    }

    public synchronized boolean pausePlayback() {
        if (this.ps.getStatus() == "Playing") {
            this.ps.setStatus("Pause");
            this.line.stop();
            return true;
        }
        if (this.ps.getStatus() == "Pause") {
            this.startPlayback();
            return true;
        }
        if (this.ps.getStatus() == "Prepared") {
            this.ps.setStatus("Pause");
            this.startNewPlaybackThread();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPlayback() {
        PlayerStatus playerStatus = this.ps;
        synchronized (playerStatus) {
            if (this.ps.getStatus() == "Playing") {
                this.ps.setStatus("Stop");
                this.line.stop();
                this.line.flush();
                this.ps.waitFor("Idle");
            } else if (this.ps.getStatus() == "Pause") {
                this.ps.setStatus("Stop");
                this.line.flush();
                if (this.sdlThread != null && this.sdlThread.isAlive()) {
                    this.ps.waitFor("Idle");
                }
                this.ps.setStatus("Idle");
            } else if (this.ps.getStatus() == "Draining" || this.ps.getStatus() == "Idle") {
                this.ps.waitFor("Idle");
            } else {
                this.ps.setStatus("Stop");
            }
        }
    }

    public long getFrameLength() {
        if (this.playAis == null) {
            return -1L;
        }
        return this.playAis.getFrameLength();
    }

    public long getFramePosition() {
        if (this.posIsSynced) {
            return this.playAisPos;
        }
        return this.line.getLongFramePosition() - this.framePosOffset;
    }

    public long getMicrosecondPosition() {
        return this.line.getMicrosecondPosition();
    }

    public synchronized void setFramePosition(long framePos) throws IOException {
        String oldStatus = this.ps.getStatus();
        if (oldStatus == "Pause") {
            this.ps.setStatus("Pause flushing");
            this.ps.waitFor("Flushed");
        }
        if (oldStatus == "Pause" || oldStatus == "Prepared") {
            try {
                this.prepareToPlay(framePos);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (oldStatus == "Pause") {
            this.ps.setStatus("Pause");
            if (this.playAisPos <= this.runStopPosition) {
                this.startNewPlaybackThread();
            }
        }
    }

    public long setStartFramePosition(long startPosition) {
        this.startPosition = this.lengthInFrames < startPosition ? this.lengthInFrames : (startPosition < 0L ? 0L : startPosition);
        return this.startPosition;
    }

    public long setStopFramePosition(long stopPosition) {
        this.stopPosition = stopPosition != -1L ? (this.lengthInFrames < stopPosition ? this.lengthInFrames : (stopPosition < 0L ? 0L : stopPosition)) : stopPosition;
        return this.stopPosition;
    }

    private void startSourceDataLine() {
        this.ps.setStatus("Playing");
        this.line.start();
        this.startNewPlaybackThread();
    }

    private void startNewPlaybackThread() {
        try {
            if (this.sdlThread != null) {
                this.sdlThread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.sdlThread = new Thread(this);
        this.sdlThread.setName("Audio-Playback");
        this.sdlThread.start();
    }

    @Override
    public void update(LineEvent le) {
        LineEvent.Type type = le.getType();
        Line src = le.getLine();
        if (src == this.line) {
            if (type.equals(LineEvent.Type.OPEN)) {
                this.lineStatus.setStatus("Opened");
            } else if (type.equals(LineEvent.Type.CLOSE)) {
                this.lineStatus.setStatus("Closed");
            } else if (type.equals(LineEvent.Type.START)) {
                this.lineStatus.setStatus("Started");
                this.pbl.update(this, new PlayerStatus("Playing"));
            } else if (type.equals(LineEvent.Type.STOP)) {
                this.lineStatus.setStatus("Opened");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.read = 0;
        this.posIsSynced = false;
        int currSdlBuf = -1;
        while (this.read >= 0 && (this.ps.getStatus() == "Playing" || this.ps.getStatus() == "Pause")) {
            long toRead;
            if (++currSdlBuf == this.numBuffers) {
                currSdlBuf = 0;
            }
            if ((toRead = this.runStopPosition >= 0L ? (this.runStopPosition - this.playAisPos) * (long)this.frameSize : (long)this.bufferSize) <= 0L) {
                this.read = -1;
            } else {
                if (toRead > (long)this.bufferSize) {
                    toRead = this.bufferSize;
                }
                try {
                    this.read = 0;
                    do {
                        this.read += this.playAis.read(this.buffers[currSdlBuf], this.read, (int)toRead - this.read);
                    } while (this.read >= 0 && (long)this.read < toRead);
                    this.playAisPos += (long)(this.read / this.frameSize);
                }
                catch (Exception e) {
                    System.err.println("Cannot read " + e);
                    return;
                }
            }
            if (this.read <= 0) continue;
            this.toWrite = this.read;
            while (this.toWrite > 0 && (this.ps.getStatus() == "Playing" || this.ps.getStatus() == "Pause")) {
                this.ps.waitForNot("Pause");
                this.wrote = this.line.write(this.buffers[currSdlBuf], this.read - this.toWrite, this.toWrite);
                this.toWrite -= this.wrote;
            }
            this.peakDetector.process(this.buffers[currSdlBuf], 0, this.read);
            float[] levels = this.peakDetector.getPeakLevels();
            float[] levelsCopy = new float[levels.length];
            for (int i = 0; i < levels.length; ++i) {
                levelsCopy[i] = levels[i];
            }
            BufferLevel bufLevel = new BufferLevel();
            bufLevel.framePos = this.statisticPos;
            bufLevel.length = this.read / this.frameSize;
            bufLevel.peakLevels = levelsCopy;
            this.peaks.add(bufLevel);
            this.statisticPos = this.playAisPos - (long)(this.read / this.frameSize);
        }
        PlayerStatus playerStatus = this.ps;
        synchronized (playerStatus) {
            if (this.ps.getStatus() == "Pause flushing") {
                this.line.flush();
                this.ps.setStatus("Flushed");
                return;
            }
            if (this.ps.getStatus() == "Playing") {
                this.lineStatus.waitFor("Started", 1000);
                if (this.lineStatus.getStatus() == "Started") {
                    this.lineStatus.setStatus("Draining");
                    this.ps.setStatus("Draining");
                    this.line.drain();
                    this.line.stop();
                }
            }
            this.line.flush();
            this.posIsSynced = true;
            try {
                if (this.playAis != null) {
                    this.playAis.close();
                }
            }
            catch (IOException e) {
                System.err.println("Cannot close audio input stream " + e);
            }
            this.ps.setStatus("Idle");
        }
        if (this.ps.getStatus() == "Idle") {
            this.pbl.update(this, this.ps);
        }
        this.resetLevels();
    }

    public AudioFormat getAudioFormat() {
        return this.format;
    }

    private void log(String msg) {
        System.out.println(this.getClass().getName() + ": " + msg);
    }

    public long getStartFramePosition() {
        return this.startPosition;
    }

    public long getStopFramePosition() {
        return this.stopPosition;
    }

    private class BufferLevel {
        public long framePos;
        public int length;
        public float[] peakLevels;
    }

    public class PlayerStatus
    extends SynchronizedStatus {
        public static final String IDLE = "Idle";
        public static final String PREPARING = "Preparing";
        public static final String PREPARED = "Prepared";
        public static final String PLAYING = "Playing";
        public static final String PAUSE = "Pause";
        public static final String PAUSE_FLUSHING = "Pause flushing";
        public static final String FLUSHED = "Flushed";
        public static final String DRAINING = "Draining";
        public static final String STOP = "Stop";

        public PlayerStatus(String status) {
            super(status);
        }
    }
}

