/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.mixer.ui;

import ipsk.audio.mixer.MixerManager;
import ipsk.audio.mixer.MixerManagerListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MixerManagerUI
extends JPanel
implements MixerManagerListener {
    protected JComboBox playbackSelect;
    protected JComboBox captureSelect;
    Mixer.Info defaultPlayback;
    Mixer.Info defaultCapture;

    public MixerManagerUI(MixerManager mm) throws LineUnavailableException {
        super(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(2, 5, 2, 5);
        c.anchor = 19;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        Mixer.Info[] infos = mm.getPlaybackMixerInfos();
        this.defaultPlayback = new DefaultMixerInfo(true);
        Mixer.Info[] mifs = new Mixer.Info[infos.length + 1];
        mifs[0] = this.defaultPlayback;
        for (int i = 0; i < infos.length; ++i) {
            mifs[i + 1] = infos[i];
        }
        this.playbackSelect = new JComboBox<Mixer.Info>(mifs);
        Mixer selPlaybackMixer = mm.getSelectedPlaybackMixer();
        if (selPlaybackMixer != null) {
            this.playbackSelect.setSelectedItem(selPlaybackMixer.getMixerInfo());
        } else {
            this.playbackSelect.setSelectedItem(this.defaultPlayback);
        }
        JLabel playbackSelectLabel = new JLabel("Playback mixer:");
        this.add((Component)playbackSelectLabel, c);
        ++c.gridx;
        this.add((Component)this.playbackSelect, c);
        c.gridx = 0;
        ++c.gridy;
        Mixer.Info[] cinfos = mm.getCaptureMixerInfos();
        this.defaultCapture = new DefaultMixerInfo(false);
        Mixer.Info[] cmifs = new Mixer.Info[cinfos.length + 1];
        cmifs[0] = this.defaultCapture;
        for (int i = 0; i < cinfos.length; ++i) {
            cmifs[i + 1] = cinfos[i];
        }
        this.captureSelect = new JComboBox<Mixer.Info>(cmifs);
        Mixer selCaptureMixer = mm.getSelectedCaptureMixer();
        if (selCaptureMixer != null) {
            this.captureSelect.setSelectedItem(selCaptureMixer.getMixerInfo());
        } else {
            this.captureSelect.setSelectedItem(this.defaultCapture);
        }
        this.add((Component)new JLabel("Capture mixer:"), c);
        ++c.gridx;
        this.add((Component)this.captureSelect, c);
        mm.addMixerManagerListener(this);
    }

    @Override
    public void selectedPlaybackMixerChanged(Object src, Mixer newPlaybackMixer) {
        if (newPlaybackMixer == null) {
            this.playbackSelect.setSelectedItem(this.defaultPlayback);
        } else {
            this.playbackSelect.setSelectedItem(newPlaybackMixer.getMixerInfo());
        }
    }

    @Override
    public void selectedCaptureMixerChanged(Object src, Mixer newCaptureMixer) {
        if (newCaptureMixer == null) {
            this.captureSelect.setSelectedItem(this.defaultCapture);
        } else {
            this.captureSelect.setSelectedItem(newCaptureMixer.getMixerInfo());
        }
    }

    public Mixer.Info getSelectedPlaybackMixerInfo() {
        Mixer.Info selInfo = (Mixer.Info)this.playbackSelect.getSelectedItem();
        if (selInfo.equals(this.defaultPlayback)) {
            return null;
        }
        return selInfo;
    }

    public Mixer.Info getSelectedCaptureMixerInfo() {
        Mixer.Info selInfo = (Mixer.Info)this.captureSelect.getSelectedItem();
        if (selInfo.equals(this.defaultCapture)) {
            return null;
        }
        return selInfo;
    }

    protected class DefaultMixerInfo
    extends Mixer.Info {
        public DefaultMixerInfo(boolean isSource) {
            super("Default " + (isSource ? "playback" : "capture") + " mixer", "", "Default mixer selected by operating system.", "");
        }
    }
}

