/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.ui;

import ipsk.audio.dsp.LevelInfo;
import ipsk.audio.dsp.LevelInfosBean;
import ipsk.audio.view.AudioStatus;
import ipsk.audio.view.LevelDisplay;
import ipsk.awt.JScale;
import ipsk.swing.JAutoScale;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class LevelMeter
extends JPanel
implements ActionListener,
PropertyChangeListener {
    static final boolean DEBUG = false;
    public static final String ACTION_PEAK_HOLD_RESET_CMD = "Reset peak hold";
    private JLabel scaleLabel;
    private JComboBox resButt;
    private int nrChannels;
    private LevelInfosBean levelInfosBean;
    private LevelDisplay[] ld;
    private boolean useIntervalPeakLevel = false;
    private JPanel levels;
    private JButton peakResButt;
    private JAutoScale scale;
    private float minLevelIndB;
    private float DEFAULT_MIN_LEVEL = -60.0f;
    private float[] scaleResolutions = new float[]{-100.0f, -80.0f, -60.0f, -40.0f, -20.0f};
    private Float[] scaleRes;
    private boolean scaleEnabled = false;
    private Vector<ActionListener> listeners;
    private ResourceBundle rb;
    private float transparency = 1.0f;
    private AudioStatus as;
    private boolean showCaptureLevel = true;
    private JCheckBoxMenuItem showCaptureLvlChBx;
    private JPopupMenu menu;

    public LevelMeter() {
        String packageName = this.getClass().getPackage().getName();
        this.rb = ResourceBundle.getBundle(packageName + ".ResBundle");
        this.listeners = new Vector();
        this.minLevelIndB = this.DEFAULT_MIN_LEVEL;
        this.scaleRes = new Float[this.scaleResolutions.length];
        for (int i = 0; i < this.scaleResolutions.length; ++i) {
            this.scaleRes[i] = new Float(this.scaleResolutions[i]);
        }
        this.resButt = new JComboBox<Float>(this.scaleRes);
        this.resButt.setSelectedIndex(2);
        this.resButt.addActionListener(this);
        this.levels = new JPanel();
        this.nrChannels = 2;
        this.as = new AudioStatus();
        this.create();
    }

    public void setAudioFormat(AudioFormat af) {
        this.nrChannels = af == null ? 1 : af.getChannels();
        this.create();
    }

    private void create() {
        this.levels.removeAll();
        this.removeAll();
        this.levels.setLayout(new GridLayout(1, this.nrChannels + 1));
        this.scale = new JAutoScale(JScale.Orientation.WEST, 0L, (long)(-this.minLevelIndB) - 1L);
        this.scale.setEnabled(false);
        this.levels.add((Component)this.scale);
        this.ld = new LevelDisplay[this.nrChannels];
        for (int ch = 0; ch < this.nrChannels; ++ch) {
            this.ld[ch] = new LevelDisplay(this.minLevelIndB);
            this.ld[ch].setUseIntervalPeakLevel(this.useIntervalPeakLevel);
            this.levels.add(this.ld[ch]);
        }
        this.setTransparency(this.transparency);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gcLevels = new GridBagConstraints();
        gcLevels.gridx = 0;
        gcLevels.gridy = 0;
        gcLevels.fill = 1;
        gcLevels.weighty = 1.0;
        gcLevels.gridwidth = 2;
        this.add((Component)this.levels, gcLevels);
        JPanel legend = new JPanel(new GridLayout(1, this.nrChannels + 1));
        this.scaleLabel = new JLabel("-dB");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        constraints.fill = 2;
        constraints.gridwidth = 2;
        legend.add(this.scaleLabel);
        for (int i = 0; i < this.nrChannels; ++i) {
            legend.add(new JLabel(""));
        }
        this.add((Component)legend, constraints);
        constraints.gridy = 2;
        this.add((Component)this.resButt, constraints);
        this.peakResButt = new JButton("R");
        this.peakResButt.setToolTipText(this.rb.getString("reset"));
        this.peakResButt.addActionListener(this);
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        this.add((Component)this.peakResButt, constraints);
        ++constraints.gridx;
        this.add((Component)this.as, constraints);
        this.setScaleEnabled(this.scaleEnabled);
        this.revalidate();
        this.repaint();
    }

    private void createPopuMenu() {
        this.menu = new JPopupMenu();
        this.showCaptureLvlChBx = new JCheckBoxMenuItem("Show level during recording pauses");
        this.showCaptureLvlChBx.setSelected(true);
        this.menu.add(this.showCaptureLvlChBx);
        this.showCaptureLvlChBx.addActionListener(this);
        this.setComponentPopupMenu(this.menu);
    }

    public void setAudioStatus(AudioStatus.Status status) {
        this.as.setStatus(status);
        if (this.menu == null) {
            this.createPopuMenu();
        }
        this.updateActivation();
    }

    public float getTransparency() {
        return this.transparency;
    }

    public void setTransparency(float transparency) {
        this.transparency = transparency;
        if (this.ld != null) {
            for (LevelDisplay l : this.ld) {
                l.setTransparency(transparency);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.peakResButt) {
            this.resetPeakHold();
            ActionEvent peakResetAction = new ActionEvent(this, 1001, ACTION_PEAK_HOLD_RESET_CMD);
            this.updateListeners(peakResetAction);
        } else if (ae.getSource() == this.resButt) {
            int i;
            this.minLevelIndB = ((Float)this.resButt.getSelectedItem()).floatValue();
            float[] savePeak = new float[this.nrChannels];
            for (i = 0; i < this.nrChannels; ++i) {
                savePeak[i] = this.ld[i].getPeakHold();
            }
            this.create();
            for (i = 0; i < this.nrChannels; ++i) {
                this.ld[i].setPeakHold(savePeak[i]);
            }
        } else if (ae.getSource() == this.showCaptureLvlChBx) {
            this.updateActivation();
        }
    }

    private void updateActivation() {
        if (this.as != null && AudioStatus.Status.CAPTURE.equals((Object)this.as.getStatus())) {
            this.setActive(this.showCaptureLvlChBx.isSelected());
        } else {
            this.setActive(true);
        }
    }

    public void setScaleEnabled(boolean enabled) {
        this.scaleEnabled = enabled;
        this.scale.setEnabled(enabled);
        this.scaleLabel.setEnabled(enabled);
    }

    private void setActive(boolean active) {
        for (LevelDisplay l : this.ld) {
            l.setActive(active);
        }
    }

    public void abandonDecay() {
        if (this.ld != null) {
            for (LevelDisplay l : this.ld) {
                l.abandonDecay();
            }
        }
    }

    public void resetPeakHold() {
        for (int ch = 0; ch < this.nrChannels; ++ch) {
            this.ld[ch].resetPeakHold();
        }
    }

    public void setLevels(float[] levels) {
        for (int ch = 0; ch < this.nrChannels; ++ch) {
            if (levels == null || levels.length <= ch) {
                this.ld[ch].setLevel(0.0f);
                continue;
            }
            this.ld[ch].setLevel(levels[ch]);
        }
    }

    public void setLevelInfos(LevelInfo[] levelInfos) {
        this.setLevelInfos(levelInfos, false);
    }

    public void setLevelInfos(LevelInfo[] levelInfos, boolean listenToPropertyChanges) {
        for (int ch = 0; ch < this.nrChannels; ++ch) {
            if (levelInfos == null || levelInfos.length <= ch) {
                this.ld[ch].setLevelInfo(new LevelInfo(), listenToPropertyChanges);
                continue;
            }
            this.ld[ch].setLevelInfo(levelInfos[ch], listenToPropertyChanges);
        }
    }

    public void setLevelInfosBean(LevelInfosBean levelInfosBean) {
        if (this.levelInfosBean != null) {
            this.levelInfosBean.removePropertyChangeListener(this);
        }
        this.levelInfosBean = levelInfosBean;
        if (this.levelInfosBean != null) {
            this.setLevelInfos(this.levelInfosBean.getLevelInfos(), true);
            this.levelInfosBean.addPropertyChangeListener(this);
        }
    }

    public LevelInfosBean getLevelInfosBean() {
        return this.levelInfosBean;
    }

    public boolean isUseIntervalPeakLevel() {
        return this.useIntervalPeakLevel;
    }

    public void setUseIntervalPeakLevel(boolean useIntervalPeakLevel) {
        this.useIntervalPeakLevel = useIntervalPeakLevel;
        if (this.ld != null) {
            for (LevelDisplay l : this.ld) {
                l.setUseIntervalPeakLevel(useIntervalPeakLevel);
            }
        }
    }

    public synchronized void addActionListener(ActionListener actionEvent) {
        if (actionEvent != null && !this.listeners.contains(actionEvent)) {
            this.listeners.addElement(actionEvent);
        }
    }

    public synchronized void removeActionListener(ActionListener actionEvent) {
        if (actionEvent != null) {
            this.listeners.removeElement(actionEvent);
        }
    }

    protected synchronized void updateListeners(ActionEvent actionEvent) {
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(actionEvent);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setLevelInfos(this.levelInfosBean.getLevelInfos(), true);
    }

    public static void main(String[] args) {
        final LevelMeter lm = new LevelMeter();
        Runnable sr = new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame();
                f.getContentPane().add(lm);
                f.pack();
                f.setVisible(true);
            }
        };
        SwingUtilities.invokeLater(sr);
        LevelInfo[] lifs = new LevelInfo[]{new LevelInfo(0.3f, 0.9f)};
        lm.setLevelInfos(lifs);
    }
}

