/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.arr.clip.ui;

import ips.media.MediaLengthUnit;
import ipsk.audio.arr.Selection;
import ipsk.audio.arr.clip.AudioClip;
import ipsk.audio.arr.clip.events.AudioClipChangedEvent;
import ipsk.audio.arr.clip.events.AudioSourceChangedEvent;
import ipsk.audio.arr.clip.events.FramePositionChangedEvent;
import ipsk.audio.arr.clip.events.SelectionChangedEvent;
import ipsk.audio.arr.clip.ui.AudioClipUI;
import ipsk.audio.arr.clip.ui.BasicAudioClipUI;
import ipsk.awt.TickProvider;
import ipsk.swing.JAutoScale;
import ipsk.swing.action.tree.ActionTreeRoot;
import ipsk.util.LocalizableMessage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.ActionListener;
import java.text.Format;
import javax.swing.JComponent;
import javax.swing.JMenu;

public class AudioTimeScaleUI
extends JAutoScale
implements AudioClipUI {
    private BasicAudioClipUI basicSampleUI;
    private int pixelPosition;

    public AudioTimeScaleUI() {
        this.setBackground(Color.BLACK);
        this.setOpaque(false);
        this.setForeground(Color.YELLOW.darker());
        this.basicSampleUI = new BasicAudioClipUI();
    }

    @Override
    public String getName() {
        return "Audio time scale";
    }

    @Override
    public LocalizableMessage getLocalizableName() {
        return new LocalizableMessage(this.getName());
    }

    @Override
    public void setTimeFormat(Format timeFormat) {
        this.basicSampleUI.setTimeFormat(timeFormat);
        this.setLabelFormat(timeFormat);
        this.rescale();
    }

    private void rescale() {
        if (MediaLengthUnit.TIME.equals((Object)this.basicSampleUI.mediaLengthUnit)) {
            this.setLabelFormat(this.basicSampleUI.getTimeFormat());
            this.setScaleEnd((long)(this.basicSampleUI.lengthInSeconds * 1.0E9));
        } else {
            this.setLabelFormat(null);
            this.setScaleEnd(this.basicSampleUI.length);
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension scaleSize = super.getMinimumSize();
        int y = this.getHeight() - scaleSize.height;
        int polyHeight = scaleSize.height / 2;
        if (this.basicSampleUI.selection != null) {
            g.setColor(Color.YELLOW);
            long frameLeft = this.basicSampleUI.selection.getLeft();
            int leftX = this.mapFramePosToPixel(frameLeft);
            Polygon poSelL = new Polygon(new int[]{leftX - polyHeight / 2, leftX, leftX}, new int[]{y + polyHeight, y + polyHeight, y}, 3);
            long frameRight = this.basicSampleUI.selection.getRight();
            int rightX = this.mapFramePosToPixel(frameRight);
            Polygon poSelR = new Polygon(new int[]{rightX, rightX + polyHeight / 2, rightX}, new int[]{y + polyHeight, y + polyHeight, y}, 3);
            g.fillPolygon(poSelL);
            g.fillPolygon(poSelR);
        }
        Polygon po = new Polygon(new int[]{this.pixelPosition - polyHeight / 2, this.pixelPosition + polyHeight / 2, this.pixelPosition}, new int[]{y + polyHeight, y + polyHeight, y}, 3);
        g.setColor(Color.RED);
        g.fillPolygon(po);
    }

    private int mapFramePosToPixel(long framePos) {
        double pixelsPerFrame = 0.0;
        if (this.basicSampleUI.length > 0L) {
            pixelsPerFrame = (double)this.getWidth() / (double)this.basicSampleUI.length;
        }
        return (int)((double)framePos * pixelsPerFrame);
    }

    private void setFramePosition(long position) {
        int oldPixelPosition = this.pixelPosition;
        double pixelsPerFrame = 0.0;
        if (this.basicSampleUI.length > 0L) {
            pixelsPerFrame = (double)this.getWidth() / (double)this.basicSampleUI.length;
        }
        this.pixelPosition = (int)((double)position * pixelsPerFrame);
        Dimension scaleSize = super.getMinimumSize();
        int h = scaleSize.height;
        int y = this.getHeight() - h;
        int polywidth = scaleSize.height / 2;
        if (EventQueue.isDispatchThread()) {
            this.paintImmediately(oldPixelPosition - polywidth / 2, y, polywidth, h);
            this.paintImmediately(this.pixelPosition - polywidth / 2, y, polywidth, h);
        } else {
            this.repaint(oldPixelPosition - polywidth / 2, y, polywidth, h);
            this.repaint(this.pixelPosition - polywidth / 2, y, polywidth, h);
        }
    }

    @Override
    public void setAudioSample(AudioClip audiosample) {
        this.basicSampleUI.setAudioSample(audiosample);
        if (audiosample != null) {
            audiosample.addAudioSampleListener(this);
        }
        this.rescale();
    }

    @Override
    public void audioClipChanged(AudioClipChangedEvent event) {
        this.basicSampleUI.audioClipChanged(event);
        if (event instanceof FramePositionChangedEvent) {
            this.setFramePosition(((FramePositionChangedEvent)event).getPosition());
        } else if (event instanceof SelectionChangedEvent) {
            SelectionChangedEvent sEv = (SelectionChangedEvent)event;
            Selection selection = sEv.getSelection();
        } else if (event instanceof AudioSourceChangedEvent) {
            this.rescale();
        } else if (event instanceof SelectionChangedEvent) {
            // empty if block
        }
    }

    @Override
    public void addActionListener(ActionListener containerUI) {
    }

    @Override
    public void removeActionListener(ActionListener containerUI) {
    }

    public void setTimeScaleTickProvider(TickProvider timeScaleTickProvider) {
    }

    public JComponent getControlJComponent() {
        return null;
    }

    public JMenu[] getJMenus() {
        return new JMenu[0];
    }

    @Override
    public void close() {
    }

    @Override
    public JComponent[] getYScales() {
        return new JComponent[0];
    }

    @Override
    public void setMediaLengthUnit(MediaLengthUnit mediaLengthUnit) {
        this.basicSampleUI.setMediaLengthUnit(mediaLengthUnit);
        this.rescale();
    }

    public ActionTreeRoot getActionTreeRoot() {
        return null;
    }

    @Override
    public void showJControlDialog(Component parentComponent) {
    }

    @Override
    public boolean hasControlDialog() {
        return false;
    }

    @Override
    public boolean isPreferredFixedHeight() {
        return true;
    }

    @Override
    public Component asComponent() {
        return this;
    }
}

