/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.arr.clip.ui;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioSourceException;
import ipsk.audio.arr.clip.AudioClip;
import ipsk.audio.arr.clip.AudioClipListener;
import ipsk.audio.arr.clip.events.AudioClipChangedEvent;
import ipsk.audio.arr.clip.events.AudioSourceChangedEvent;
import ipsk.audio.arr.clip.events.FramePositionChangedEvent;
import ipsk.audio.arr.clip.ui.BasicAudioClipUI;
import ipsk.audio.arr.clip.ui.FourierRenderer;
import ipsk.audio.arr.clip.ui.FourierRendererEvent;
import ipsk.audio.arr.clip.ui.FourierRendererListener;
import ipsk.awt.GridTick;
import ipsk.awt.JScale;
import ipsk.swing.JDialogPanel;
import ipsk.swing.scale.JDecimalAutoScale;
import ipsk.swing.scale.JMinimalScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.math.BigDecimal;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.Scrollable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FourierUI
extends BasicAudioClipUI
implements Scrollable,
MouseListener,
MouseMotionListener,
AudioClipListener,
FourierRendererListener {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_SELECTOR_WIDTH = 3;
    private final boolean DEBUG = false;
    private final Color DEFAULT_SIGNAL_COLOR = Color.GREEN;
    private final int DEFAULT_N = 512;
    private final double DEFAULT_WINDOW_SIZE = 0.005;
    private boolean rendered = false;
    private int imgHeight;
    private MouseEvent pressedEvent = null;
    private MouseEvent dragStartEvent = null;
    private MouseEvent selEndMoveEvent;
    private MouseEvent selStartMoveEvent;
    private MouseEvent mouseOverResizeWest;
    private MouseEvent mouseOverResizeEast;
    private int preferredHeight = 100;
    private boolean imgHeightSet = false;
    private JScale<BigDecimal>[] yScales;
    private JPanel yScalesComponent;
    private FourierRenderer renderer;
    private int dftLength = 512;
    private Double maxFrequency = null;
    public static double DEFAULT_EMPHASIS_START_FREQUENCY = 1000.0;
    private double emphasisStartFrequency = DEFAULT_EMPHASIS_START_FREQUENCY;
    private double emphasisPerOctaveDB = 0.0;
    private double windowSize = 0.005;
    private double dynamicRangeDB = 50.0;
    private boolean useThread = false;
    private FourierControlUI controlComponent;
    private int selectorWidth = 3;

    public int getDftLength() {
        return this.dftLength;
    }

    public void setDftLength(int dftLength) {
        this.dftLength = dftLength;
        this.rerender();
    }

    public FourierUI() {
        this.pixelPosition = 0;
        this.setBackground(Color.BLACK);
        this.listenerList = new Vector();
        this.yScalesComponent = new JPanel();
        this.yScalesComponent.setLayout(null);
        this.controlComponent = new FourierControlUI();
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public FourierUI(AudioClip audioSample) throws AudioFormatNotSupportedException, AudioSourceException {
        this();
        this.setAudioSample(audioSample);
    }

    @Override
    public String getName() {
        return "Sonagram";
    }

    public void setImgHeight(int imgHeight) {
        this.imgHeight = imgHeight;
        this.imgHeightSet = true;
    }

    public void clear() {
        this.clearScreen();
    }

    public void clearScreen() {
        this.setCursor();
        this.repaint();
    }

    private void updateYScales() {
        this.yScalesComponent.removeAll();
        if (this.audioSource != null) {
            double maxFreq = this.getMaxFrequency();
            this.yScales = new JScale[this.channels];
            for (int i = 0; i < this.yScales.length; ++i) {
                this.yScales[i] = new JMinimalScale(JScale.Orientation.WEST, "Hz", BigDecimal.valueOf(maxFreq), BigDecimal.valueOf(0L));
                this.yScalesComponent.add((Component)this.yScales[i]);
            }
        }
        this.revalidate();
    }

    @Override
    public void audioClipChanged(AudioClipChangedEvent event) {
        super.audioClipChanged(event);
        if (event instanceof FramePositionChangedEvent) {
            this.setFramePosition(((FramePositionChangedEvent)event).getPosition());
        } else if (event instanceof AudioSourceChangedEvent) {
            this.clear();
            this.audioSource = ((AudioSourceChangedEvent)event).getAudioSource();
            if (this.audioSource != null) {
                try {
                    if (this.renderer != null) {
                        this.renderer.close();
                    }
                    this.renderer = new FourierRenderer(this.audioSource, this);
                }
                catch (AudioFormatNotSupportedException e) {
                    JOptionPane.showMessageDialog(this, "Audio format not supported\n" + e.getLocalizedMessage(), "Audio signal renderer", 1);
                    e.printStackTrace();
                }
                catch (AudioSourceException e) {
                    JOptionPane.showMessageDialog(this, "Audio source error: \n" + e.getLocalizedMessage(), "Audio signal renderer error", 0);
                    e.printStackTrace();
                }
            }
            this.updateYScales();
            this.controlComponent.updateValues();
        }
    }

    @Override
    public double getLengthInSeconds() {
        return this.lengthInSeconds;
    }

    private void setCursor() {
        Container parent = this.getParent();
        if (parent != null) {
            if (this.dragStartEvent != null) {
                if (this.dragStartEvent == this.selStartMoveEvent) {
                    parent.setCursor(Cursor.getPredefinedCursor(10));
                } else if (this.dragStartEvent == this.selStartMoveEvent) {
                    parent.setCursor(Cursor.getPredefinedCursor(11));
                }
            } else if (this.mouseOverResizeWest != null) {
                parent.setCursor(Cursor.getPredefinedCursor(10));
            } else if (this.mouseOverResizeEast != null) {
                parent.setCursor(Cursor.getPredefinedCursor(11));
            } else if (this.rendered) {
                parent.setCursor(Cursor.getPredefinedCursor(0));
            } else {
                parent.setCursor(Cursor.getPredefinedCursor(3));
            }
        }
    }

    @Override
    public void printComponent(Graphics g) {
        super.printComponent(g);
        this._paintOrPrintComponent(g, false, true);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this._paintOrPrintComponent(g, this.useThread, false);
    }

    private void _paintOrPrintComponent(Graphics g, boolean useThread, boolean printMode) {
        Rectangle clipBounds = g.getClipBounds();
        if (this.audioSample == null || this.audioSample.getAudioSource() == null || this.channels == 0 || this.pixelsPerFrame == 0.0 || this.renderer == null) {
            return;
        }
        FontMetrics gf = g.getFontMetrics();
        int fontHeight = gf.getHeight();
        int height = this.getHeight();
        if (height <= 0) {
            return;
        }
        this.imgHeight = height / this.channels;
        int paintFrom = clipBounds.x - (int)this.pixelsPerFrame - 1;
        if (paintFrom < 0) {
            paintFrom = 0;
        }
        int paintTo = clipBounds.x + clipBounds.width + (int)this.pixelsPerFrame + 1;
        this.setCursor();
        FourierRenderer.RenderResult rr = null;
        try {
            double maxDftFreq = this.dftLength / 2;
            if (this.maxFrequency != null) {
                maxDftFreq = (double)this.dftLength * (this.maxFrequency / (double)this.sampleRate);
            }
            int discretWindowSize = (int)((double)this.sampleRate * this.windowSize);
            if (this.emphasisPerOctaveDB != 0.0 && this.emphasisStartFrequency > 0.0 && this.emphasisStartFrequency < (double)(this.sampleRate / 2.0f)) {
                double dftEmphasisStartFreq = (double)this.dftLength * this.emphasisStartFrequency / (double)(2.0f * this.sampleRate);
                rr = this.renderer.render(paintFrom, paintTo, this.imgHeight, maxDftFreq, this.framesPerPixel, this.dftLength, discretWindowSize, this.dynamicRangeDB, this.emphasisPerOctaveDB, dftEmphasisStartFreq, useThread);
            } else {
                rr = this.renderer.render(paintFrom, paintTo, this.imgHeight, maxDftFreq, this.framesPerPixel, this.dftLength, discretWindowSize, this.dynamicRangeDB, useThread);
            }
        }
        catch (AudioSourceException e) {
            e.printStackTrace();
        }
        this.rendered = rr.rendered;
        this.setCursor();
        g.setColor(this.DEFAULT_SIGNAL_COLOR);
        int availPaintTo = paintFrom + rr.renderedLength;
        if (availPaintTo > paintTo) {
            availPaintTo = paintTo;
        }
        if (rr.renderedImages != null && rr.renderedImages.length > 0) {
            for (int ii = 0; ii < rr.renderedImages.length; ++ii) {
                int y = this.imgHeight * ii;
                boolean painted = g.drawImage(rr.renderedImages[ii], paintFrom, y, availPaintTo, this.imgHeight + y, paintFrom - rr.pixelOffset, 0, availPaintTo - rr.pixelOffset, this.imgHeight, this);
                if (painted) continue;
            }
        }
        if (this.showTimeScaleGrid) {
            GridTick[] ticks = null;
            if (this.timeScaleTickProvider != null) {
                ticks = this.timeScaleTickProvider.getScaleTicks(clipBounds.x, clipBounds.x + clipBounds.width);
            }
            if (ticks != null) {
                g.setColor(this.DEFAULT_TIME_GRID_COLOR);
                for (GridTick gt : ticks) {
                    int gtPos = gt.getPosition();
                    g.drawLine(gtPos, 0, gtPos, height);
                }
            }
        }
        if (this.viewSelection != null) {
            g.setColor(Color.YELLOW);
            int pixelPos = this.viewSelection.getXStart();
            g.drawLine(pixelPos, 0, pixelPos, height);
            String startStr = this.formatPosition(this.viewSelection.getStart());
            String endStr = this.formatPosition(this.viewSelection.getEnd());
            g.drawString(startStr, pixelPos, height - fontHeight);
            pixelPos = this.viewSelection.getXEnd();
            g.drawLine(pixelPos, 0, pixelPos, height);
            g.drawString(endStr, pixelPos, height - fontHeight);
        }
        if (!printMode) {
            g.setColor(Color.RED);
            g.drawLine(this.pixelPosition, 0, this.pixelPosition, height);
            this.setCursor();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.getWidth(), 200);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.imgHeightSet) {
            return new Dimension(this.getWidth(), this.imgHeight);
        }
        return new Dimension(this.getWidth(), this.preferredHeight);
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle arg0, int arg1, int arg2) {
        return 50;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle arg0, int arg1, int arg2) {
        return 1;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    private boolean isInSelectorStart(int x) {
        int xStart = this.viewSelection.getXStart();
        return x >= xStart - this.selectorWidth && x <= xStart + this.selectorWidth;
    }

    private boolean isInSelectorEnd(int x) {
        int xEnd = this.viewSelection.getXEnd();
        return x >= xEnd - this.selectorWidth && x <= xEnd + this.selectorWidth;
    }

    private boolean isInSelectorLeft(int x) {
        int xLeft = this.viewSelection.getXLeft();
        return x >= xLeft - this.selectorWidth && x <= xLeft + this.selectorWidth;
    }

    private boolean isInSelectorRight(int x) {
        int xRight = this.viewSelection.getXRight();
        return x >= xRight - this.selectorWidth && x <= xRight + this.selectorWidth;
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        long newSamplePosition = this.mapPixelToFrame(arg0.getX());
        this.audioSample.setFramePosition(newSamplePosition);
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        this.dragStartEvent = null;
        this.pressedEvent = null;
        this.selStartMoveEvent = null;
        this.selEndMoveEvent = null;
        if (arg0.isPopupTrigger()) {
            Container parent = this.getParent();
            if (parent != null) {
                parent.dispatchEvent(arg0);
            }
        } else {
            int x = arg0.getX();
            if (this.viewSelection != null) {
                if (this.isInSelectorStart(x)) {
                    this.selStartMoveEvent = arg0;
                } else if (this.isInSelectorEnd(x)) {
                    this.selEndMoveEvent = arg0;
                } else {
                    this.pressedEvent = arg0;
                }
                this.repaint();
            } else {
                this.pressedEvent = arg0;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        if (arg0.isPopupTrigger()) {
            this.getParent().dispatchEvent(arg0);
        } else if (this.dragStartEvent != null && this.viewSelection != null) {
            this.viewSelection.limitTo(0L, this.length);
            this.audioSample.setSelection(this.viewSelection.getSelection());
            this.repaint();
        }
        this.dragStartEvent = null;
        this.checkMouseResizeSelection(arg0);
    }

    @Override
    public synchronized void mouseDragged(MouseEvent arg0) {
        if (this.pressedEvent != null) {
            this.dragStartEvent = this.pressedEvent;
            if (this.viewSelection == null) {
                this.viewSelection = new BasicAudioClipUI.ViewSelection(this);
            }
            int dragStart = this.dragStartEvent.getX();
            this.viewSelection.setXStart(dragStart);
            int dragEnd = arg0.getX();
            int oldDragEnd = this.viewSelection.getXEnd();
            this.repaint(oldDragEnd, 0, 1, this.getHeight());
            this.viewSelection.setXEnd(dragEnd);
            this.repaint(dragStart - 1, 0, 3, this.getHeight());
            this.repaint(dragEnd, 0, 1, this.getHeight());
        } else if (this.selStartMoveEvent != null) {
            this.dragStartEvent = this.selStartMoveEvent;
            this.viewSelection.setXStart(arg0.getX());
            this.setCursor();
            this.repaint();
        } else if (this.selEndMoveEvent != null) {
            this.dragStartEvent = this.selEndMoveEvent;
            this.viewSelection.setXEnd(arg0.getX());
            this.setCursor();
            this.repaint();
        }
    }

    private void checkMouseResizeSelection(MouseEvent arg0) {
        int x = arg0.getX();
        if (this.viewSelection != null) {
            if (this.isInSelectorLeft(x)) {
                this.mouseOverResizeEast = null;
                this.mouseOverResizeWest = arg0;
            } else if (this.isInSelectorRight(x)) {
                this.mouseOverResizeEast = arg0;
                this.mouseOverResizeWest = null;
            } else {
                this.mouseOverResizeEast = null;
                this.mouseOverResizeWest = null;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
        this.checkMouseResizeSelection(arg0);
        this.setCursor();
    }

    @Override
    public JComponent[] getYScales() {
        return new JComponent[]{this.yScalesComponent};
    }

    @Override
    public synchronized void addActionListener(ActionListener acl) {
        if (acl != null && !this.listenerList.contains(acl)) {
            this.listenerList.addElement(acl);
        }
    }

    @Override
    public synchronized void removeActionListener(ActionListener acl) {
        if (acl != null) {
            this.listenerList.removeElement(acl);
        }
    }

    protected synchronized void updateListeners(ActionEvent ae) {
        for (ActionListener listener : this.listenerList) {
            listener.actionPerformed(ae);
        }
    }

    protected void rerender() {
        this.updateYScales();
        this.invalidate();
        this.validate();
        this.repaint();
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.clear();
        if (this.yScales != null && this.yScales.length > 0) {
            int sW;
            JScale<BigDecimal> yScale;
            int i;
            int compH = this.getSize().height;
            int scaleHeight = compH / this.yScales.length;
            int scaleWidth = 0;
            for (i = 0; i < this.yScales.length; ++i) {
                yScale = this.yScales[i];
                if (yScale == null) continue;
                if (yScale instanceof JDecimalAutoScale) {
                    ((JDecimalAutoScale)yScale).setLength(scaleHeight);
                }
                Dimension scalePrefSize = yScale.getPreferredSize();
                sW = scalePrefSize.width;
                if (sW > scaleWidth) {
                    scaleWidth = sW;
                }
                yScale.setSize(sW, scaleHeight);
            }
            for (i = 0; i < this.yScales.length; ++i) {
                yScale = this.yScales[i];
                if (yScale == null) continue;
                Dimension ssize = yScale.getSize();
                sW = ssize.width;
                yScale.setLocation(scaleWidth - sW, scaleHeight * i);
            }
            Dimension preferredSize = new Dimension(scaleWidth, compH);
            this.yScalesComponent.setPreferredSize(preferredSize);
            Container yP = this.yScalesComponent.getParent();
            if (yP != null) {
                Container clipCont = yP.getParent();
                if (clipCont != null) {
                    clipCont.invalidate();
                    clipCont.validate();
                }
                yP.invalidate();
                yP.validate();
            }
        }
    }

    @Override
    public void update(FourierRendererEvent event) {
        this.repaint();
    }

    @Override
    public void close() {
        if (this.renderer != null) {
            this.renderer.close();
        }
        super.close();
    }

    public boolean isUseThread() {
        return this.useThread;
    }

    public void setUseThread(boolean useThread) {
        this.useThread = useThread;
    }

    public Double getMaxFrequency() {
        if (this.maxFrequency == null && this.audioSource != null) {
            return (double)this.sampleRate / 2.0;
        }
        return this.maxFrequency;
    }

    public void setMaxFrequency(Double maxFrequency) {
        this.maxFrequency = maxFrequency;
        this.rerender();
    }

    @Override
    public boolean hasControlDialog() {
        return true;
    }

    @Override
    public void showJControlDialog(Component parentComponent) {
        this.controlComponent.showNonModalDialog(null);
    }

    public double getDynamicRangeDB() {
        return this.dynamicRangeDB;
    }

    public void setDynamicRangeDB(double dynamicRangeDB) {
        this.dynamicRangeDB = dynamicRangeDB;
        this.rerender();
    }

    public double getEmphasisPerOctaveDB() {
        return this.emphasisPerOctaveDB;
    }

    public void setEmphasisPerOctaveDB(double emphasisPerOctaveDB) {
        this.emphasisPerOctaveDB = emphasisPerOctaveDB;
        this.rerender();
    }

    public double getEmphasisStartFrequency() {
        return this.emphasisStartFrequency;
    }

    public void setEmphasisStartFrequency(double emphasisStartFrequency) {
        this.emphasisStartFrequency = emphasisStartFrequency;
        this.rerender();
    }

    public double getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(double windowSize) {
        this.windowSize = windowSize;
        this.rerender();
    }

    public class FourierControlUI
    extends JDialogPanel
    implements ChangeListener,
    ActionListener {
        private static final long serialVersionUID = 1L;
        private SpinnerNumberModel windowSizeModel;
        private JSpinner windowSizeSpinner;
        private JComboBox<Integer> dftLengthBox;
        private SpinnerNumberModel maxFrequencySpinnerModel;
        private JSpinner maxFrequencySpinner;
        private SpinnerNumberModel dynamicRangeDbModel;
        private JSpinner dynamicRangeDbSpinner;
        private SpinnerNumberModel emphasisPerOctaveModel;
        private JSpinner emphasisPerOctaveSpinner;
        private JCheckBox autoApplyCheckBox;

        public FourierControlUI() {
            super(JDialogPanel.Options.OK_APPLY_CANCEL);
            GridBagLayout gbl = new GridBagLayout();
            Container ct = this.getContentPane();
            ct.setLayout(gbl);
            double nyquistFreq = 22000.0;
            if (FourierUI.this.audioSource != null) {
                nyquistFreq = (double)FourierUI.this.sampleRate / 2.0;
            }
            double maxFreq = nyquistFreq;
            Double maxFreqSet = FourierUI.this.getMaxFrequency();
            if (maxFreqSet != null) {
                maxFreq = maxFreqSet;
            }
            this.windowSizeModel = new SpinnerNumberModel(FourierUI.this.getWindowSize(), 0.001, 1.0, 0.001);
            this.windowSizeModel.addChangeListener(this);
            this.dftLengthBox = new JComboBox<Integer>(new Integer[]{32, 64, 128, 256, 512, 1024, 2048, 4096, 8192});
            this.dftLengthBox.setSelectedItem(FourierUI.this.dftLength);
            this.dftLengthBox.addActionListener(this);
            this.maxFrequencySpinnerModel = new SpinnerNumberModel(maxFreq, 0.0, nyquistFreq, 1000.0);
            this.maxFrequencySpinnerModel.addChangeListener(this);
            this.dynamicRangeDbModel = new SpinnerNumberModel(FourierUI.this.dynamicRangeDB, 1.0, 120.0, 1.0);
            this.dynamicRangeDbModel.addChangeListener(this);
            this.emphasisPerOctaveModel = new SpinnerNumberModel(FourierUI.this.emphasisPerOctaveDB, 0.0, 96.0, 1.0);
            this.emphasisPerOctaveModel.addChangeListener(this);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 5, 2, 5);
            c.anchor = 18;
            c.fill = 2;
            c.gridx = 0;
            c.gridy = 0;
            JLabel dftLengthLabel = new JLabel("DFT length:");
            ct.add((Component)dftLengthLabel, c);
            ++c.gridx;
            ct.add(this.dftLengthBox, c);
            this.dftLengthBox.addActionListener(this);
            c.gridx = 0;
            ++c.gridy;
            JLabel windowSizeLabel = new JLabel("Window size:");
            ct.add((Component)windowSizeLabel, c);
            ++c.gridx;
            this.windowSizeSpinner = new JSpinner(this.windowSizeModel);
            ct.add((Component)this.windowSizeSpinner, c);
            this.windowSizeModel.addChangeListener(this);
            ++c.gridx;
            JLabel secLabel = new JLabel("s");
            ct.add((Component)secLabel, c);
            c.gridx = 0;
            ++c.gridy;
            JLabel maxFreqLabel = new JLabel("Max. frequency:");
            ct.add((Component)maxFreqLabel, c);
            ++c.gridx;
            this.maxFrequencySpinner = new JSpinner(this.maxFrequencySpinnerModel);
            ct.add((Component)this.maxFrequencySpinner, c);
            this.maxFrequencySpinnerModel.addChangeListener(this);
            ++c.gridx;
            JLabel hzLabel = new JLabel("Hz");
            ct.add((Component)hzLabel, c);
            c.gridx = 0;
            ++c.gridy;
            JLabel dynamicRangeLabel = new JLabel("Dynamic range:");
            ct.add((Component)dynamicRangeLabel, c);
            ++c.gridx;
            this.dynamicRangeDbSpinner = new JSpinner(this.dynamicRangeDbModel);
            ct.add((Component)this.dynamicRangeDbSpinner, c);
            this.dynamicRangeDbModel.addChangeListener(this);
            ++c.gridx;
            JLabel dbLabel = new JLabel("dB");
            ct.add((Component)dbLabel, c);
            c.gridx = 0;
            ++c.gridy;
            JLabel emphasisPerOctaveLabel = new JLabel("Emphasis per Octave:");
            ct.add((Component)emphasisPerOctaveLabel, c);
            ++c.gridx;
            this.emphasisPerOctaveSpinner = new JSpinner(this.emphasisPerOctaveModel);
            ct.add((Component)this.emphasisPerOctaveSpinner, c);
            this.emphasisPerOctaveModel.addChangeListener(this);
            ++c.gridx;
            JLabel dbLabel2 = new JLabel("dB");
            ct.add((Component)dbLabel2, c);
            c.gridx = 0;
            ++c.gridy;
            JLabel autoApplyLabel = new JLabel("Auto apply:");
            ct.add((Component)autoApplyLabel, c);
            ++c.gridx;
            this.autoApplyCheckBox = new JCheckBox();
            this.autoApplyCheckBox.setSelected(false);
            ct.add((Component)this.autoApplyCheckBox, c);
            this.autoApplyCheckBox.addActionListener(this);
        }

        public void updateValues() {
            double nyquistFreq = 22000.0;
            if (FourierUI.this.audioSource != null) {
                nyquistFreq = (double)FourierUI.this.sampleRate / 2.0;
            }
            this.maxFrequencySpinnerModel.setMaximum(Double.valueOf(nyquistFreq));
            Double mf = FourierUI.this.getMaxFrequency();
            if (mf != null) {
                this.maxFrequencySpinnerModel.setValue(mf);
            }
            if ((Double)this.maxFrequencySpinnerModel.getValue() > nyquistFreq) {
                this.maxFrequencySpinnerModel.setValue(nyquistFreq);
            }
            this.windowSizeModel.setValue(FourierUI.this.windowSize);
            this.dftLengthBox.setSelectedItem(FourierUI.this.getDftLength());
            this.dynamicRangeDbModel.setValue(FourierUI.this.dynamicRangeDB);
            this.emphasisPerOctaveModel.setValue(FourierUI.this.emphasisPerOctaveDB);
        }

        public void applyValues() {
            FourierUI.this.setWindowSize((Double)this.windowSizeModel.getValue());
            FourierUI.this.setDftLength((Integer)this.dftLengthBox.getSelectedItem());
            FourierUI.this.setMaxFrequency((Double)this.maxFrequencySpinnerModel.getValue());
            FourierUI.this.setDynamicRangeDB((Double)this.dynamicRangeDbModel.getValue());
            FourierUI.this.setEmphasisPerOctaveDB((Double)this.emphasisPerOctaveModel.getValue());
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            Object src = ce.getSource();
            if ((src == this.windowSizeModel || src == this.maxFrequencySpinnerModel || src == this.dynamicRangeDbModel || src == this.emphasisPerOctaveModel) && this.autoApplyCheckBox.isSelected()) {
                this.applyValues();
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object src = ae.getSource();
            if (src == this.dftLengthBox || src == this.autoApplyCheckBox) {
                if (this.autoApplyCheckBox.isSelected()) {
                    this.applyValues();
                }
            } else {
                super.actionPerformed(ae);
            }
        }
    }

    public static enum Profile {
        PHYSICAL("Physical", null, 60.0, 0.05, 0.0),
        PHONETIC1("Phonetic1", 5000.0, 70.0, 0.005, 6.0);

        private final String value;
        private final Double maxFrequency;
        private final double dynamicRangeDB;
        private final double windowLength;
        private final double emphasisPerOctaveDB;

        private Profile(String value, Double maxFrequency, double dynamicRangeDB, double windowLength, double emphasisPerOctaveDB) {
            this.value = value;
            this.maxFrequency = maxFrequency;
            this.dynamicRangeDB = dynamicRangeDB;
            this.windowLength = windowLength;
            this.emphasisPerOctaveDB = emphasisPerOctaveDB;
        }

        public double getDynamicRangeDB() {
            return this.dynamicRangeDB;
        }

        public Double getMaxFrequency() {
            return this.maxFrequency;
        }

        public double getWindowLength() {
            return this.windowLength;
        }

        public double getEmphasisPerOctaveDB() {
            return this.emphasisPerOctaveDB;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.value);
            sb.append(": ");
            if (this.maxFrequency != null) {
                sb.append("Max freq. :" + this.maxFrequency);
                sb.append(", ");
            }
            sb.append("Window length: " + this.windowLength + " s");
            if (this.emphasisPerOctaveDB != 0.0) {
                sb.append(", ");
                sb.append("Emphasis per octave: " + this.emphasisPerOctaveDB + " dB");
            }
            return sb.toString();
        }
    }
}

