/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.dsp;

import ipsk.audio.AudioSourceException;
import ipsk.audio.arr.clip.AudioClip;
import ipsk.audio.dsp.AudioClipDSPInfo;
import ipsk.audio.dsp.FloatAudioInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;

public class AudioClipProcessor {
    public final int DEF_FRAME_BUF_SIZE = 1024;
    public final double DEF_SNR_WINDOW_SIZE = 0.1;
    private static double LN = 20.0 / Math.log(10.0);
    private int bufSize = 1024;
    protected AudioClip audioClip;
    private double[] maxAmplitudes = null;
    private double[] minAmplitudes = null;
    private boolean calculateSBNR = false;
    private double signalToBackgroundNoiseRatioWindowSize = 0.1;
    private Double[] minWindowMeanPower = null;
    private double[] maxPower = null;
    private double[] energy = null;

    public AudioClipProcessor(AudioClip audioClip) {
        this.audioClip = audioClip;
    }

    public AudioClipDSPInfo process() throws AudioSourceException {
        AudioClipDSPInfo info = null;
        FloatAudioInputStream ais = this.audioClip.getFloatAudioInputStream();
        if (ais != null) {
            info = new AudioClipDSPInfo();
            AudioFormat af = ais.getFormat();
            long frameLength = ais.getFrameLength();
            info.setAudioFormat(af);
            info.setFrameLength(frameLength);
            int channels = af.getChannels();
            if (this.calculateSBNR) {
                double sampleRate = af.getSampleRate();
                this.bufSize = (int)(sampleRate * this.signalToBackgroundNoiseRatioWindowSize);
            }
            this.minAmplitudes = new double[channels];
            this.maxAmplitudes = new double[channels];
            this.maxPower = new double[channels];
            this.energy = new double[channels];
            for (int ch = 0; ch < channels; ++ch) {
                this.minAmplitudes[ch] = Double.POSITIVE_INFINITY;
                this.maxAmplitudes[ch] = Double.NEGATIVE_INFINITY;
            }
            double[][] buf = new double[this.bufSize][channels];
            long frames = 0L;
            try {
                int r = 0;
                do {
                    int read = 0;
                    double[] bufferEnergy = new double[channels];
                    while ((r = ais.read(buf, read, this.bufSize - read)) != -1 && (read += r) < this.bufSize) {
                    }
                    if (read <= 0) continue;
                    frames += (long)read;
                    for (int i = 0; i < read; ++i) {
                        for (int ch = 0; ch < channels; ++ch) {
                            double val = buf[i][ch];
                            double power = val * val;
                            if (this.maxPower[ch] < power) {
                                this.maxPower[ch] = power;
                            }
                            int n = ch;
                            bufferEnergy[n] = bufferEnergy[n] + power;
                            int n2 = ch;
                            this.energy[n2] = this.energy[n2] + power;
                            if (this.minAmplitudes[ch] > val) {
                                this.minAmplitudes[ch] = val;
                            }
                            if (!(this.maxAmplitudes[ch] < val)) continue;
                            this.maxAmplitudes[ch] = val;
                        }
                    }
                    if (!this.calculateSBNR || read != this.bufSize) continue;
                    if (this.minWindowMeanPower == null) {
                        this.minWindowMeanPower = new Double[channels];
                    }
                    for (int ch = 0; ch < channels; ++ch) {
                        double bufferMeanPower = bufferEnergy[ch] / (double)this.bufSize;
                        if (this.minWindowMeanPower[ch] != null && !(this.minWindowMeanPower[ch] > bufferMeanPower)) continue;
                        this.minWindowMeanPower[ch] = bufferMeanPower;
                    }
                } while (r != -1);
            }
            catch (IOException e) {
                throw new AudioSourceException(e);
            }
            finally {
                if (ais != null) {
                    try {
                        ais.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new AudioSourceException(e);
                    }
                }
            }
            info.setMinAmplitudes(this.minAmplitudes);
            info.setMaxAmplitudes(this.maxAmplitudes);
            info.setMinSegmentalMeanPower(this.minWindowMeanPower);
            info.setMaxPower(this.maxPower);
            this.audioClip.setClipDSPInfo(info);
        }
        return info;
    }

    public static double getLogarithmLevel(double linLevel) {
        return (float)(LN * Math.log(2.0 * linLevel));
    }

    public static float getLogarithmLevel(float linLevel) {
        return (float)(LN * Math.log(2.0 * (double)linLevel));
    }

    public boolean isCalculateSBNR() {
        return this.calculateSBNR;
    }

    public void setCalculateSBNR(boolean calculateSBNR) {
        this.calculateSBNR = calculateSBNR;
    }

    public static void main(String[] args) {
    }
}

