/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.dsp;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.RandomAccessAudioStream;
import ipsk.audio.dsp.AudioFrameProcessor;
import javax.sound.sampled.AudioFormat;

public class FloatRandomAccessStream {
    protected AudioSource audioSource;
    protected AudioFormat audioFormat;
    protected byte[] buffer;
    protected int frameSize;
    protected RandomAccessAudioStream raas;
    protected AudioFrameProcessor bufferProcessor;

    public FloatRandomAccessStream(AudioSource audioSource) throws AudioFormatNotSupportedException, AudioSourceException {
        this.audioSource = audioSource;
        this.raas = new RandomAccessAudioStream(audioSource);
        this.audioFormat = audioSource.getFormat();
        this.frameSize = this.audioFormat.getFrameSize();
        this.buffer = new byte[0];
        this.bufferProcessor = new AudioFrameProcessor(this.audioFormat);
    }

    public void close() throws AudioSourceException {
        this.raas.close();
    }

    public int readFrames(double[][] normBuf, int frameOffset, int frames) throws AudioSourceException {
        int readFrames;
        int bytesToRead = this.frameSize * frames;
        if (this.buffer.length < bytesToRead) {
            this.buffer = new byte[bytesToRead];
        }
        if ((readFrames = this.raas.readFrames(this.buffer, 0, frames)) == -1) {
            return readFrames;
        }
        this.bufferProcessor.getNormalizedInterleavedValues(this.buffer, readFrames, normBuf, frameOffset);
        return readFrames;
    }

    public void setFramePosition(long newPos) throws AudioSourceException {
        this.raas.setPosition(newPos);
    }

    public long skipFrames(long framesToSkip) throws AudioSourceException {
        return this.raas.skipFrames(framesToSkip);
    }

    public String toString() {
        return new String("Float value audio source (scale -1 to +1) based on:" + this.audioSource.toString());
    }

    public long getFrameLength() throws AudioSourceException {
        return this.audioSource.getFrameLength();
    }

    public int getChannels() throws AudioSourceException {
        return this.audioSource.getFormat().getChannels();
    }
}

