/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.player;

import ipsk.audio.player.Player;
import ipsk.audio.player.PlayerException;
import ipsk.audio.player.PlayerListener;
import ipsk.audio.player.event.PlayerEvent;
import ipsk.audio.player.event.PlayerStartEvent;
import ipsk.audio.player.event.PlayerStopEvent;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PlayerUI
extends JFrame
implements ActionListener,
ChangeListener,
PlayerListener,
Runnable {
    JButton playB;
    JButton startB;
    JButton stopB;
    JButton pauseB;
    Player p;
    Container content = this.getContentPane();
    JSlider posSlider;
    JSlider startPosSlider;
    JSlider stopPosSlider;
    JCheckBox loopBox;
    Timer updateTimer;
    private boolean posUpdate;

    public PlayerUI(File f) throws PlayerException {
        this.content.setLayout(new FlowLayout());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                PlayerUI.this.close();
            }
        });
        Mixer.Info[] infos = AudioSystem.getMixerInfo();
        Mixer m = AudioSystem.getMixer(infos[0]);
        this.p = new Player(m, f);
        this.p.addPlayerListener(this);
        this.p.open();
        this.playB = new JButton("Play");
        this.playB.addActionListener(this);
        this.content.add(this.playB);
        this.startB = new JButton("Start");
        this.startB.addActionListener(this);
        this.content.add(this.startB);
        this.stopB = new JButton("Stop");
        this.stopB.addActionListener(this);
        this.content.add(this.stopB);
        this.pauseB = new JButton("Pause");
        this.pauseB.addActionListener(this);
        this.content.add(this.pauseB);
        this.posSlider = new JSlider();
        this.posSlider.setMinimum(0);
        this.posSlider.setMaximum((int)this.p.getFrameLength());
        this.posSlider.addChangeListener(this);
        this.startPosSlider = new JSlider();
        this.startPosSlider.setMinimum(0);
        this.startPosSlider.setMaximum((int)this.p.getFrameLength());
        this.startPosSlider.addChangeListener(this);
        this.stopPosSlider = new JSlider();
        this.stopPosSlider.setMinimum(0);
        this.stopPosSlider.setMaximum((int)this.p.getFrameLength());
        this.stopPosSlider.setValue((int)this.p.getFrameLength());
        this.stopPosSlider.addChangeListener(this);
        this.loopBox = new JCheckBox("Loop");
        this.loopBox.setSelected(this.p.isLooping());
        this.loopBox.addActionListener(this);
        this.content.add(this.posSlider);
        this.content.add(this.startPosSlider);
        this.content.add(this.stopPosSlider);
        this.content.add(this.loopBox);
        this.posUpdate = false;
        this.updateTimer = new Timer(1, this);
        this.updateTimer.start();
    }

    public void close() {
        try {
            this.p.close();
        }
        catch (PlayerException e) {
            e.printStackTrace();
        }
        this.updateTimer.stop();
        this.dispose();
        System.exit(0);
    }

    public static void main(String[] args) {
        Window playerUi = null;
        try {
            playerUi = new PlayerUI(new File(args[0]));
        }
        catch (PlayerException e) {
            e.printStackTrace();
        }
        playerUi.pack();
        playerUi.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.updateTimer) {
            long pos = this.p.getFramePosition();
            if (!this.posSlider.getValueIsAdjusting()) {
                this.posUpdate = true;
                this.posSlider.setValue((int)pos);
                this.posUpdate = false;
            }
        } else if (src == this.playB) {
            try {
                this.p.play();
            }
            catch (PlayerException ex) {
                ex.printStackTrace();
            }
        } else if (src == this.startB) {
            this.p.start();
        } else if (src == this.stopB) {
            this.p.stop();
        } else if (src == this.pauseB) {
            this.p.pause();
        } else if (src == this.loopBox) {
            this.p.setLooping(this.loopBox.isSelected());
        }
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        Object src = arg0.getSource();
        if (src == this.posSlider) {
            if (!this.posSlider.getValueIsAdjusting() && !this.posUpdate) {
                try {
                    this.p.setFramePosition(this.posSlider.getValue());
                }
                catch (PlayerException e) {
                    e.printStackTrace();
                }
            }
        } else if (src == this.startPosSlider) {
            this.p.setStartFramePosition(this.startPosSlider.getValue());
        } else if (src == this.stopPosSlider) {
            this.p.setStopFramePosition(this.stopPosSlider.getValue());
        }
    }

    @Override
    public void update(PlayerEvent playerEvent) {
        if (playerEvent instanceof PlayerStartEvent) {
            this.startB.setEnabled(false);
            this.stopB.setEnabled(true);
        } else if (playerEvent instanceof PlayerStopEvent) {
            this.stopB.setEnabled(false);
            this.startB.setEnabled(true);
        }
    }

    @Override
    public void run() {
    }
}

