/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.plugins;

import ipsk.audio.AudioPluginException;
import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.SourcePlugin;
import ipsk.audio.plugins.BasicPCMPlugin;
import ipsk.io.InsertInputStream;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class InsertPlugin
extends BasicPCMPlugin
implements SourcePlugin {
    private AudioSource insertSource;
    private long at;
    private AudioFormat af;
    private long frameLength;
    private int frameSize;

    public InsertPlugin(AudioSource insertSource, long at) {
        this.insertSource = insertSource;
        this.at = at;
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioInputStream ais) throws AudioPluginException {
        AudioInputStream insertAis;
        try {
            insertAis = this.insertSource.getAudioInputStream();
        }
        catch (AudioSourceException e) {
            throw new AudioPluginException(e);
        }
        this.frameLength = ais.getFrameLength() + insertAis.getFrameLength();
        this.af = ais.getFormat();
        AudioFormat insertAf = insertAis.getFormat();
        if (!this.af.matches(insertAf)) {
            throw new AudioPluginException("Insert audio format does not match !");
        }
        this.frameSize = this.af.getFrameSize();
        if (this.at == -1L) {
            this.at = ais.getFrameLength();
        }
        if (this.at > ais.getFrameLength()) {
            throw new AudioPluginException("Insert point is out of range.");
        }
        InsertInputStream eis = new InsertInputStream((InputStream)ais, (InputStream)insertAis, this.frameSize, this.at);
        return new AudioInputStream((InputStream)eis, this.af, this.frameLength);
    }

    @Override
    public AudioSource getAudioSource() {
        return this.insertSource;
    }
}

