/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.ui;

import ipsk.net.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class URLSelector
extends JPanel
implements ActionListener {
    private static final boolean DEBUG = false;
    private JButton browse;
    private JTextField URLNameField;
    private URL selectedURL = null;
    private JFileChooser chooser;
    private Vector<ActionListener> actionListenerList = new Vector();
    private JPanel choosePanel = new JPanel(new BorderLayout());
    private JLabel selLabel;

    public URLSelector(URL selectedURL) {
        this();
        this.setSelectedURL(selectedURL);
    }

    public URLSelector() {
        super(new GridLayout(2, 1));
        this.browse = new JButton("Browse...");
        this.URLNameField = new JTextField();
        this.choosePanel.add((Component)this.URLNameField, "Center");
        this.choosePanel.add((Component)this.browse, "East");
        this.chooser = new JFileChooser();
        this.selLabel = new JLabel();
        this.browse.addActionListener(this);
        this.URLNameField.addActionListener(this);
        this.add(this.choosePanel);
        this.add(this.selLabel);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        int returnVal;
        if (ev.getSource() == this.URLNameField) {
            try {
                this.setSelectedURL(new URL(this.URLNameField.getText()));
            }
            catch (MalformedURLException e) {
                JOptionPane.showMessageDialog(this, "URL not valid !" + e.getLocalizedMessage(), "Invalid URL", 0);
            }
            this.updateListeners();
        } else if (ev.getSource() == this.browse && (returnVal = this.chooser.showOpenDialog(this)) == 0) {
            try {
                File selFile = this.chooser.getSelectedFile();
                URL selFileURL = Utils.createAsciiURLFromFile((File)selFile);
                this.setSelectedURL(selFileURL);
            }
            catch (MalformedURLException e) {
                JOptionPane.showMessageDialog(null, "URL not valid !" + e.getMessage(), "Invalid URL", 0);
            }
            catch (URISyntaxException e) {
                JOptionPane.showMessageDialog(null, "URI syntax not valid !" + e.getMessage(), "Invalid URI", 0);
            }
            this.updateListeners();
        }
    }

    public URL getSelectedURL() {
        return this.selectedURL;
    }

    public void setSelectedURL(URL url) {
        this.selectedURL = url;
        String urlStr = this.selectedURL.toExternalForm();
        this.selLabel.setText(urlStr);
        this.URLNameField.setText(urlStr);
    }

    public synchronized void addActionListener(ActionListener acl) {
        if (acl != null && !this.actionListenerList.contains(acl)) {
            this.actionListenerList.addElement(acl);
        }
    }

    public synchronized void removeActionListener(ActionListener acl) {
        if (acl != null) {
            this.actionListenerList.removeElement(acl);
        }
    }

    protected synchronized void updateListeners() {
        for (ActionListener listener : this.actionListenerList) {
            listener.actionPerformed(new ActionEvent(this, this.hashCode(), "File has changed"));
        }
    }
}

