/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.dsp;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioSourceException;
import ipsk.audio.dsp.FloatRandomAccessStream;

public class XCorrelator {
    public static final boolean DEBUG = true;
    public static int DEFAULT_BUFSIZE = 2048;
    private FloatRandomAccessStream srcStream;
    private FloatRandomAccessStream corrStream;
    private double[][] srcBuf;
    private double[][] corrBuf;
    int channels;

    public XCorrelator(FloatRandomAccessStream srcStream, FloatRandomAccessStream corrStream) throws AudioSourceException, AudioFormatNotSupportedException {
        this.srcStream = srcStream;
        this.corrStream = corrStream;
        this.channels = srcStream.getChannels();
        int corrChannels = corrStream.getChannels();
        if (this.channels != corrChannels) {
            throw new AudioFormatNotSupportedException();
        }
        this.srcBuf = new double[DEFAULT_BUFSIZE][this.channels];
        this.corrBuf = new double[DEFAULT_BUFSIZE][this.channels];
    }

    public CorrResult correlate(long from, long to) throws AudioSourceException {
        System.out.println("Correlating from: " + from + " to: " + to);
        CorrResult res = new CorrResult(from, Double.MAX_VALUE);
        for (long srcPos = from; srcPos <= to; ++srcPos) {
            this.srcStream.setFramePosition(srcPos);
            this.corrStream.setFramePosition(0L);
            double distance = 0.0;
            int corrRead = 0;
            while ((corrRead = this.corrStream.readFrames(this.corrBuf, 0, DEFAULT_BUFSIZE)) != -1) {
                int srcR;
                for (int srcRead = 0; srcRead < corrRead; srcRead += srcR) {
                    srcR = this.srcStream.readFrames(this.srcBuf, srcRead, corrRead - srcRead);
                    if (srcR != -1) continue;
                    return res;
                }
                for (int i = 0; i < corrRead; ++i) {
                    for (int ch = 0; ch < this.channels; ++ch) {
                        distance += Math.abs(this.srcBuf[i][ch] - this.corrBuf[i][ch]);
                    }
                }
                if (!(distance > res.getMinDistance())) continue;
            }
            if (!(distance < res.getMinDistance())) continue;
            res.setMinDistance(distance);
            res.setPosition(srcPos);
        }
        return res;
    }

    public class CorrResult {
        private long position;
        private double minDistance;

        public CorrResult(long position, double minDistance) {
            this.position = position;
            this.minDistance = minDistance;
        }

        public double getMinDistance() {
            return this.minDistance;
        }

        public void setMinDistance(double minDistance) {
            this.minDistance = minDistance;
        }

        public long getPosition() {
            return this.position;
        }

        public void setPosition(long position) {
            this.position = position;
        }

        public String toString() {
            return "Correlation result: Maximum at frame position " + this.position + " with distance: " + this.minDistance;
        }
    }
}

