/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.plugins;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioPlugin;
import ipsk.audio.AudioPluginException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Control;

public class EncodingPlugin
implements AudioPlugin {
    protected AudioFormat[] supportedAudioFormats;
    protected AudioFormat inputFormat;
    protected AudioFormat outputFormat = null;
    protected AudioFormat.Encoding encoding;

    public EncodingPlugin(AudioFormat.Encoding encoding) {
        this.encoding = encoding;
        this.supportedAudioFormats = new AudioFormat[0];
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioInputStream source) throws AudioPluginException {
        if (source.getFormat().getEncoding().equals(this.encoding)) {
            return source;
        }
        if (this.outputFormat == null) {
            return AudioSystem.getAudioInputStream(this.encoding, source);
        }
        return AudioSystem.getAudioInputStream(this.outputFormat, source);
    }

    @Override
    public AudioFormat[] getSupportedInputFormats() {
        return this.supportedAudioFormats;
    }

    @Override
    public AudioFormat[] getSupportedOutputFormats(AudioFormat inputFormat) {
        return new AudioFormat[0];
    }

    @Override
    public Control[] getControls() {
        return new Control[0];
    }

    @Override
    public boolean isInputFormatSupported(AudioFormat audioFormat) {
        return AudioSystem.isConversionSupported(this.encoding, audioFormat);
    }

    @Override
    public boolean isOutputFormatSupported(AudioFormat inputFormat, AudioFormat outputFormat) {
        if (!this.isInputFormatSupported(inputFormat)) {
            return false;
        }
        if (!outputFormat.getEncoding().equals(this.encoding)) {
            return false;
        }
        return AudioSystem.isConversionSupported(outputFormat, inputFormat);
    }

    @Override
    public void setInputFormat(AudioFormat inputFormat) throws AudioFormatNotSupportedException {
        if (!this.isInputFormatSupported(inputFormat)) {
            throw new AudioFormatNotSupportedException(inputFormat);
        }
        this.inputFormat = inputFormat;
    }

    @Override
    public AudioFormat getInputFormat() {
        return this.inputFormat;
    }

    @Override
    public void setOutputFormat(AudioFormat outputFormat) throws AudioFormatNotSupportedException {
        if (!this.isOutputFormatSupported(this.inputFormat, outputFormat)) {
            throw new AudioFormatNotSupportedException(outputFormat);
        }
        this.outputFormat = outputFormat;
    }

    @Override
    public AudioFormat getOutputFormat() {
        if (this.outputFormat != null) {
            return this.outputFormat;
        }
        AudioFormat[] formats = AudioSystem.getTargetFormats(this.encoding, this.inputFormat);
        if (formats != null && formats.length > 0) {
            return formats[0];
        }
        return this.inputFormat;
    }
}

