/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.spi;

import ipsk.audio.ThreadSafeAudioSystem;
import ipsk.audio.spi.LinearConverterInputStream;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.FormatConversionProvider;

public class LinearAudioConverter
extends FormatConversionProvider {
    AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
    AudioFormat.Encoding[] encodings = new AudioFormat.Encoding[1];
    static AudioFormat srcFormat;
    AudioInputStream srcIn;
    AudioInputStream srcOut;
    static AudioFormat trgFormat;
    byte[] sample;

    public LinearAudioConverter() {
        this.encodings[0] = this.encoding;
        srcFormat = new AudioFormat(48000.0f, 32, 1, true, false);
        trgFormat = new AudioFormat(48000.0f, 16, 1, true, false);
    }

    @Override
    public AudioFormat.Encoding[] getSourceEncodings() {
        return this.encodings;
    }

    @Override
    public AudioFormat.Encoding[] getTargetEncodings() {
        return this.encodings;
    }

    @Override
    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat sourceFormat) {
        return this.encodings;
    }

    @Override
    public AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        if (sourceFormat.matches(srcFormat)) {
            AudioFormat[] fmtArr = new AudioFormat[]{trgFormat};
            return fmtArr;
        }
        return new AudioFormat[0];
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        if (targetFormat.matches(trgFormat)) {
            LinearConverterInputStream lcis = new LinearConverterInputStream(sourceStream);
            return new AudioInputStream(lcis, trgFormat, sourceStream.getFrameLength());
        }
        return null;
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioFormat.Encoding targetEncoding, AudioInputStream sourceStream) {
        if (targetEncoding != this.encoding) {
            return null;
        }
        LinearConverterInputStream lcis = new LinearConverterInputStream(sourceStream);
        return new AudioInputStream(lcis, trgFormat, sourceStream.getFrameLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        File in = new File("/homes/klausj/AAA1019Z0_0.wav");
        AudioInputStream ins = null;
        try {
            ins = AudioSystem.getAudioInputStream(in);
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LinearAudioConverter lac = new LinearAudioConverter();
        boolean supp = AudioSystem.isConversionSupported(trgFormat, srcFormat);
        File out = new File("/homes/klausj/test_16.wav");
        AudioInputStream outs = null;
        outs = lac.getAudioInputStream(trgFormat, ins);
        if (supp) {
            try {
                ThreadSafeAudioSystem.write(outs, AudioFileFormat.Type.WAVE, out);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            finally {
                if (outs != null) {
                    try {
                        outs.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

