/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio;

import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.BasicAudioSource;
import ipsk.audio.ThreadSafeAudioSystem;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import javax.sound.sampled.AudioInputStream;

public class URLAudioSource
extends BasicAudioSource
implements AudioSource {
    private URL url;

    public URLAudioSource(URL url) {
        this.url = url;
    }

    @Override
    public AudioInputStream getAudioInputStream() throws AudioSourceException {
        AudioInputStream ais = null;
        try {
            if (this.url.getProtocol().equalsIgnoreCase("file")) {
                String filePath = URLDecoder.decode(this.url.getPath(), "UTF-8");
                ais = ThreadSafeAudioSystem.getAudioInputStream(new File(filePath));
            } else {
                ais = ThreadSafeAudioSystem.getAudioInputStream(this.url);
            }
        }
        catch (Exception e) {
            throw new AudioSourceException(e);
        }
        this.setAudioFormat(ais.getFormat());
        this.setFrameLength(ais.getFrameLength());
        return ais;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }
}

