/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.dsp;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.dsp.LevelInfo;
import ipsk.audio.dsp.PeakDetector;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class LevelMeasureAudioInputStream
extends AudioInputStream {
    private static final boolean DEBUG = false;
    private static int DEFAULT_BUF_SIZE_IN_FRAMES = 2048;
    private AudioInputStream srcAudioInputStream;
    private int bufSize;
    private int frameSize;
    private int channels;
    private int available = 0;
    private int offset = 0;
    private PeakDetector abp;
    private LevelInfo[] levelInfos;

    public LevelMeasureAudioInputStream(AudioInputStream srcAudioInputStream) throws AudioFormatNotSupportedException {
        this(srcAudioInputStream, null);
    }

    public LevelMeasureAudioInputStream(AudioInputStream srcAudioInputStream, LevelInfo[] levelInfos) throws AudioFormatNotSupportedException {
        super(srcAudioInputStream, srcAudioInputStream.getFormat(), srcAudioInputStream.getFrameLength());
        this.srcAudioInputStream = srcAudioInputStream;
        AudioFormat audioFormat = srcAudioInputStream.getFormat();
        this.frameSize = audioFormat.getFrameSize();
        this.channels = audioFormat.getChannels();
        this.bufSize = DEFAULT_BUF_SIZE_IN_FRAMES * this.frameSize;
        this.abp = new PeakDetector(audioFormat);
        if (levelInfos == null) {
            levelInfos = new LevelInfo[audioFormat.getChannels()];
            for (int ch = 0; ch < this.channels; ++ch) {
                levelInfos[ch] = new LevelInfo();
            }
        }
        this.levelInfos = levelInfos;
    }

    @Override
    public int available() throws IOException {
        int srcAvail = this.srcAudioInputStream.available();
        if (srcAvail > this.bufSize) {
            return this.bufSize;
        }
        return srcAvail;
    }

    @Override
    public void close() throws IOException {
        this.available = 0;
        this.offset = 0;
        this.srcAudioInputStream.close();
        this.resetLevels();
    }

    @Override
    public AudioFormat getFormat() {
        return this.srcAudioInputStream.getFormat();
    }

    @Override
    public long getFrameLength() {
        return this.srcAudioInputStream.getFrameLength();
    }

    @Override
    public synchronized void mark(int arg0) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.frameSize != 1) {
            throw new IOException("read method only allowed for frame size == 1");
        }
        byte[] buf = new byte[1];
        int read = this.read(buf, 0, 1);
        if (read == -1) {
            return -1;
        }
        return 0xFF & read;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    private void resetLevels() {
        for (int ch = 0; ch < this.channels; ++ch) {
            this.levelInfos[ch].setLevel(0.0f);
            this.levelInfos[ch].setPeakLevel(0.0f);
        }
    }

    @Override
    public int read(byte[] buf, int trgOffset, int len) throws IOException {
        if (len % this.frameSize != 0) {
            len -= len % this.frameSize;
        }
        int read = 0;
        read = this.srcAudioInputStream.read(buf, trgOffset, len);
        if (read == -1) {
            this.resetLevels();
            return read;
        }
        if (read > 0) {
            this.abp.processBuffer(buf, trgOffset, read, this.levelInfos);
        }
        return read;
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    public long skip(long arg0) throws IOException {
        long toSkip = arg0;
        if (this.available > 0) {
            if ((long)this.available <= toSkip) {
                toSkip = this.available;
            }
            this.offset = (int)((long)this.offset + toSkip);
            this.available = (int)((long)this.available - toSkip);
            if (this.offset == this.bufSize) {
                this.offset = 0;
            }
            return toSkip;
        }
        return this.srcAudioInputStream.skip(toSkip);
    }

    public String toString() {
        return new String("Level measuring audio stream based on:" + this.srcAudioInputStream.toString());
    }

    public LevelInfo[] getLevelInfos() {
        return this.levelInfos;
    }

    public void resetPeakHold() {
        if (this.levelInfos != null) {
            for (LevelInfo li : this.levelInfos) {
                li.setPeakLevelHold(0.0f);
            }
        }
    }

    public float[] getPeakLevelHold() {
        float[] plhs = null;
        if (this.levelInfos != null) {
            int lsl = this.levelInfos.length;
            plhs = new float[lsl];
            for (int i = 0; i < lsl; ++i) {
                plhs[i] = this.levelInfos[i].getPeakLevelHold();
            }
        }
        return plhs;
    }
}

