/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.dsp;

import ipsk.audio.dsp.LevelInfo;
import ipsk.audio.dsp.LevelInfosBean;
import ipsk.audio.io.push.FloatAudioOutputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;

public class LevelMeasureFloatAudioOutputStream
implements FloatAudioOutputStream {
    private static final boolean DEBUG = false;
    protected static double LN = 20.0 / Math.log(10.0);
    private double[] max;
    private double[] min;
    private double[] absSum;
    private int channels;
    private LevelInfo[] levelInfos;
    private LevelInfosBean levelInfosBean = new LevelInfosBean();

    public void setChannels(int channels) {
        if (this.channels != channels) {
            this.channels = channels;
            this.max = new double[channels];
            this.min = new double[channels];
            this.absSum = new double[channels];
            this.levelInfos = new LevelInfo[channels];
            for (int i = 0; i < channels; ++i) {
                this.levelInfos[i] = new LevelInfo();
            }
            this.levelInfosBean.setLevelInfos(this.levelInfos);
        }
    }

    public void write(double[][] buf, int offset, int len) throws IOException {
        int ch;
        if (this.levelInfos.length != this.channels) {
            throw new IllegalArgumentException("Level info array must match channel count !");
        }
        for (int i = 0; i < this.channels; ++i) {
            this.max[i] = Double.NEGATIVE_INFINITY;
            this.min[i] = Double.POSITIVE_INFINITY;
            this.absSum[i] = 0.0;
        }
        int frames = len;
        if (frames == 0) {
            for (int i = 0; i < this.levelInfos.length; ++i) {
                this.levelInfos[i].setLevel(0.0f);
                this.levelInfos[i].setPeakLevel(0.0f);
            }
        }
        for (int i = 0; i < frames; ++i) {
            for (ch = 0; ch < this.channels; ++ch) {
                double v = buf[offset + i][ch];
                int n = ch;
                this.absSum[n] = this.absSum[n] + Math.abs(v);
                if (v > this.max[ch]) {
                    this.max[ch] = v;
                }
                if (!(v < this.min[ch])) continue;
                this.min[ch] = v;
            }
        }
        for (ch = 0; ch < this.channels; ++ch) {
            LevelInfo li = this.levelInfos[ch];
            li.setLevel((float)(this.absSum[ch] / (double)frames));
            double peakLevel = Math.max(Math.abs(this.max[ch]), Math.abs(this.min[ch]));
            li.setPeakLevel((float)peakLevel);
            double currentPeakLevelHold = li.getPeakLevelHold();
            if (!(currentPeakLevelHold < peakLevel)) continue;
            li.setPeakLevelHold((float)peakLevel);
        }
    }

    public void close() throws IOException {
        for (int i = 0; i < this.channels; ++i) {
            this.levelInfos[i].setLevel(0.0f);
            this.levelInfos[i].setPeakLevel(0.0f);
        }
    }

    public void flush() throws IOException {
    }

    @Override
    public void setAudioFormat(AudioFormat audioFormat) {
        this.setChannels(audioFormat.getChannels());
    }

    public LevelInfosBean getLevelInfosBean() {
        return this.levelInfosBean;
    }

    public void setLevelInfosBean(LevelInfosBean levelInfosBean) {
        this.levelInfosBean = levelInfosBean;
    }
}

