/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.mixer.ui;

import ipsk.audio.mixer.ui.ControlUI;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.sound.sampled.BooleanControl;
import javax.swing.JCheckBox;

public class BooleanControlUI
extends ControlUI
implements ActionListener {
    private BooleanControl bc;
    private JCheckBox checkBox;
    private boolean updating = false;

    public BooleanControlUI(BooleanControl bc) {
        this.bc = bc;
        this.checkBox = new JCheckBox(bc.getType().toString());
        this.updateValue();
        this.checkBox.addActionListener(this);
        this.add(this.checkBox);
    }

    @Override
    public void setFont(Font newFont) {
        if (this.checkBox != null) {
            this.checkBox.setFont(newFont);
        }
        super.setFont(newFont);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (!this.updating) {
            this.bc.setValue(this.checkBox.isSelected());
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.checkBox.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    @Override
    public void updateValue() {
        boolean s = this.bc.getValue();
        if (s != this.checkBox.isSelected()) {
            this.updating = true;
            this.checkBox.setSelected(s);
            this.updating = false;
        }
    }
}

