/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.synth;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.dsp.AudioFrameProcessor;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;

public class SineWaveGenerator
extends InputStream {
    private long position;
    private AudioFrameProcessor ap;
    private int channels;
    private float sampleRate;
    private int frameSize;
    private int bufPos;
    private long length;
    private int periodValues;
    private byte[] periodBuf;
    private int bufSize;

    public SineWaveGenerator(float frequency, float amplitudeFactor, AudioFormat audioFormat, long length) throws AudioFormatNotSupportedException {
        this.length = length;
        this.sampleRate = audioFormat.getSampleRate();
        this.channels = audioFormat.getChannels();
        this.periodValues = (int)this.sampleRate;
        this.ap = new AudioFrameProcessor(audioFormat);
        this.frameSize = this.ap.getFrameSize();
        this.bufSize = this.frameSize * this.periodValues;
        this.periodBuf = new byte[this.bufSize];
        float[] values = new float[this.frameSize];
        int offset = 0;
        for (int i = 0; i < this.periodValues; ++i) {
            double timePos = (double)i / (double)this.sampleRate;
            double phase = timePos * (double)frequency * 2.0 * Math.PI;
            float ampl = (float)Math.sin(phase) * amplitudeFactor;
            for (int ch = 0; ch < this.channels; ++ch) {
                values[ch] = ampl;
            }
            this.ap.encodeValues(values, this.periodBuf, offset);
            offset += this.frameSize;
        }
        this.close();
    }

    @Override
    public void close() {
        this.bufPos = 0;
        this.position = 0L;
    }

    @Override
    public int read() throws IOException {
        if (this.position == this.length) {
            return -1;
        }
        int retVal = 0xFF & this.periodBuf[this.bufPos++];
        if (this.bufPos == this.bufSize) {
            this.bufPos = 0;
        }
        if (this.bufPos % this.frameSize == 0) {
            ++this.position;
        }
        return retVal;
    }

    @Override
    public int read(byte[] buf, int offset, int len) throws IOException {
        long rest;
        if (this.length != -1L && this.position >= this.length) {
            return -1;
        }
        int toFill = this.bufPos % this.frameSize;
        if (toFill != 0) {
            if (len < toFill) {
                toFill = len;
            }
            for (int i = 0; i < toFill; ++i) {
                buf[offset + i] = this.periodBuf[this.bufPos++];
            }
            if (this.bufPos == this.bufSize) {
                this.bufPos = 0;
            }
            if (this.bufPos % this.frameSize == 0) {
                ++this.position;
            }
            return toFill;
        }
        int available = this.bufSize - this.bufPos;
        int toCopy = len;
        if (available < toCopy) {
            toCopy = available;
        }
        if (this.length != -1L && (rest = (this.length - this.position) * (long)this.frameSize) < Integer.MAX_VALUE && (long)toCopy > rest) {
            toCopy = (int)rest;
        }
        System.arraycopy(this.periodBuf, this.bufPos, buf, offset, toCopy);
        this.bufPos += toCopy;
        if (this.bufPos == this.bufSize) {
            this.bufPos = 0;
        }
        this.position += (long)(toCopy / this.frameSize);
        return toCopy;
    }
}

